/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.util.List;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.InstallMetaData;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.KernelControllerContextAction;
import org.jboss.kernel.plugins.dependency.SecurityActions;
import org.jboss.kernel.plugins.dispatch.InvokeDispatchHelper;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;

public abstract class InstallsAwareAction
extends KernelControllerContextAction {
    protected abstract ControllerState getState();

    public void installAction(KernelControllerContext context) throws Throwable {
        this.installActionInternal(context);
        this.doInstalls(context);
        this.setKernelControllerContext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInstalls(KernelControllerContext context) throws Throwable {
        KernelController controller = (KernelController)context.getController();
        Kernel kernel = controller.getKernel();
        KernelConfigurator configurator = kernel.getConfigurator();
        BeanMetaData metaData = context.getBeanMetaData();
        List installs = metaData.getInstalls();
        if (installs != null && !installs.isEmpty()) {
            int index;
            try {
                int size = installs.size();
                for (index = 0; index < size; ++index) {
                    InstallMetaData install = (InstallMetaData)installs.get(index);
                    if (!this.getState().equals((Object)install.getState())) continue;
                    KernelControllerContext target = context;
                    if (install.getBean() != null) {
                        target = controller.getContext((Object)install.getBean(), install.getDependentState());
                    }
                    if (target instanceof InvokeDispatchContext) {
                        ClassLoader previous = SecurityActions.setContextClassLoader(context);
                        try {
                            InvokeDispatchHelper.invoke(configurator, target.getTarget(), (InvokeDispatchContext)target, install.getMethodName(), install.getParameters());
                            continue;
                        }
                        finally {
                            SecurityActions.resetContextClassLoader(previous);
                        }
                    }
                    throw new IllegalArgumentException("Cannot install, context " + target + " does not implement InvokeDispatchContext");
                }
            }
            catch (Throwable t) {
                this.considerUninstalls(context, index);
                this.undoInstallAction(context);
                throw t;
            }
        }
    }

    protected void considerUninstalls(KernelControllerContext context, int index) {
        if (index > 0) {
            this.doUninstalls(context);
        }
    }

    protected void undoInstallAction(KernelControllerContext context) {
        this.uninstallActionInternal(context);
    }

    public void uninstallAction(KernelControllerContext context) {
        this.unsetKernelControllerContext(context);
        this.doUninstalls(context);
        this.uninstallActionInternal(context);
    }

    protected void doUninstalls(KernelControllerContext context) {
        BeanMetaData beanMetaData = context.getBeanMetaData();
        List uninstalls = beanMetaData.getUninstalls();
        int size = uninstalls != null ? uninstalls.size() : 0;
        this.doUninstalls(context, size - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUninstalls(KernelControllerContext context, int index) {
        KernelController controller = (KernelController)context.getController();
        Kernel kernel = controller.getKernel();
        KernelConfigurator configurator = kernel.getConfigurator();
        BeanMetaData metaData = context.getBeanMetaData();
        List uninstalls = metaData.getUninstalls();
        if (uninstalls != null && !uninstalls.isEmpty()) {
            for (int i = index; i >= 0; --i) {
                InstallMetaData uninstall = (InstallMetaData)uninstalls.get(i);
                if (!this.getState().equals((Object)uninstall.getState())) continue;
                KernelControllerContext target = context;
                if (uninstall.getBean() != null && (target = controller.getContext((Object)uninstall.getBean(), uninstall.getDependentState())) == null) {
                    this.log.warn((Object)("Ignoring uninstall action on target in incorrect state " + uninstall.getBean()));
                    continue;
                }
                if (target instanceof InvokeDispatchContext) {
                    ClassLoader previous = null;
                    try {
                        previous = SecurityActions.setContextClassLoader(context);
                        InvokeDispatchHelper.invoke(configurator, target.getTarget(), (InvokeDispatchContext)target, uninstall.getMethodName(), uninstall.getParameters());
                        continue;
                    }
                    catch (Throwable t) {
                        this.log.warn((Object)("Ignoring uninstall action on target " + uninstall), t);
                        continue;
                    }
                    finally {
                        if (previous != null) {
                            SecurityActions.resetContextClassLoader(previous);
                        }
                    }
                }
                this.log.warn((Object)("Cannot uninstall, context " + target + " does not implement InvokeDispatchContext for " + uninstall.getBean()));
            }
        }
    }
}

