/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.deployment.xml;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jboss.beans.info.spi.BeanAccessMode;
import org.jboss.beans.metadata.api.model.AutowireType;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.xml.sax.Attributes;

public class BeanHandler
extends DefaultElementHandler {
    public static final BeanHandler HANDLER = new BeanHandler();

    public Object startElement(Object parent, QName name, ElementBinding element) {
        return new AbstractBeanMetaData();
    }

    public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx) {
        AbstractBeanMetaData bean = (AbstractBeanMetaData)o;
        for (int i = 0; i < attrs.getLength(); ++i) {
            String localName = attrs.getLocalName(i);
            if ("name".equals(localName)) {
                bean.setName(attrs.getValue(i));
                continue;
            }
            if ("class".equals(localName)) {
                bean.setBean(attrs.getValue(i));
                continue;
            }
            if ("mode".equals(localName)) {
                bean.setMode(ControllerMode.getInstance((String)attrs.getValue(i)));
                continue;
            }
            if ("access-mode".equals(localName)) {
                BeanAccessMode mode = BeanAccessMode.STANDARD;
                if ("fields".equalsIgnoreCase(localName)) {
                    mode = BeanAccessMode.FIELDS;
                } else if ("all".equalsIgnoreCase(localName)) {
                    mode = BeanAccessMode.ALL;
                }
                bean.setAccessMode(mode);
                continue;
            }
            if ("parent".equals(localName)) {
                bean.setParent(attrs.getValue(i));
                continue;
            }
            if ("abstract".equals(localName)) {
                bean.setAbstract(Boolean.parseBoolean(attrs.getValue(i)));
                continue;
            }
            if ("autowire-type".equals(localName)) {
                bean.setAutowireType(AutowireType.getInstance((String)attrs.getValue(i)));
                continue;
            }
            if (!"autowire-candidate".equals(localName)) continue;
            bean.setAutowireCandidate(Boolean.parseBoolean(attrs.getValue(i)));
        }
    }

    public Object endElement(Object o, QName qName, ElementBinding element) {
        AbstractBeanMetaData bean = (AbstractBeanMetaData)o;
        if (bean.getBean() == null && !bean.isAbstract() && bean.getParent() == null) {
            ConstructorMetaData constructor = bean.getConstructor();
            if (constructor == null) {
                throw new IllegalArgumentException("Bean should have a class attribute or a constructor element.");
            }
            if (constructor.getFactoryMethod() == null) {
                if (constructor.getValue() == null) {
                    throw new IllegalArgumentException("Bean should have a class attribute or the constructor element should have either a factoryMethod attribute or embedded value.");
                }
            } else if (constructor.getFactory() == null && constructor.getFactoryClass() == null) {
                throw new IllegalArgumentException("Bean should have a class attribute or the constructor element should have one of a factoryClass attribute or a factory element, or embedded value.");
            }
        }
        return bean;
    }
}

