/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.annotations.test.field;

import junit.framework.Assert;
import junit.framework.Test;
import org.jboss.beans.info.spi.BeanAccessMode;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.kernel.plugins.annotations.BeanAnnotationAdapter;
import org.jboss.kernel.plugins.annotations.BeanAnnotationAdapterFactory;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.test.kernel.annotations.support.AfterInstallVerifier;
import org.jboss.test.kernel.annotations.support.CallbacksTester;
import org.jboss.test.kernel.annotations.support.InjectTester;
import org.jboss.test.kernel.annotations.support.MyDeployer;
import org.jboss.test.kernel.annotations.support.TestBean;
import org.jboss.test.kernel.annotations.support.ValueFactoryTester;
import org.jboss.test.kernel.annotations.test.AbstractBeanAnnotationAdapterTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicFieldAnnotationSupportTestCase
extends AbstractBeanAnnotationAdapterTest {
    public BasicFieldAnnotationSupportTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return BasicFieldAnnotationSupportTestCase.suite(BasicFieldAnnotationSupportTestCase.class);
    }

    @Override
    protected BeanAnnotationAdapter getBeanAnnotationAdapterClass() {
        return BeanAnnotationAdapterFactory.getInstance().getBeanAnnotationAdapter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void testFields(T target, AfterInstallVerifier<T> verifier, BeanAccessMode mode) throws Throwable {
        this.addVerifier(verifier);
        try {
            this.runAnnotationsOnTarget(target, mode);
        }
        finally {
            this.removeVerifier(target.getClass());
        }
    }

    public void testInjection() throws Throwable {
        KernelController controller = this.getController();
        controller.install((BeanMetaData)new AbstractBeanMetaData("pb1", TestBean.class.getName()));
        controller.install((BeanMetaData)new AbstractBeanMetaData("pb2", TestBean.class.getName()));
        controller.install((BeanMetaData)new AbstractBeanMetaData("pb3", TestBean.class.getName()));
        controller.install((BeanMetaData)new AbstractBeanMetaData("deployer", MyDeployer.class.getName()));
        InjectTester tester = new InjectTester();
        this.testFields(tester, new InjectTesterVerifier(), BeanAccessMode.FIELDS);
        this.assertTesterAfterUninstall(tester);
        this.testFields(tester, new AllInjectTesterVerifier(), BeanAccessMode.ALL);
        this.assertTesterAfterUninstall(tester);
    }

    protected void assertTesterAfterUninstall(InjectTester tester) {
        BasicFieldAnnotationSupportTestCase.assertNull((Object)tester.getPrivateBean());
        BasicFieldAnnotationSupportTestCase.assertNull((Object)tester.getProtectedBean());
        BasicFieldAnnotationSupportTestCase.assertNull((Object)tester.publicBean);
        BasicFieldAnnotationSupportTestCase.assertNull((Object)tester.getPrivateDeployer());
        BasicFieldAnnotationSupportTestCase.assertNull((Object)tester.getProtectedDeployer());
        BasicFieldAnnotationSupportTestCase.assertNull((Object)tester.publicDeployer);
    }

    public void testValueFactory() throws Throwable {
        KernelController controller = this.getController();
        controller.install((BeanMetaData)new AbstractBeanMetaData("pb1", TestBean.class.getName()));
        controller.install((BeanMetaData)new AbstractBeanMetaData("pb2", TestBean.class.getName()));
        controller.install((BeanMetaData)new AbstractBeanMetaData("pb3", TestBean.class.getName()));
        ValueFactoryTester tester = new ValueFactoryTester();
        this.testFields(tester, new VFTesterVerifier(), BeanAccessMode.FIELDS);
        this.assertTesterAfterInstall(tester);
        this.testFields(tester, new AllVFTesterVerifier(), BeanAccessMode.ALL);
        this.assertTesterAfterInstall(tester);
    }

    protected void assertTesterAfterInstall(ValueFactoryTester tester) {
        BasicFieldAnnotationSupportTestCase.assertNull((Object)tester.getPrivateBean());
        BasicFieldAnnotationSupportTestCase.assertNull((Object)tester.getProtectedBean());
        BasicFieldAnnotationSupportTestCase.assertNull((Object)tester.publicBean);
    }

    public void testInstalls() throws Throwable {
        KernelController controller = this.getController();
        controller.install((BeanMetaData)new AbstractBeanMetaData("pb1", TestBean.class.getName()));
        controller.install((BeanMetaData)new AbstractBeanMetaData("pb2", TestBean.class.getName()));
        controller.install((BeanMetaData)new AbstractBeanMetaData("pb3", TestBean.class.getName()));
        CallbacksTester tester = new CallbacksTester();
        this.testFields(tester, new CallbacksTesterVerifier(), BeanAccessMode.FIELDS);
        this.assertTesterAfterInstall(tester);
        this.testFields(tester, new AllCallbacksTesterVerifier(), BeanAccessMode.ALL);
        this.assertTesterAfterInstall(tester);
    }

    protected void assertTesterAfterInstall(CallbacksTester tester) {
        BasicFieldAnnotationSupportTestCase.assertTrue((tester.getPrivateBeans() == null || tester.getPrivateBeans().isEmpty() ? 1 : 0) != 0);
        BasicFieldAnnotationSupportTestCase.assertTrue((tester.getProtectedBeans() == null || tester.getProtectedBeans().isEmpty() ? 1 : 0) != 0);
        BasicFieldAnnotationSupportTestCase.assertTrue((tester.publicBeans == null || tester.publicBeans.isEmpty() ? 1 : 0) != 0);
    }

    private class AllCallbacksTesterVerifier
    extends CallbacksTesterVerifier {
        private AllCallbacksTesterVerifier() {
        }

        public void verify(CallbacksTester target) {
            super.verify(target);
            Assert.assertNotNull(target.getProtectedBeans());
            Assert.assertEquals((int)3, (int)target.getProtectedBeans().size());
            Assert.assertNotNull(target.getPrivateBeans());
            Assert.assertEquals((int)3, (int)target.getPrivateBeans().size());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CallbacksTesterVerifier
    implements AfterInstallVerifier<CallbacksTester> {
        private CallbacksTesterVerifier() {
        }

        @Override
        public void verify(CallbacksTester target) {
            Assert.assertNotNull(target.publicBeans);
            Assert.assertEquals((int)3, (int)target.publicBeans.size());
        }

        @Override
        public Class<CallbacksTester> getTargetClass() {
            return CallbacksTester.class;
        }
    }

    private class AllVFTesterVerifier
    extends VFTesterVerifier {
        private AllVFTesterVerifier() {
        }

        public void verify(ValueFactoryTester target) {
            super.verify(target);
            Assert.assertEquals((String)"PB1", (String)target.getPrivateBean());
            Assert.assertEquals((String)"PB2", (String)target.getProtectedBean());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VFTesterVerifier
    implements AfterInstallVerifier<ValueFactoryTester> {
        private VFTesterVerifier() {
        }

        @Override
        public void verify(ValueFactoryTester target) {
            Assert.assertEquals((String)"PB3", (String)target.publicBean);
        }

        @Override
        public Class<ValueFactoryTester> getTargetClass() {
            return ValueFactoryTester.class;
        }
    }

    private class AllInjectTesterVerifier
    extends InjectTesterVerifier {
        private AllInjectTesterVerifier() {
        }

        public void verify(InjectTester target) {
            super.verify(target);
            Assert.assertNotNull((Object)target.getPrivateBean());
            Assert.assertNotNull((Object)target.getProtectedBean());
            Assert.assertNotNull((Object)target.getPrivateDeployer());
            Assert.assertNotNull((Object)target.getProtectedDeployer());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InjectTesterVerifier
    implements AfterInstallVerifier<InjectTester> {
        private InjectTesterVerifier() {
        }

        @Override
        public void verify(InjectTester target) {
            Assert.assertNotNull((Object)target.publicBean);
            Assert.assertNotNull((Object)target.publicDeployer);
        }

        @Override
        public Class<InjectTester> getTargetClass() {
            return InjectTester.class;
        }
    }
}

