/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.config.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployer;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployment;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.test.kernel.config.support.SimpleBean;
import org.jboss.test.kernel.config.support.SimpleLifecycleBean;
import org.jboss.test.kernel.config.test.AbstractKernelConfigTest;

public class BeanMetaDataBuilderTestCase
extends AbstractKernelConfigTest {
    public static Test suite() {
        return BeanMetaDataBuilderTestCase.suite(BeanMetaDataBuilderTestCase.class);
    }

    public BeanMetaDataBuilderTestCase(String name) throws Throwable {
        super(name);
    }

    public void testConstructor() throws Throwable {
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)"FromBMD", (String)SimpleBean.class.getName());
        builder.addConstructorParameter(String.class.getName(), "TestConstructor");
        BeanMetaData beanMetaData = builder.getBeanMetaData();
        SimpleBean fbmd = (SimpleBean)this.instantiateAndConfigure(beanMetaData);
        BeanMetaDataBuilderTestCase.assertNotNull((Object)fbmd);
        BeanMetaDataBuilderTestCase.assertNotNull((Object)fbmd.getConstructorUsed());
        BeanMetaDataBuilderTestCase.assertEquals((String)"TestConstructor", (String)fbmd.getConstructorUsed());
    }

    public void testProperty() throws Throwable {
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)"PropBMD", (String)SimpleBean.class.getName()).addPropertyMetaData("adouble", (Object)3.1459).addPropertyMetaData("anint", "123").addPropertyMetaData("collection", new ArrayList());
        BeanMetaData beanMetaData = builder.getBeanMetaData();
        SimpleBean pbmd = (SimpleBean)this.instantiateAndConfigure(beanMetaData);
        BeanMetaDataBuilderTestCase.assertNotNull((Object)pbmd);
        this.assertEquals(3.1459, pbmd.getAdouble());
        BeanMetaDataBuilderTestCase.assertEquals((int)123, (int)pbmd.getAnint());
        BeanMetaDataBuilderTestCase.assertNotNull(pbmd.getCollection());
        BeanMetaDataBuilderTestCase.assertTrue((boolean)pbmd.getCollection().isEmpty());
    }

    public void testLifecycle() throws Throwable {
        Kernel kernel = this.bootstrap();
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)"SLB", (String)SimpleLifecycleBean.class.getName()).addCreateParameter(String.class.getName(), "ParamCreate").setStart("doStart").addStartParameter(String.class.getName(), "ParamStart").setStop("doStop").addStopParameter(String.class.getName(), "ParamStop").addDestroyParameter(String.class.getName(), "ParamDestroy");
        BeanMetaData beanMetaData = builder.getBeanMetaData();
        KernelController controller = kernel.getController();
        KernelControllerContext context = controller.install(beanMetaData);
        SimpleLifecycleBean slb = (SimpleLifecycleBean)context.getTarget();
        BeanMetaDataBuilderTestCase.assertNotNull((Object)slb);
        BeanMetaDataBuilderTestCase.assertEquals((String)"ParamCreate", (String)slb.getCreate());
        BeanMetaDataBuilderTestCase.assertEquals((String)"ParamStart", (String)slb.getStart());
        controller.uninstall((Object)"SLB");
        BeanMetaDataBuilderTestCase.assertEquals((String)"ParamStop", (String)slb.getStop());
        BeanMetaDataBuilderTestCase.assertEquals((String)"ParamDestroy", (String)slb.getDestroy());
    }

    public void testInstall() throws Throwable {
        Kernel kernel = this.bootstrap();
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)"SLB", (String)SimpleLifecycleBean.class.getName()).addInstall("installParam", String.class.getName(), "Install").addUninstall("uninstallParam", String.class.getName(), "Uninstall");
        BeanMetaData beanMetaData = builder.getBeanMetaData();
        KernelController controller = kernel.getController();
        KernelControllerContext context = controller.install(beanMetaData);
        SimpleLifecycleBean slb = (SimpleLifecycleBean)context.getTarget();
        BeanMetaDataBuilderTestCase.assertNotNull((Object)slb);
        BeanMetaDataBuilderTestCase.assertEquals((String)"Install", (String)slb.getInstall());
        controller.uninstall((Object)"SLB");
        BeanMetaDataBuilderTestCase.assertEquals((String)"Uninstall", (String)slb.getInstall());
    }

    public void testDemandSupply() throws Throwable {
        BeanMetaDataBuilder demand = BeanMetaDataBuilderFactory.createBuilder((String)"DemandBean", (String)SimpleBean.class.getName());
        demand.addDemand((Object)"Barrier");
        BeanMetaData demandBean = demand.getBeanMetaData();
        BeanMetaDataBuilder supply = BeanMetaDataBuilderFactory.createBuilder((String)"SupplyBean", (String)SimpleLifecycleBean.class.getName());
        supply.addSupply((Object)"Barrier");
        BeanMetaData supplyBean = supply.getBeanMetaData();
        AbstractKernelDeployment deployment = new AbstractKernelDeployment();
        deployment.setBeans(Arrays.asList(demandBean, supplyBean));
        Kernel kernel = this.bootstrap();
        KernelController controller = kernel.getController();
        AbstractKernelDeployer deployer = new AbstractKernelDeployer(kernel);
        deployer.deploy((KernelDeployment)deployment);
        Object db = controller.getInstalledContext((Object)"DemandBean").getTarget();
        BeanMetaDataBuilderTestCase.assertNotNull((Object)db);
        Object sb = controller.getInstalledContext((Object)"SupplyBean").getTarget();
        BeanMetaDataBuilderTestCase.assertNotNull((Object)sb);
        deployer.undeploy((KernelDeployment)deployment);
    }

    public void testDependency() throws Throwable {
        BeanMetaDataBuilder dependOn = BeanMetaDataBuilderFactory.createBuilder((String)"DependOnBean", (String)SimpleBean.class.getName());
        dependOn.addDependency((Object)"DependencyResolver");
        BeanMetaData dependOnBean = dependOn.getBeanMetaData();
        BeanMetaDataBuilder resolver = BeanMetaDataBuilderFactory.createBuilder((String)"DependencyResolver", (String)SimpleLifecycleBean.class.getName());
        BeanMetaData resolverBean = resolver.getBeanMetaData();
        AbstractKernelDeployment deployment = new AbstractKernelDeployment();
        deployment.setBeans(Arrays.asList(dependOnBean, resolverBean));
        Kernel kernel = this.bootstrap();
        KernelController controller = kernel.getController();
        AbstractKernelDeployer deployer = new AbstractKernelDeployer(kernel);
        deployer.deploy((KernelDeployment)deployment);
        Object db = controller.getInstalledContext((Object)"DependOnBean").getTarget();
        BeanMetaDataBuilderTestCase.assertNotNull((Object)db);
        Object rb = controller.getInstalledContext((Object)"DependencyResolver").getTarget();
        BeanMetaDataBuilderTestCase.assertNotNull((Object)rb);
        deployer.undeploy((KernelDeployment)deployment);
    }

    public void testCollectionProperties() throws Throwable {
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)"CollectionBean", (String)SimpleBean.class.getName());
        List array = builder.createArray();
        array.add(builder.createValue((Object)new Integer(5)));
        array.add(builder.createValue((Object)new Integer(10)));
        builder.addPropertyMetaData("array", (Collection)array);
        List list = builder.createList();
        list.add(builder.createValue((Object)"One"));
        list.add(builder.createValue((Object)"Two"));
        builder.addPropertyMetaData("list", (Collection)list);
        Set set = builder.createSet();
        set.add(builder.createValue((Object)"En"));
        set.add(builder.createValue((Object)"To"));
        builder.addPropertyMetaData("set", (Collection)set);
        Collection collection = builder.createCollection();
        collection.add(builder.createValue((Object)"Eins"));
        collection.add(builder.createValue((Object)"Zwei"));
        builder.addPropertyMetaData("collection", collection);
        Map map = builder.createMap();
        map.put(builder.createValue((Object)"One"), builder.createValue((Object)"Uno"));
        map.put(builder.createValue((Object)"Two"), builder.createValue((Object)"Dos"));
        builder.addPropertyMetaData("map", map);
        AbstractKernelDeployment deployment = new AbstractKernelDeployment();
        deployment.setBeans(Arrays.asList(builder.getBeanMetaData()));
        Kernel kernel = this.bootstrap();
        KernelController controller = kernel.getController();
        AbstractKernelDeployer deployer = new AbstractKernelDeployer(kernel);
        deployer.deploy((KernelDeployment)deployment);
        Object o = controller.getInstalledContext((Object)"CollectionBean").getTarget();
        BeanMetaDataBuilderTestCase.assertNotNull((Object)o);
        this.assertInstanceOf(o, SimpleBean.class);
        SimpleBean bean = (SimpleBean)o;
        Object[] arr = bean.getArray();
        BeanMetaDataBuilderTestCase.assertEquals((int)2, (int)arr.length);
        BeanMetaDataBuilderTestCase.assertEquals((Object)5, (Object)arr[0]);
        BeanMetaDataBuilderTestCase.assertEquals((Object)10, (Object)arr[1]);
        List<?> lst = bean.getList();
        BeanMetaDataBuilderTestCase.assertEquals((int)2, (int)lst.size());
        BeanMetaDataBuilderTestCase.assertEquals((Object)"One", lst.get(0));
        BeanMetaDataBuilderTestCase.assertEquals((Object)"Two", lst.get(1));
        Set<?> st = bean.getSet();
        BeanMetaDataBuilderTestCase.assertEquals((int)2, (int)lst.size());
        BeanMetaDataBuilderTestCase.assertTrue((boolean)st.contains("En"));
        BeanMetaDataBuilderTestCase.assertTrue((boolean)st.contains("To"));
        Collection<?> coll = bean.getCollection();
        BeanMetaDataBuilderTestCase.assertEquals((int)2, (int)lst.size());
        BeanMetaDataBuilderTestCase.assertTrue((boolean)coll.contains("Eins"));
        BeanMetaDataBuilderTestCase.assertTrue((boolean)coll.contains("Zwei"));
        Map<?, ?> mp = bean.getMap();
        BeanMetaDataBuilderTestCase.assertEquals((int)2, (int)mp.size());
        BeanMetaDataBuilderTestCase.assertEquals((Object)"Uno", mp.get("One"));
        BeanMetaDataBuilderTestCase.assertEquals((Object)"Dos", mp.get("Two"));
    }

    public void testReplacePropertyMetaData() throws Throwable {
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)"ReplaceBean", (String)SimpleBean.class.getName());
        builder.addPropertyMetaData("anInt", (Object)new Integer(1));
        builder.addPropertyMetaData("anInt", (Object)new Integer(5));
        builder.addPropertyMetaData("AString", "One");
        builder.addPropertyMetaData("AString", "Two");
        ValueMetaData value = builder.createValue((Object)"Three");
        builder.addPropertyMetaData("anObject", value);
        value = builder.createValue((Object)"Four");
        builder.addPropertyMetaData("anObject", value);
        List array = builder.createArray();
        builder.addPropertyMetaData("array", (Collection)array);
        array = builder.createArray();
        array.add(builder.createValue((Object)new Integer(5)));
        array.add(builder.createValue((Object)new Integer(10)));
        builder.addPropertyMetaData("array", (Collection)array);
        Map map = builder.createMap();
        builder.addPropertyMetaData("map", map);
        map = builder.createMap();
        map.put(builder.createValue((Object)"One"), builder.createValue((Object)"Uno"));
        map.put(builder.createValue((Object)"Two"), builder.createValue((Object)"Dos"));
        builder.addPropertyMetaData("map", map);
        AbstractKernelDeployment deployment = new AbstractKernelDeployment();
        deployment.setBeans(Arrays.asList(builder.getBeanMetaData()));
        Kernel kernel = this.bootstrap();
        KernelController controller = kernel.getController();
        AbstractKernelDeployer deployer = new AbstractKernelDeployer(kernel);
        deployer.deploy((KernelDeployment)deployment);
        Object o = controller.getInstalledContext((Object)"ReplaceBean").getTarget();
        BeanMetaDataBuilderTestCase.assertNotNull((Object)o);
        this.assertInstanceOf(o, SimpleBean.class);
        SimpleBean bean = (SimpleBean)o;
        Integer integer = bean.getAnInt();
        BeanMetaDataBuilderTestCase.assertEquals((Object)new Integer(5), (Object)integer);
        String string = bean.getAString();
        BeanMetaDataBuilderTestCase.assertEquals((String)"Two", (String)string);
        Object obj = bean.getAnObject();
        BeanMetaDataBuilderTestCase.assertEquals((Object)"Four", (Object)obj);
        Object[] arr = bean.getArray();
        BeanMetaDataBuilderTestCase.assertEquals((int)2, (int)arr.length);
        BeanMetaDataBuilderTestCase.assertEquals((Object)5, (Object)arr[0]);
        BeanMetaDataBuilderTestCase.assertEquals((Object)10, (Object)arr[1]);
        Map<?, ?> mp = bean.getMap();
        BeanMetaDataBuilderTestCase.assertEquals((int)2, (int)mp.size());
        BeanMetaDataBuilderTestCase.assertEquals((Object)"Uno", mp.get("One"));
        BeanMetaDataBuilderTestCase.assertEquals((Object)"Dos", mp.get("Two"));
    }
}

