/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.config.test;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractListMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.plugins.StringValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.test.kernel.config.support.CustomList;
import org.jboss.test.kernel.config.support.MyObject;
import org.jboss.test.kernel.config.support.SimpleBean;
import org.jboss.test.kernel.config.support.UnmodifiableGetterBean;
import org.jboss.test.kernel.config.test.AbstractKernelConfigTest;

public class ListTestCase
extends AbstractKernelConfigTest {
    MyObject object1 = new MyObject("object1");
    MyObject object2 = new MyObject("object2");
    String string1 = "string1";
    String string2 = "string2";

    public static Test suite() {
        return ListTestCase.suite(ListTestCase.class);
    }

    public ListTestCase(String name) {
        super(name);
    }

    public ListTestCase(String name, boolean xmltest) {
        super(name, xmltest);
    }

    public void testSimpleListFromObjects() throws Throwable {
        SimpleBean bean = this.simpleListFromObjects();
        ListTestCase.assertNotNull((Object)bean);
        List<?> result = bean.getList();
        ListTestCase.assertNotNull((String)"Should be a list", result);
        ArrayList<MyObject> expected = new ArrayList<MyObject>();
        expected.add(this.object1);
        expected.add(this.object2);
        expected.add(this.object2);
        expected.add(this.object1);
        ListTestCase.assertEquals(expected, result);
    }

    public SimpleBean simpleListFromObjects() throws Throwable {
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        AbstractValueMetaData vmd1 = new AbstractValueMetaData((Object)this.object1);
        AbstractValueMetaData vmd2 = new AbstractValueMetaData((Object)this.object2);
        AbstractValueMetaData vmd3 = new AbstractValueMetaData((Object)this.object1);
        AbstractListMetaData smd = new AbstractListMetaData();
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("list", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure((BeanMetaData)bmd);
    }

    public void testSimpleListFromStrings() throws Throwable {
        SimpleBean bean = this.simpleListFromStrings();
        ListTestCase.assertNotNull((Object)bean);
        List<?> result = bean.getList();
        ListTestCase.assertNotNull((String)"Should be a list", result);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(this.string1);
        expected.add(this.string2);
        expected.add(this.string2);
        expected.add(this.string1);
        ListTestCase.assertEquals(expected, result);
    }

    protected SimpleBean simpleListFromStrings() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        AbstractListMetaData smd = new AbstractListMetaData();
        smd.setElementType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("list", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }

    public void testCustomListExplicit() throws Throwable {
        SimpleBean bean = this.customListExplicit();
        ListTestCase.assertNotNull((Object)bean);
        List<?> result = bean.getList();
        ListTestCase.assertNotNull((String)"Should be a list", result);
        ListTestCase.assertTrue((String)("Not a CustomList: " + result.getClass()), (boolean)(result instanceof CustomList));
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(this.string1);
        expected.add(this.string2);
        expected.add(this.string2);
        expected.add(this.string1);
        ListTestCase.assertEquals(expected, result);
    }

    protected SimpleBean customListExplicit() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        AbstractListMetaData smd = new AbstractListMetaData();
        smd.setType(CustomList.class.getName());
        smd.setElementType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("list", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }

    public void testCustomListFromSignature() throws Throwable {
        SimpleBean bean = this.customListFromSignature();
        ListTestCase.assertNotNull((Object)bean);
        CustomList result = bean.getCustomList();
        ListTestCase.assertNotNull((String)"Should be a list", (Object)result);
        ListTestCase.assertTrue((String)("Not a CustomList: " + result.getClass()), (boolean)(result instanceof CustomList));
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(this.string1);
        expected.add(this.string2);
        expected.add(this.string2);
        expected.add(this.string1);
        ListTestCase.assertEquals(expected, (Object)result);
    }

    protected SimpleBean customListFromSignature() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        AbstractListMetaData smd = new AbstractListMetaData();
        smd.setElementType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("customList", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }

    public void testCustomListPreInstantiated() throws Throwable {
        SimpleBean bean = this.customListPreInstantiated();
        ListTestCase.assertNotNull((Object)bean);
        CustomList result = bean.getPreInstantiatedList();
        ListTestCase.assertNotNull((String)"Should be a list", (Object)result);
        ListTestCase.assertTrue((String)("Not a CustomList: " + result.getClass()), (boolean)(result instanceof CustomList));
        ListTestCase.assertTrue((String)"Not preinstantiated", (boolean)result.getPreInstantiated());
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(this.string1);
        expected.add(this.string2);
        expected.add(this.string2);
        expected.add(this.string1);
        ListTestCase.assertEquals(expected, (Object)result);
        List<?> setter = bean.setterList;
        ListTestCase.assertNotNull(setter);
        ListTestCase.assertFalse((String)"Empty setterList", (boolean)setter.isEmpty());
    }

    protected SimpleBean customListPreInstantiated() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelController controller = kernel.getController();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("test1", SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        AbstractListMetaData smd = new AbstractListMetaData();
        smd.setElementType("java.lang.String");
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd1 = new AbstractPropertyMetaData("preInstantiatedList", (ValueMetaData)smd);
        properties.add(pmd1);
        AbstractListMetaData lmd = new AbstractListMetaData();
        lmd.setElementType("java.lang.String");
        lmd.add((MetaDataVisitorNode)new StringValueMetaData("element"));
        AbstractPropertyMetaData pmd2 = new AbstractPropertyMetaData("setterList", (ValueMetaData)lmd);
        properties.add(pmd2);
        return (SimpleBean)this.instantiate(controller, (BeanMetaData)bmd);
    }

    public void testUnmodifiableListPreInstantiated() throws Throwable {
        UnmodifiableGetterBean bean = this.unmodifiableListPreInstantiated();
        ListTestCase.assertNotNull((Object)bean);
        List result = bean.getList();
        ListTestCase.assertNotNull((String)"Should be a list", (Object)result);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(this.string1);
        expected.add(this.string2);
        expected.add(this.string2);
        expected.add(this.string1);
        ListTestCase.assertEquals(expected, (Object)result);
    }

    protected UnmodifiableGetterBean unmodifiableListPreInstantiated() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelController controller = kernel.getController();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("test1", UnmodifiableGetterBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        AbstractListMetaData smd = new AbstractListMetaData();
        smd.setElementType("java.lang.String");
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd1 = new AbstractPropertyMetaData("list", (ValueMetaData)smd);
        pmd1.setPreInstantiate(false);
        properties.add(pmd1);
        return (UnmodifiableGetterBean)this.instantiate(controller, (BeanMetaData)bmd);
    }

    public void testListWithValueTypeOverride() throws Throwable {
        SimpleBean bean = this.listWithValueTypeOverride();
        ListTestCase.assertNotNull((Object)bean);
        List<?> result = bean.getList();
        ListTestCase.assertNotNull((String)"Should be a list", result);
        ListTestCase.assertTrue((String)("Not a CustomList: " + result.getClass()), (boolean)(result instanceof CustomList));
        ArrayList<Object> expected = new ArrayList<Object>();
        expected.add(this.string1);
        expected.add(this.string2);
        expected.add(this.string2);
        expected.add(this.string1);
        expected.add(new Integer(1));
        ListTestCase.assertEquals(expected, result);
    }

    protected SimpleBean listWithValueTypeOverride() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd4 = new StringValueMetaData("1");
        vmd4.setConfigurator(configurator);
        vmd4.setType("java.lang.Integer");
        AbstractListMetaData smd = new AbstractListMetaData();
        smd.setType(CustomList.class.getName());
        smd.setElementType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        smd.add((MetaDataVisitorNode)vmd4);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("list", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }

    public void testListNotAList() throws Throwable {
        try {
            this.listNotAList();
            ListTestCase.fail((String)"Expected a failure trying to set a list on a non list attribute");
        }
        catch (Exception expected) {
            this.checkListNotAListException(expected);
        }
    }

    protected void checkListNotAListException(Exception exception) {
        ListTestCase.checkThrowable(ClassCastException.class, (Throwable)exception);
    }

    protected SimpleBean listNotAList() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        AbstractListMetaData smd = new AbstractListMetaData();
        smd.setElementType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("AString", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }

    public void testListIsInterface() throws Throwable {
        try {
            this.listIsInterface();
            ListTestCase.fail((String)"Expected a failure trying to use an interface for the list type");
        }
        catch (Exception expected) {
            this.checkListIsInterfaceException(expected);
        }
    }

    protected void checkListIsInterfaceException(Exception exception) {
        ListTestCase.checkThrowable(IllegalArgumentException.class, (Throwable)exception);
    }

    protected SimpleBean listIsInterface() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        AbstractListMetaData smd = new AbstractListMetaData();
        smd.setType("java.util.List");
        smd.setElementType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("list", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }
}

