/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.controller.test;

import junit.framework.Test;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.test.kernel.controller.support.TestClassLoaderBean;
import org.jboss.test.kernel.controller.test.AbstractControllerTest;

public class ContextClassLoaderTestCase
extends AbstractControllerTest {
    ClassLoader cl = null;

    public static Test suite() {
        return ContextClassLoaderTestCase.suite(ContextClassLoaderTestCase.class);
    }

    public ContextClassLoaderTestCase(String name) throws Throwable {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws Exception {
        super.setUp();
        SecurityManager sm = ContextClassLoaderTestCase.suspendSecurity();
        try {
            this.cl = Thread.currentThread().getContextClassLoader();
        }
        finally {
            ContextClassLoaderTestCase.resumeSecurity((SecurityManager)sm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        SecurityManager sm = ContextClassLoaderTestCase.suspendSecurity();
        try {
            ContextClassLoaderTestCase.assertEquals((Object)this.cl, (Object)Thread.currentThread().getContextClassLoader());
        }
        finally {
            ContextClassLoaderTestCase.resumeSecurity((SecurityManager)sm);
            super.tearDown();
        }
    }

    public ClassLoader assertClassLoader() throws Exception {
        ClassLoader classLoader = (ClassLoader)this.getBean("ClassLoader");
        this.checkClassLoader(classLoader);
        return classLoader;
    }

    public ClassLoader assertClassLoader(ClassLoader cl) throws Exception {
        ClassLoader classLoader = (ClassLoader)this.getBean("ClassLoader");
        this.checkClassLoader(cl);
        return classLoader;
    }

    public void checkClassLoader(ClassLoader classLoader) throws Exception {
        ContextClassLoaderTestCase.assertEquals((Object)classLoader, (Object)TestClassLoaderBean.getAndResetClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFactory() throws Throwable {
        KernelDeployment deployment = this.deploy("ContextClassLoaderTestCase_Factory.xml");
        try {
            this.validate();
            this.assertClassLoader();
        }
        finally {
            this.undeploy(deployment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConstructor() throws Throwable {
        KernelDeployment deployment = this.deploy("ContextClassLoaderTestCase_Constructor.xml");
        try {
            this.validate();
            this.assertClassLoader();
        }
        finally {
            this.undeploy(deployment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConfigure() throws Throwable {
        KernelDeployment deployment = this.deploy("ContextClassLoaderTestCase_Configure.xml");
        ClassLoader cl = null;
        try {
            this.validate();
            cl = this.assertClassLoader();
        }
        finally {
            this.undeploy(deployment);
        }
        this.checkClassLoader(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreate() throws Throwable {
        KernelDeployment deployment = this.deploy("ContextClassLoaderTestCase_Create.xml");
        try {
            this.assertClassLoader();
        }
        finally {
            this.undeploy(deployment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStart() throws Throwable {
        KernelDeployment deployment = this.deploy("ContextClassLoaderTestCase_Create.xml");
        try {
            this.validate();
            this.assertClassLoader();
        }
        finally {
            this.undeploy(deployment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStop() throws Throwable {
        KernelDeployment deployment = this.deploy("ContextClassLoaderTestCase_Stop.xml");
        ClassLoader cl = null;
        try {
            cl = this.assertClassLoader(null);
        }
        finally {
            this.undeploy(deployment);
        }
        this.checkClassLoader(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDestroy() throws Throwable {
        KernelDeployment deployment = this.deploy("ContextClassLoaderTestCase_Destroy.xml");
        ClassLoader cl = null;
        try {
            this.validate();
            cl = this.assertClassLoader(null);
        }
        finally {
            this.undeploy(deployment);
        }
        this.checkClassLoader(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstall() throws Throwable {
        KernelDeployment deployment = this.deploy("ContextClassLoaderTestCase_Install.xml");
        try {
            this.validate();
            this.assertClassLoader();
        }
        finally {
            this.undeploy(deployment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUninstall() throws Throwable {
        KernelDeployment deployment = this.deploy("ContextClassLoaderTestCase_Uninstall.xml");
        ClassLoader cl = null;
        try {
            this.validate();
            cl = this.assertClassLoader(null);
        }
        finally {
            this.undeploy(deployment);
        }
        this.checkClassLoader(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIncallbackSingle() throws Throwable {
        KernelDeployment repository = this.deploy("ContextClassLoaderTestCase_InCallBackSingle.xml");
        KernelDeployment deployment = this.deploy("ContextClassLoaderTestCase_Callback.xml");
        try {
            this.validate();
            this.assertClassLoader();
        }
        finally {
            this.undeploy(deployment);
            this.undeploy(repository);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIncallbackCollection() throws Throwable {
        KernelDeployment repository = this.deploy("ContextClassLoaderTestCase_InCallBackCollection.xml");
        KernelDeployment deployment = this.deploy("ContextClassLoaderTestCase_Callback.xml");
        try {
            this.validate();
            this.assertClassLoader();
        }
        finally {
            this.undeploy(deployment);
            this.undeploy(repository);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUncallbackSingle() throws Throwable {
        KernelDeployment repository = this.deploy("ContextClassLoaderTestCase_UnCallBackSingle.xml");
        ClassLoader cl = null;
        try {
            KernelDeployment deployment = this.deploy("ContextClassLoaderTestCase_Callback.xml");
            try {
                this.validate();
                cl = this.assertClassLoader(null);
            }
            finally {
                this.undeploy(deployment);
            }
            this.checkClassLoader(cl);
        }
        finally {
            this.undeploy(repository);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUncallbackCollection() throws Throwable {
        KernelDeployment repository = this.deploy("ContextClassLoaderTestCase_UnCallBackCollection.xml");
        ClassLoader cl = null;
        try {
            KernelDeployment deployment = this.deploy("ContextClassLoaderTestCase_Callback.xml");
            try {
                this.validate();
                cl = this.assertClassLoader(null);
            }
            finally {
                this.undeploy(deployment);
            }
            this.checkClassLoader(cl);
        }
        finally {
            this.undeploy(repository);
        }
    }
}

