/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.dependency.test;

import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.plugins.factory.GenericBeanFactory;
import org.jboss.beans.metadata.plugins.factory.GenericBeanFactoryMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.dependency.support.SimpleBeanImpl;
import org.jboss.test.kernel.dependency.support.SimplerBean;
import org.jboss.test.kernel.dependency.test.OldAbstractKernelDependencyTest;

public class GenericBeanFactoryPropertyDependencyTestCase
extends OldAbstractKernelDependencyTest {
    public static Test suite() {
        return GenericBeanFactoryPropertyDependencyTestCase.suite(GenericBeanFactoryPropertyDependencyTestCase.class);
    }

    public GenericBeanFactoryPropertyDependencyTestCase(String name) throws Throwable {
        super(name);
    }

    public GenericBeanFactoryPropertyDependencyTestCase(String name, boolean xmltest) throws Throwable {
        super(name, xmltest);
    }

    public void testGenericBeanFactoryPropertyDependencyCorrectOrder() throws Throwable {
        this.propertyDependencyCorrectOrder();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        ControllerContext context2 = this.assertInstall(1, "Name2");
        SimplerBean bean1 = (SimplerBean)context1.getTarget();
        GenericBeanFactoryPropertyDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryPropertyDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        GenericBeanFactory factory = (GenericBeanFactory)context2.getTarget();
        SimplerBean bean2 = (SimplerBean)factory.createBean();
        GenericBeanFactoryPropertyDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryPropertyDependencyTestCase.assertEquals((String)"String1", (String)bean2.getString());
    }

    public void propertyDependencyCorrectOrder() throws Throwable {
        this.buildMetaData();
    }

    public void testGenericBeanFactoryPropertyDependencyWrongOrder() throws Throwable {
        this.propertyDependencyWrongOrder();
        ControllerContext context2 = this.assertInstall(1, "Name2", ControllerState.INSTANTIATED);
        ControllerContext context1 = this.assertInstall(0, "Name1");
        GenericBeanFactoryPropertyDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context2.getState());
        SimplerBean bean1 = (SimplerBean)context1.getTarget();
        GenericBeanFactoryPropertyDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryPropertyDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        GenericBeanFactory factory = (GenericBeanFactory)context2.getTarget();
        SimplerBean bean2 = (SimplerBean)factory.createBean();
        GenericBeanFactoryPropertyDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryPropertyDependencyTestCase.assertEquals((String)"String1", (String)bean2.getString());
    }

    public void propertyDependencyWrongOrder() throws Throwable {
        this.buildMetaData();
    }

    public void testGenericBeanFactoryPropertyDependencyReinstall() throws Throwable {
        this.propertyDependencyReinstall();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        ControllerContext context2 = this.assertInstall(1, "Name2");
        SimplerBean bean1 = (SimplerBean)context1.getTarget();
        GenericBeanFactoryPropertyDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryPropertyDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        GenericBeanFactory factory = (GenericBeanFactory)context2.getTarget();
        SimplerBean bean2 = (SimplerBean)factory.createBean();
        GenericBeanFactoryPropertyDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryPropertyDependencyTestCase.assertEquals((String)"String1", (String)bean2.getString());
        this.assertUninstall("Name1");
        GenericBeanFactoryPropertyDependencyTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context1.getState());
        GenericBeanFactoryPropertyDependencyTestCase.assertEquals((Object)ControllerState.INSTANTIATED, (Object)context2.getState());
        this.assertNotInstalled("Name2");
        context2 = this.assertContext("Name2", ControllerState.INSTANTIATED);
        context1 = this.assertInstall(0, "Name1");
        GenericBeanFactoryPropertyDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context2.getState());
        bean1 = (SimplerBean)context1.getTarget();
        GenericBeanFactoryPropertyDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryPropertyDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        factory = (GenericBeanFactory)context2.getTarget();
        bean2 = (SimplerBean)factory.createBean();
        GenericBeanFactoryPropertyDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryPropertyDependencyTestCase.assertEquals((String)"String1", (String)bean2.getString());
        this.assertUninstall("Name2");
        context1 = this.assertContext("Name1");
        bean1 = (SimplerBean)context1.getTarget();
        GenericBeanFactoryPropertyDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryPropertyDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        context2 = this.assertInstall(1, "Name2");
        bean1 = (SimplerBean)context1.getTarget();
        GenericBeanFactoryPropertyDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryPropertyDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        factory = (GenericBeanFactory)context2.getTarget();
        bean2 = (SimplerBean)factory.createBean();
        GenericBeanFactoryPropertyDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryPropertyDependencyTestCase.assertEquals((String)"String1", (String)bean2.getString());
    }

    public void propertyDependencyReinstall() throws Throwable {
        this.buildMetaData();
    }

    protected void buildMetaData() {
        AbstractBeanMetaData metaData1 = new AbstractBeanMetaData("Name1", SimpleBeanImpl.class.getName());
        metaData1.addProperty((PropertyMetaData)new AbstractPropertyMetaData("string", "String1"));
        GenericBeanFactoryMetaData metaData2 = this.createBeanFactory();
        metaData2.addBeanProperty((PropertyMetaData)new AbstractPropertyMetaData("string", (ValueMetaData)new AbstractDependencyValueMetaData((Object)"Name1", "string")));
        this.setBeanMetaDatas(new BeanMetaData[]{metaData1, metaData2});
    }

    protected GenericBeanFactoryMetaData createBeanFactory() {
        return new GenericBeanFactoryMetaData("Name2", SimpleBeanImpl.class.getName());
    }
}

