/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.util.HashSet;
import java.util.List;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.CallbackMetaData;
import org.jboss.dependency.spi.Cardinality;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.deployment.xml.support.Annotation1;
import org.jboss.test.kernel.deployment.xml.support.Annotation2;
import org.jboss.test.kernel.deployment.xml.support.Annotation3;
import org.jboss.test.kernel.deployment.xml.test.AbstractMCTest;

public class CallbackJaxbTestCase
extends AbstractMCTest {
    public CallbackJaxbTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return CallbackJaxbTestCase.suite(CallbackJaxbTestCase.class);
    }

    protected CallbackMetaData getInstallCallback() throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean();
        List callbacks = bean.getInstallCallbacks();
        CallbackJaxbTestCase.assertNotNull((Object)callbacks);
        CallbackJaxbTestCase.assertEquals((int)1, (int)callbacks.size());
        CallbackMetaData callback = (CallbackMetaData)callbacks.get(0);
        CallbackJaxbTestCase.assertNotNull((Object)callback);
        return callback;
    }

    protected CallbackMetaData getUninstallCallback() throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean();
        List callbacks = bean.getUninstallCallbacks();
        CallbackJaxbTestCase.assertNotNull((Object)callbacks);
        CallbackJaxbTestCase.assertEquals((int)1, (int)callbacks.size());
        CallbackMetaData callback = (CallbackMetaData)callbacks.get(0);
        CallbackJaxbTestCase.assertNotNull((Object)callback);
        return callback;
    }

    public void testCallbackInstallWithProperty() throws Exception {
        CallbackMetaData install = this.getInstallCallback();
        CallbackJaxbTestCase.assertEquals((String)"someProperty", (String)install.getProperty());
        CallbackJaxbTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        CallbackJaxbTestCase.assertNull((Object)install.getAnnotations());
        CallbackJaxbTestCase.assertNull((Object)install.getParameters());
    }

    public void testCallbackInstallWithMethod() throws Exception {
        CallbackMetaData install = this.getInstallCallback();
        CallbackJaxbTestCase.assertNull((Object)install.getProperty());
        CallbackJaxbTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        CallbackJaxbTestCase.assertEquals((String)"someMethod", (String)install.getMethodName());
        CallbackJaxbTestCase.assertNull((Object)install.getAnnotations());
        CallbackJaxbTestCase.assertNull((Object)install.getParameters());
    }

    public void testCallbackInstallWithState() throws Exception {
        CallbackMetaData install = this.getInstallCallback();
        CallbackJaxbTestCase.assertNull((Object)install.getProperty());
        CallbackJaxbTestCase.assertEquals((Object)ControllerState.CONFIGURED, (Object)install.getDependentState());
        CallbackJaxbTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        CallbackJaxbTestCase.assertNull((Object)install.getAnnotations());
        CallbackJaxbTestCase.assertNull((Object)install.getParameters());
    }

    public void testCallbackInstallWithAnnotation() throws Exception {
        CallbackMetaData install = this.getInstallCallback();
        CallbackJaxbTestCase.assertNull((Object)install.getProperty());
        CallbackJaxbTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        CallbackJaxbTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        HashSet<String> expected = new HashSet<String>();
        expected.add(Annotation1.class.getName());
        this.assertAnnotations(expected, install.getAnnotations());
        CallbackJaxbTestCase.assertNull((Object)install.getParameters());
    }

    public void testCallbackInstallWithAnnotations() throws Exception {
        CallbackMetaData install = this.getInstallCallback();
        CallbackJaxbTestCase.assertNull((Object)install.getProperty());
        CallbackJaxbTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        CallbackJaxbTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        HashSet<String> expected = new HashSet<String>();
        expected.add(Annotation1.class.getName());
        expected.add(Annotation2.class.getName());
        expected.add(Annotation3.class.getName());
        this.assertAnnotations(expected, install.getAnnotations());
        CallbackJaxbTestCase.assertNull((Object)install.getParameters());
    }

    public void testCallbackInstallWithSignature() throws Exception {
        CallbackMetaData install = this.getInstallCallback();
        CallbackJaxbTestCase.assertNull((Object)install.getProperty());
        CallbackJaxbTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        CallbackJaxbTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        CallbackJaxbTestCase.assertNull((Object)install.getAnnotations());
        CallbackJaxbTestCase.assertNotNull((Object)install.getSignature());
        CallbackJaxbTestCase.assertEquals((String)"someSignature", (String)install.getSignature());
    }

    public void testCallbackInstallWithCardinality() throws Exception {
        CallbackMetaData install = this.getInstallCallback();
        CallbackJaxbTestCase.assertNull((Object)install.getProperty());
        CallbackJaxbTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        CallbackJaxbTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        CallbackJaxbTestCase.assertNull((Object)install.getAnnotations());
        CallbackJaxbTestCase.assertNotNull((Object)install.getCardinality());
        CallbackJaxbTestCase.assertEquals((Object)install.getCardinality(), (Object)Cardinality.ONE_TO_MANY);
    }

    public void testCallbackUninstallWithProperty() throws Exception {
        CallbackMetaData install = this.getUninstallCallback();
        CallbackJaxbTestCase.assertEquals((String)"someProperty", (String)install.getProperty());
        CallbackJaxbTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        CallbackJaxbTestCase.assertNull((Object)install.getAnnotations());
        CallbackJaxbTestCase.assertNull((Object)install.getParameters());
    }

    public void testCallbackUninstallWithMethod() throws Exception {
        CallbackMetaData install = this.getUninstallCallback();
        CallbackJaxbTestCase.assertNull((Object)install.getProperty());
        CallbackJaxbTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        CallbackJaxbTestCase.assertEquals((String)"someMethod", (String)install.getMethodName());
        CallbackJaxbTestCase.assertNull((Object)install.getAnnotations());
        CallbackJaxbTestCase.assertNull((Object)install.getParameters());
    }

    public void testCallbackUninstallWithState() throws Exception {
        CallbackMetaData install = this.getUninstallCallback();
        CallbackJaxbTestCase.assertNull((Object)install.getProperty());
        CallbackJaxbTestCase.assertEquals((Object)ControllerState.CONFIGURED, (Object)install.getDependentState());
        CallbackJaxbTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        CallbackJaxbTestCase.assertNull((Object)install.getAnnotations());
        CallbackJaxbTestCase.assertNull((Object)install.getParameters());
    }

    public void testCallbackUninstallWithAnnotation() throws Exception {
        CallbackMetaData install = this.getUninstallCallback();
        CallbackJaxbTestCase.assertNull((Object)install.getProperty());
        CallbackJaxbTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        CallbackJaxbTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        HashSet<String> expected = new HashSet<String>();
        expected.add(Annotation1.class.getName());
        this.assertAnnotations(expected, install.getAnnotations());
        CallbackJaxbTestCase.assertNull((Object)install.getParameters());
    }

    public void testCallbackUninstallWithAnnotations() throws Exception {
        CallbackMetaData install = this.getUninstallCallback();
        CallbackJaxbTestCase.assertNull((Object)install.getProperty());
        CallbackJaxbTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        CallbackJaxbTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        HashSet<String> expected = new HashSet<String>();
        expected.add(Annotation1.class.getName());
        expected.add(Annotation2.class.getName());
        expected.add(Annotation3.class.getName());
        this.assertAnnotations(expected, install.getAnnotations());
        CallbackJaxbTestCase.assertNull((Object)install.getParameters());
    }

    public void testCallbackUninstallWithSignature() throws Exception {
        CallbackMetaData install = this.getUninstallCallback();
        CallbackJaxbTestCase.assertNull((Object)install.getProperty());
        CallbackJaxbTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        CallbackJaxbTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        CallbackJaxbTestCase.assertNull((Object)install.getAnnotations());
        CallbackJaxbTestCase.assertNotNull((Object)install.getSignature());
        CallbackJaxbTestCase.assertEquals((String)"someSignature", (String)install.getSignature());
    }

    public void testCallbackUninstallWithCardinality() throws Exception {
        CallbackMetaData install = this.getUninstallCallback();
        CallbackJaxbTestCase.assertNull((Object)install.getProperty());
        CallbackJaxbTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        CallbackJaxbTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        CallbackJaxbTestCase.assertNull((Object)install.getAnnotations());
        CallbackJaxbTestCase.assertNotNull((Object)install.getCardinality());
        CallbackJaxbTestCase.assertEquals((Object)install.getCardinality(), (Object)Cardinality.fromString((String)"2..10"));
    }
}

