/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.util.HashSet;
import java.util.List;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.CallbackMetaData;
import org.jboss.dependency.spi.Cardinality;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.deployment.xml.test.AbstractXMLTest;

public class CallbackTestCase
extends AbstractXMLTest {
    public CallbackTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return CallbackTestCase.suite(CallbackTestCase.class);
    }

    protected CallbackMetaData getInstallCallback(String name) throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean(name);
        List callbacks = bean.getInstallCallbacks();
        CallbackTestCase.assertNotNull((Object)callbacks);
        CallbackTestCase.assertEquals((int)1, (int)callbacks.size());
        CallbackMetaData callback = (CallbackMetaData)callbacks.get(0);
        CallbackTestCase.assertNotNull((Object)callback);
        return callback;
    }

    protected CallbackMetaData getUninstallCallback(String name) throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean(name);
        List callbacks = bean.getUninstallCallbacks();
        CallbackTestCase.assertNotNull((Object)callbacks);
        CallbackTestCase.assertEquals((int)1, (int)callbacks.size());
        CallbackMetaData callback = (CallbackMetaData)callbacks.get(0);
        CallbackTestCase.assertNotNull((Object)callback);
        return callback;
    }

    public void testInstallWithProperty() throws Exception {
        CallbackMetaData install = this.getInstallCallback("CallbackInstallWithProperty.xml");
        CallbackTestCase.assertEquals((String)"someProperty", (String)install.getProperty());
        CallbackTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        CallbackTestCase.assertNull((Object)install.getAnnotations());
        CallbackTestCase.assertNull((Object)install.getParameters());
    }

    public void testInstallWithMethod() throws Exception {
        CallbackMetaData install = this.getInstallCallback("CallbackInstallWithMethod.xml");
        CallbackTestCase.assertNull((Object)install.getProperty());
        CallbackTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        CallbackTestCase.assertEquals((String)"someMethod", (String)install.getMethodName());
        CallbackTestCase.assertNull((Object)install.getAnnotations());
        CallbackTestCase.assertNull((Object)install.getParameters());
    }

    public void testInstallWithState() throws Exception {
        CallbackMetaData install = this.getInstallCallback("CallbackInstallWithState.xml");
        CallbackTestCase.assertNull((Object)install.getProperty());
        CallbackTestCase.assertEquals((Object)ControllerState.CONFIGURED, (Object)install.getDependentState());
        CallbackTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        CallbackTestCase.assertNull((Object)install.getAnnotations());
        CallbackTestCase.assertNull((Object)install.getParameters());
    }

    public void testInstallWithAnnotation() throws Exception {
        CallbackMetaData install = this.getInstallCallback("CallbackInstallWithAnnotation.xml");
        CallbackTestCase.assertNull((Object)install.getProperty());
        CallbackTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        CallbackTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        HashSet<String> expected = new HashSet<String>();
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation1");
        this.assertAnnotations(expected, install.getAnnotations());
        CallbackTestCase.assertNull((Object)install.getParameters());
    }

    public void testInstallWithAnnotations() throws Exception {
        CallbackMetaData install = this.getInstallCallback("CallbackInstallWithAnnotations.xml");
        CallbackTestCase.assertNull((Object)install.getProperty());
        CallbackTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        CallbackTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        HashSet<String> expected = new HashSet<String>();
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation1");
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation2");
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation3");
        this.assertAnnotations(expected, install.getAnnotations());
        CallbackTestCase.assertNull((Object)install.getParameters());
    }

    public void testInstallWithSignature() throws Exception {
        CallbackMetaData install = this.getInstallCallback("CallbackInstallWithSignature.xml");
        CallbackTestCase.assertNull((Object)install.getProperty());
        CallbackTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        CallbackTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        CallbackTestCase.assertNull((Object)install.getAnnotations());
        CallbackTestCase.assertNotNull((Object)install.getSignature());
        CallbackTestCase.assertEquals((String)"someSignature", (String)install.getSignature());
    }

    public void testInstallWithCardinality() throws Exception {
        CallbackMetaData install = this.getInstallCallback("CallbackInstallWithCardinality.xml");
        CallbackTestCase.assertNull((Object)install.getProperty());
        CallbackTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        CallbackTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        CallbackTestCase.assertNull((Object)install.getAnnotations());
        CallbackTestCase.assertNotNull((Object)install.getCardinality());
        CallbackTestCase.assertEquals((Object)install.getCardinality(), (Object)Cardinality.ONE_TO_MANY);
    }

    public void testUninstallWithProperty() throws Exception {
        CallbackMetaData install = this.getUninstallCallback("CallbackUninstallWithProperty.xml");
        CallbackTestCase.assertEquals((String)"someProperty", (String)install.getProperty());
        CallbackTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        CallbackTestCase.assertNull((Object)install.getAnnotations());
        CallbackTestCase.assertNull((Object)install.getParameters());
    }

    public void testUninstallWithMethod() throws Exception {
        CallbackMetaData install = this.getUninstallCallback("CallbackUninstallWithMethod.xml");
        CallbackTestCase.assertNull((Object)install.getProperty());
        CallbackTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        CallbackTestCase.assertEquals((String)"someMethod", (String)install.getMethodName());
        CallbackTestCase.assertNull((Object)install.getAnnotations());
        CallbackTestCase.assertNull((Object)install.getParameters());
    }

    public void testUninstallWithState() throws Exception {
        CallbackMetaData install = this.getUninstallCallback("CallbackUninstallWithState.xml");
        CallbackTestCase.assertNull((Object)install.getProperty());
        CallbackTestCase.assertEquals((Object)ControllerState.CONFIGURED, (Object)install.getDependentState());
        CallbackTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        CallbackTestCase.assertNull((Object)install.getAnnotations());
        CallbackTestCase.assertNull((Object)install.getParameters());
    }

    public void testUninstallWithAnnotation() throws Exception {
        CallbackMetaData install = this.getUninstallCallback("CallbackUninstallWithAnnotation.xml");
        CallbackTestCase.assertNull((Object)install.getProperty());
        CallbackTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        CallbackTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        HashSet<String> expected = new HashSet<String>();
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation1");
        this.assertAnnotations(expected, install.getAnnotations());
        CallbackTestCase.assertNull((Object)install.getParameters());
    }

    public void testUninstallWithAnnotations() throws Exception {
        CallbackMetaData install = this.getUninstallCallback("CallbackUninstallWithAnnotations.xml");
        CallbackTestCase.assertNull((Object)install.getProperty());
        CallbackTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        CallbackTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        HashSet<String> expected = new HashSet<String>();
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation1");
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation2");
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation3");
        this.assertAnnotations(expected, install.getAnnotations());
        CallbackTestCase.assertNull((Object)install.getParameters());
    }

    public void testUninstallWithSignature() throws Exception {
        CallbackMetaData install = this.getUninstallCallback("CallbackUninstallWithSignature.xml");
        CallbackTestCase.assertNull((Object)install.getProperty());
        CallbackTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        CallbackTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        CallbackTestCase.assertNull((Object)install.getAnnotations());
        CallbackTestCase.assertNotNull((Object)install.getSignature());
        CallbackTestCase.assertEquals((String)"someSignature", (String)install.getSignature());
    }

    public void testUninstallWithCardinality() throws Exception {
        CallbackMetaData install = this.getUninstallCallback("CallbackUninstallWithCardinality.xml");
        CallbackTestCase.assertNull((Object)install.getProperty());
        CallbackTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        CallbackTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        CallbackTestCase.assertNull((Object)install.getAnnotations());
        CallbackTestCase.assertNotNull((Object)install.getCardinality());
        CallbackTestCase.assertEquals((Object)install.getCardinality(), (Object)Cardinality.fromString((String)"2..10"));
    }
}

