/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.util.Set;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractCollectionMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.test.kernel.deployment.xml.test.AbstractXMLTest;

public class CollectionTestCase
extends AbstractXMLTest {
    protected AbstractCollectionMetaData getCollection(String name) throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean(name);
        Set properties = bean.getProperties();
        CollectionTestCase.assertNotNull((Object)properties);
        CollectionTestCase.assertEquals((int)1, (int)properties.size());
        PropertyMetaData property = (PropertyMetaData)properties.iterator().next();
        CollectionTestCase.assertNotNull((Object)property);
        ValueMetaData value = property.getValue();
        CollectionTestCase.assertNotNull((Object)property);
        CollectionTestCase.assertTrue((boolean)(value instanceof AbstractCollectionMetaData));
        return (AbstractCollectionMetaData)value;
    }

    public void testCollection() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection("Collection.xml");
        CollectionTestCase.assertNull((Object)collection.getType());
        CollectionTestCase.assertNull((Object)collection.getElementType());
    }

    public void testCollectionWithClass() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection("CollectionWithClass.xml");
        CollectionTestCase.assertEquals((String)"CollectionClass", (String)collection.getType());
        CollectionTestCase.assertNull((Object)collection.getElementType());
    }

    public void testCollectionWithElementClass() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection("CollectionWithElementClass.xml");
        CollectionTestCase.assertNull((Object)collection.getType());
        CollectionTestCase.assertEquals((String)"ElementClass", (String)collection.getElementType());
    }

    public void testCollectionWithValue() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection("CollectionWithValue.xml");
        CollectionTestCase.assertNull((Object)collection.getType());
        CollectionTestCase.assertNull((Object)collection.getElementType());
        this.assertValue("Value", this.getValue(collection));
    }

    public void testCollectionWithInjection() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection("CollectionWithInjection.xml");
        CollectionTestCase.assertNull((Object)collection.getType());
        CollectionTestCase.assertNull((Object)collection.getElementType());
        this.assertInjection(this.getValue(collection));
    }

    public void testCollectionWithCollection() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection("CollectionWithCollection.xml");
        CollectionTestCase.assertNull((Object)collection.getType());
        CollectionTestCase.assertNull((Object)collection.getElementType());
        this.assertCollection(this.getValue(collection));
    }

    public void testCollectionWithList() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection("CollectionWithList.xml");
        CollectionTestCase.assertNull((Object)collection.getType());
        CollectionTestCase.assertNull((Object)collection.getElementType());
        this.assertList(this.getValue(collection));
    }

    public void testCollectionWithSet() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection("CollectionWithSet.xml");
        CollectionTestCase.assertNull((Object)collection.getType());
        CollectionTestCase.assertNull((Object)collection.getElementType());
        this.assertSet(this.getValue(collection));
    }

    public void testCollectionWithArray() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection("CollectionWithArray.xml");
        CollectionTestCase.assertNull((Object)collection.getType());
        CollectionTestCase.assertNull((Object)collection.getElementType());
        this.assertArray(this.getValue(collection));
    }

    public void testCollectionWithMap() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection("CollectionWithMap.xml");
        CollectionTestCase.assertNull((Object)collection.getType());
        CollectionTestCase.assertNull((Object)collection.getElementType());
        this.assertMap(this.getValue(collection));
    }

    public void testCollectionWithNull() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection("CollectionWithNull.xml");
        CollectionTestCase.assertNull((Object)collection.getType());
        CollectionTestCase.assertNull((Object)collection.getElementType());
        this.assertNullValue(this.getValue(collection));
    }

    public void testCollectionWithThis() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection("CollectionWithThis.xml");
        CollectionTestCase.assertNull((Object)collection.getType());
        CollectionTestCase.assertNull((Object)collection.getElementType());
        this.assertThis(this.getValue(collection));
    }

    public void testCollectionWithWildcard() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection("CollectionWithWildcard.xml");
        CollectionTestCase.assertNull((Object)collection.getType());
        CollectionTestCase.assertNull((Object)collection.getElementType());
        this.assertWildcard(this.getValue(collection));
    }

    public void testCollectionWithBean() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection("CollectionWithBean.xml");
        CollectionTestCase.assertNull((Object)collection.getType());
        CollectionTestCase.assertNull((Object)collection.getElementType());
        this.assertBean(this.getValue(collection));
    }

    protected ValueMetaData getValue(AbstractCollectionMetaData collection) {
        CollectionTestCase.assertEquals((int)1, (int)collection.size());
        return (ValueMetaData)collection.iterator().next();
    }

    public static Test suite() {
        return CollectionTestCase.suite(CollectionTestCase.class);
    }

    public CollectionTestCase(String name) {
        super(name);
    }
}

