/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.util.ArrayList;
import java.util.HashSet;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.test.kernel.deployment.xml.test.AbstractXMLTest;

public class ConstructorTestCase
extends AbstractXMLTest {
    protected ConstructorMetaData getConstructor(String name) throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean(name);
        ConstructorMetaData constructor = bean.getConstructor();
        ConstructorTestCase.assertNotNull((Object)constructor);
        return constructor;
    }

    public void testConstructor() throws Exception {
        ConstructorMetaData constructor = this.getConstructor("Constructor.xml");
        ConstructorTestCase.assertNull((Object)constructor.getFactoryClass());
        ConstructorTestCase.assertNull((Object)constructor.getFactoryMethod());
        ConstructorTestCase.assertNull((Object)constructor.getAnnotations());
        ConstructorTestCase.assertNull((Object)constructor.getFactory());
        ConstructorTestCase.assertNull((Object)constructor.getParameters());
        ConstructorTestCase.assertNull((Object)constructor.getValue());
    }

    public void testConstructorWithBean() throws Exception {
        ConstructorMetaData constructor = this.getConstructor("ConstructorWithBean.xml");
        ConstructorTestCase.assertNull((Object)constructor.getFactoryClass());
        ConstructorTestCase.assertNull((Object)constructor.getFactoryMethod());
        ConstructorTestCase.assertNull((Object)constructor.getAnnotations());
        ConstructorTestCase.assertNull((Object)constructor.getFactory());
        ConstructorTestCase.assertNull((Object)constructor.getParameters());
        this.assertBean(constructor.getValue());
    }

    public void testConstructorWithLazy() throws Exception {
        ConstructorMetaData constructor = this.getConstructor("ConstructorWithLazy.xml");
        ConstructorTestCase.assertNull((Object)constructor.getFactoryClass());
        ConstructorTestCase.assertNull((Object)constructor.getFactoryMethod());
        ConstructorTestCase.assertNull((Object)constructor.getAnnotations());
        ConstructorTestCase.assertNull((Object)constructor.getFactory());
        ConstructorTestCase.assertNull((Object)constructor.getParameters());
        this.assertLazy(constructor.getValue());
    }

    public void testConstructorWithFactoryClass() throws Exception {
        ConstructorMetaData constructor = this.getConstructor("ConstructorWithFactoryClass.xml");
        ConstructorTestCase.assertEquals((String)"FactoryClass", (String)constructor.getFactoryClass());
        ConstructorTestCase.assertEquals((String)"Dummy", (String)constructor.getFactoryMethod());
        ConstructorTestCase.assertNull((Object)constructor.getAnnotations());
        ConstructorTestCase.assertNull((Object)constructor.getFactory());
        ConstructorTestCase.assertNull((Object)constructor.getParameters());
        ConstructorTestCase.assertNull((Object)constructor.getValue());
    }

    public void testConstructorWithFactoryMethod() throws Exception {
        ConstructorMetaData constructor = this.getConstructor("ConstructorWithFactoryMethod.xml");
        ConstructorTestCase.assertEquals((String)"Dummy", (String)constructor.getFactoryClass());
        ConstructorTestCase.assertEquals((String)"FactoryMethod", (String)constructor.getFactoryMethod());
        ConstructorTestCase.assertNull((Object)constructor.getAnnotations());
        ConstructorTestCase.assertNull((Object)constructor.getFactory());
        ConstructorTestCase.assertNull((Object)constructor.getParameters());
        ConstructorTestCase.assertNull((Object)constructor.getValue());
    }

    public void testConstructorWithAnnotation() throws Exception {
        ConstructorMetaData constructor = this.getConstructor("ConstructorWithAnnotation.xml");
        ConstructorTestCase.assertNull((Object)constructor.getFactoryClass());
        ConstructorTestCase.assertNull((Object)constructor.getFactoryMethod());
        HashSet<String> expected = new HashSet<String>();
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation1");
        this.assertAnnotations(expected, constructor.getAnnotations());
        ConstructorTestCase.assertNull((Object)constructor.getFactory());
        ConstructorTestCase.assertNull((Object)constructor.getParameters());
        ConstructorTestCase.assertNull((Object)constructor.getValue());
    }

    public void testConstructorWithAnnotations() throws Exception {
        ConstructorMetaData constructor = this.getConstructor("ConstructorWithAnnotations.xml");
        ConstructorTestCase.assertNull((Object)constructor.getFactoryClass());
        ConstructorTestCase.assertNull((Object)constructor.getFactoryMethod());
        HashSet<String> expected = new HashSet<String>();
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation1");
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation2");
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation3");
        this.assertAnnotations(expected, constructor.getAnnotations());
        ConstructorTestCase.assertNull((Object)constructor.getFactory());
        ConstructorTestCase.assertNull((Object)constructor.getParameters());
        ConstructorTestCase.assertNull((Object)constructor.getValue());
    }

    public void testConstructorWithFactory() throws Exception {
        ConstructorMetaData constructor = this.getConstructor("ConstructorWithFactory.xml");
        ConstructorTestCase.assertNull((Object)constructor.getFactoryClass());
        ConstructorTestCase.assertEquals((String)"Dummy", (String)constructor.getFactoryMethod());
        ConstructorTestCase.assertNull((Object)constructor.getAnnotations());
        ConstructorTestCase.assertNotNull((Object)constructor.getFactory());
        ConstructorTestCase.assertNull((Object)constructor.getParameters());
        ConstructorTestCase.assertNull((Object)constructor.getValue());
    }

    public void testConstructorWithParameter() throws Exception {
        ConstructorMetaData constructor = this.getConstructor("ConstructorWithParameter.xml");
        ConstructorTestCase.assertNull((Object)constructor.getFactoryClass());
        ConstructorTestCase.assertNull((Object)constructor.getFactoryMethod());
        ConstructorTestCase.assertNull((Object)constructor.getAnnotations());
        ConstructorTestCase.assertNull((Object)constructor.getFactory());
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("Parameter1");
        this.assertParameters(expected, constructor.getParameters());
        ConstructorTestCase.assertNull((Object)constructor.getValue());
    }

    public void testConstructorWithParameters() throws Exception {
        ConstructorMetaData constructor = this.getConstructor("ConstructorWithParameters.xml");
        ConstructorTestCase.assertNull((Object)constructor.getFactoryClass());
        ConstructorTestCase.assertNull((Object)constructor.getFactoryMethod());
        ConstructorTestCase.assertNull((Object)constructor.getAnnotations());
        ConstructorTestCase.assertNull((Object)constructor.getFactory());
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("Parameter1");
        expected.add("Parameter2");
        expected.add("Parameter3");
        this.assertParameters(expected, constructor.getParameters());
        ConstructorTestCase.assertNull((Object)constructor.getValue());
    }

    public void testConstructorWithValue() throws Exception {
        ConstructorMetaData constructor = this.getConstructor("ConstructorWithValue.xml");
        ConstructorTestCase.assertNull((Object)constructor.getFactoryClass());
        ConstructorTestCase.assertNull((Object)constructor.getFactoryMethod());
        ConstructorTestCase.assertNull((Object)constructor.getAnnotations());
        ConstructorTestCase.assertNull((Object)constructor.getFactory());
        ConstructorTestCase.assertNull((Object)constructor.getParameters());
        this.assertValue("Value", constructor.getValue());
    }

    public void testConstructorWithInject() throws Exception {
        ConstructorMetaData constructor = this.getConstructor("ConstructorWithInject.xml");
        ConstructorTestCase.assertNull((Object)constructor.getFactoryClass());
        ConstructorTestCase.assertNull((Object)constructor.getFactoryMethod());
        ConstructorTestCase.assertNull((Object)constructor.getAnnotations());
        ConstructorTestCase.assertNull((Object)constructor.getFactory());
        ConstructorTestCase.assertNull((Object)constructor.getParameters());
        this.assertInjection(constructor.getValue());
    }

    public void testConstructorWithCollection() throws Exception {
        ConstructorMetaData constructor = this.getConstructor("ConstructorWithCollection.xml");
        ConstructorTestCase.assertNull((Object)constructor.getFactoryClass());
        ConstructorTestCase.assertNull((Object)constructor.getFactoryMethod());
        ConstructorTestCase.assertNull((Object)constructor.getAnnotations());
        ConstructorTestCase.assertNull((Object)constructor.getFactory());
        ConstructorTestCase.assertNull((Object)constructor.getParameters());
        this.assertCollection(constructor.getValue());
    }

    public void testConstructorWithList() throws Exception {
        ConstructorMetaData constructor = this.getConstructor("ConstructorWithList.xml");
        ConstructorTestCase.assertNull((Object)constructor.getFactoryClass());
        ConstructorTestCase.assertNull((Object)constructor.getFactoryMethod());
        ConstructorTestCase.assertNull((Object)constructor.getAnnotations());
        ConstructorTestCase.assertNull((Object)constructor.getFactory());
        ConstructorTestCase.assertNull((Object)constructor.getParameters());
        this.assertList(constructor.getValue());
    }

    public void testConstructorWithSet() throws Exception {
        ConstructorMetaData constructor = this.getConstructor("ConstructorWithSet.xml");
        ConstructorTestCase.assertNull((Object)constructor.getFactoryClass());
        ConstructorTestCase.assertNull((Object)constructor.getFactoryMethod());
        ConstructorTestCase.assertNull((Object)constructor.getAnnotations());
        ConstructorTestCase.assertNull((Object)constructor.getFactory());
        ConstructorTestCase.assertNull((Object)constructor.getParameters());
        this.assertSet(constructor.getValue());
    }

    public void testConstructorWithArray() throws Exception {
        ConstructorMetaData constructor = this.getConstructor("ConstructorWithArray.xml");
        ConstructorTestCase.assertNull((Object)constructor.getFactoryClass());
        ConstructorTestCase.assertNull((Object)constructor.getFactoryMethod());
        ConstructorTestCase.assertNull((Object)constructor.getAnnotations());
        ConstructorTestCase.assertNull((Object)constructor.getFactory());
        ConstructorTestCase.assertNull((Object)constructor.getParameters());
        this.assertArray(constructor.getValue());
    }

    public void testConstructorWithMap() throws Exception {
        ConstructorMetaData constructor = this.getConstructor("ConstructorWithMap.xml");
        ConstructorTestCase.assertNull((Object)constructor.getFactoryClass());
        ConstructorTestCase.assertNull((Object)constructor.getFactoryMethod());
        ConstructorTestCase.assertNull((Object)constructor.getAnnotations());
        ConstructorTestCase.assertNull((Object)constructor.getFactory());
        ConstructorTestCase.assertNull((Object)constructor.getParameters());
        this.assertMap(constructor.getValue());
    }

    public void testConstructorWithWildcard() throws Exception {
        ConstructorMetaData constructor = this.getConstructor("ConstructorWithWildcard.xml");
        ConstructorTestCase.assertNull((Object)constructor.getFactoryClass());
        ConstructorTestCase.assertNull((Object)constructor.getFactoryMethod());
        ConstructorTestCase.assertNull((Object)constructor.getAnnotations());
        ConstructorTestCase.assertNull((Object)constructor.getFactory());
        ConstructorTestCase.assertNull((Object)constructor.getParameters());
        this.assertWildcard(constructor.getValue());
    }

    public static Test suite() {
        return ConstructorTestCase.suite(ConstructorTestCase.class);
    }

    public ConstructorTestCase(String name) {
        super(name);
    }
}

