/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.util.Set;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractListMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.test.kernel.deployment.xml.test.AbstractXMLTest;

public class ListTestCase
extends AbstractXMLTest {
    protected AbstractListMetaData getCollection(String name) throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean(name);
        Set properties = bean.getProperties();
        ListTestCase.assertNotNull((Object)properties);
        ListTestCase.assertEquals((int)1, (int)properties.size());
        PropertyMetaData property = (PropertyMetaData)properties.iterator().next();
        ListTestCase.assertNotNull((Object)property);
        ValueMetaData value = property.getValue();
        ListTestCase.assertNotNull((Object)property);
        ListTestCase.assertTrue((boolean)(value instanceof AbstractListMetaData));
        return (AbstractListMetaData)value;
    }

    public void testList() throws Exception {
        AbstractListMetaData collection = this.getCollection("List.xml");
        ListTestCase.assertNull((Object)collection.getType());
        ListTestCase.assertNull((Object)collection.getElementType());
    }

    public void testListWithClass() throws Exception {
        AbstractListMetaData collection = this.getCollection("ListWithClass.xml");
        ListTestCase.assertEquals((String)"CollectionClass", (String)collection.getType());
        ListTestCase.assertNull((Object)collection.getElementType());
    }

    public void testListWithElementClass() throws Exception {
        AbstractListMetaData collection = this.getCollection("ListWithElementClass.xml");
        ListTestCase.assertNull((Object)collection.getType());
        ListTestCase.assertEquals((String)"ElementClass", (String)collection.getElementType());
    }

    public void testListWithValue() throws Exception {
        AbstractListMetaData collection = this.getCollection("ListWithValue.xml");
        ListTestCase.assertNull((Object)collection.getType());
        ListTestCase.assertNull((Object)collection.getElementType());
        this.assertValue("Value", this.getValue(collection));
    }

    public void testListWithInjection() throws Exception {
        AbstractListMetaData collection = this.getCollection("ListWithInjection.xml");
        ListTestCase.assertNull((Object)collection.getType());
        ListTestCase.assertNull((Object)collection.getElementType());
        this.assertInjection(this.getValue(collection));
    }

    public void testListWithCollection() throws Exception {
        AbstractListMetaData collection = this.getCollection("ListWithCollection.xml");
        ListTestCase.assertNull((Object)collection.getType());
        ListTestCase.assertNull((Object)collection.getElementType());
        this.assertCollection(this.getValue(collection));
    }

    public void testListWithList() throws Exception {
        AbstractListMetaData collection = this.getCollection("ListWithList.xml");
        ListTestCase.assertNull((Object)collection.getType());
        ListTestCase.assertNull((Object)collection.getElementType());
        this.assertList(this.getValue(collection));
    }

    public void testListWithSet() throws Exception {
        AbstractListMetaData collection = this.getCollection("ListWithSet.xml");
        ListTestCase.assertNull((Object)collection.getType());
        ListTestCase.assertNull((Object)collection.getElementType());
        this.assertSet(this.getValue(collection));
    }

    public void testListWithArray() throws Exception {
        AbstractListMetaData collection = this.getCollection("ListWithArray.xml");
        ListTestCase.assertNull((Object)collection.getType());
        ListTestCase.assertNull((Object)collection.getElementType());
        this.assertArray(this.getValue(collection));
    }

    public void testListWithMap() throws Exception {
        AbstractListMetaData collection = this.getCollection("ListWithMap.xml");
        ListTestCase.assertNull((Object)collection.getType());
        ListTestCase.assertNull((Object)collection.getElementType());
        this.assertMap(this.getValue(collection));
    }

    public void testListWithNull() throws Exception {
        AbstractListMetaData collection = this.getCollection("ListWithNull.xml");
        ListTestCase.assertNull((Object)collection.getType());
        ListTestCase.assertNull((Object)collection.getElementType());
        this.assertNullValue(this.getValue(collection));
    }

    public void testListWithThis() throws Exception {
        AbstractListMetaData collection = this.getCollection("ListWithThis.xml");
        ListTestCase.assertNull((Object)collection.getType());
        ListTestCase.assertNull((Object)collection.getElementType());
        this.assertThis(this.getValue(collection));
    }

    public void testListWithWildcard() throws Exception {
        AbstractListMetaData collection = this.getCollection("ListWithWildcard.xml");
        ListTestCase.assertNull((Object)collection.getType());
        ListTestCase.assertNull((Object)collection.getElementType());
        this.assertWildcard(this.getValue(collection));
    }

    public void testListWithBean() throws Exception {
        AbstractListMetaData collection = this.getCollection("ListWithBean.xml");
        ListTestCase.assertNull((Object)collection.getType());
        ListTestCase.assertNull((Object)collection.getElementType());
        this.assertBean(this.getValue(collection));
    }

    protected ValueMetaData getValue(AbstractListMetaData collection) {
        ListTestCase.assertEquals((int)1, (int)collection.size());
        return (ValueMetaData)collection.iterator().next();
    }

    public static Test suite() {
        return ListTestCase.suite(ListTestCase.class);
    }

    public ListTestCase(String name) {
        super(name);
    }
}

