/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.util.Set;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractMapMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.test.kernel.deployment.xml.test.AbstractXMLTest;

public class MapTestCase
extends AbstractXMLTest {
    protected AbstractMapMetaData getMap(String name) throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean(name);
        Set properties = bean.getProperties();
        MapTestCase.assertNotNull((Object)properties);
        MapTestCase.assertEquals((int)1, (int)properties.size());
        PropertyMetaData property = (PropertyMetaData)properties.iterator().next();
        MapTestCase.assertNotNull((Object)property);
        ValueMetaData value = property.getValue();
        MapTestCase.assertNotNull((Object)property);
        MapTestCase.assertTrue((boolean)(value instanceof AbstractMapMetaData));
        return (AbstractMapMetaData)value;
    }

    public void testMap() throws Exception {
        AbstractMapMetaData map = this.getMap("Map.xml");
        MapTestCase.assertNull((Object)map.getType());
        MapTestCase.assertNull((Object)map.getKeyType());
        MapTestCase.assertNull((Object)map.getValueType());
    }

    public void testMapWithClass() throws Exception {
        AbstractMapMetaData map = this.getMap("MapWithClass.xml");
        MapTestCase.assertEquals((String)"MapClass", (String)map.getType());
        MapTestCase.assertNull((Object)map.getKeyType());
        MapTestCase.assertNull((Object)map.getValueType());
    }

    public void testMapWithKeyClass() throws Exception {
        AbstractMapMetaData map = this.getMap("MapWithKeyClass.xml");
        MapTestCase.assertNull((Object)map.getType());
        MapTestCase.assertEquals((String)"KeyClass", (String)map.getKeyType());
        MapTestCase.assertNull((Object)map.getValueType());
    }

    public void testMapWithValueClass() throws Exception {
        AbstractMapMetaData map = this.getMap("MapWithValueClass.xml");
        MapTestCase.assertNull((Object)map.getType());
        MapTestCase.assertNull((Object)map.getKeyType());
        MapTestCase.assertEquals((String)"ValueClass", (String)map.getValueType());
    }

    public void testMapWithValue() throws Exception {
        AbstractMapMetaData map = this.getMap("MapWithValue.xml");
        MapTestCase.assertNull((Object)map.getType());
        MapTestCase.assertNull((Object)map.getKeyType());
        MapTestCase.assertNull((Object)map.getValueType());
        this.assertValue("Key", this.getKey(map));
        this.assertValue("Value", this.getValue(map));
    }

    public void testMapWithInjection() throws Exception {
        AbstractMapMetaData map = this.getMap("MapWithInjection.xml");
        MapTestCase.assertNull((Object)map.getType());
        MapTestCase.assertNull((Object)map.getKeyType());
        MapTestCase.assertNull((Object)map.getValueType());
        this.assertInjection(this.getKey(map));
        this.assertInjection(this.getValue(map));
    }

    public void testMapWithCollection() throws Exception {
        AbstractMapMetaData map = this.getMap("MapWithCollection.xml");
        MapTestCase.assertNull((Object)map.getType());
        MapTestCase.assertNull((Object)map.getKeyType());
        MapTestCase.assertNull((Object)map.getValueType());
        this.assertCollection(this.getKey(map));
        this.assertCollection(this.getValue(map));
    }

    public void testMapWithList() throws Exception {
        AbstractMapMetaData map = this.getMap("MapWithList.xml");
        MapTestCase.assertNull((Object)map.getType());
        MapTestCase.assertNull((Object)map.getKeyType());
        MapTestCase.assertNull((Object)map.getValueType());
        this.assertList(this.getKey(map));
        this.assertList(this.getValue(map));
    }

    public void testMapWithSet() throws Exception {
        AbstractMapMetaData map = this.getMap("MapWithSet.xml");
        MapTestCase.assertNull((Object)map.getType());
        MapTestCase.assertNull((Object)map.getKeyType());
        MapTestCase.assertNull((Object)map.getValueType());
        this.assertSet(this.getKey(map));
        this.assertSet(this.getValue(map));
    }

    public void testMapWithArray() throws Exception {
        AbstractMapMetaData map = this.getMap("MapWithArray.xml");
        MapTestCase.assertNull((Object)map.getType());
        MapTestCase.assertNull((Object)map.getKeyType());
        MapTestCase.assertNull((Object)map.getValueType());
        this.assertArray(this.getKey(map));
        this.assertArray(this.getValue(map));
    }

    public void testMapWithMap() throws Exception {
        AbstractMapMetaData map = this.getMap("MapWithMap.xml");
        MapTestCase.assertNull((Object)map.getType());
        MapTestCase.assertNull((Object)map.getKeyType());
        MapTestCase.assertNull((Object)map.getValueType());
        this.assertMap(this.getKey(map));
        this.assertMap(this.getValue(map));
    }

    public void testMapWithNull() throws Exception {
        AbstractMapMetaData map = this.getMap("MapWithNull.xml");
        MapTestCase.assertNull((Object)map.getType());
        MapTestCase.assertNull((Object)map.getKeyType());
        MapTestCase.assertNull((Object)map.getValueType());
        this.assertNullValue(this.getKey(map));
        this.assertNullValue(this.getValue(map));
    }

    public void testMapWithThis() throws Exception {
        AbstractMapMetaData map = this.getMap("MapWithThis.xml");
        MapTestCase.assertNull((Object)map.getType());
        MapTestCase.assertNull((Object)map.getKeyType());
        MapTestCase.assertNull((Object)map.getValueType());
        this.assertThis(this.getKey(map));
        this.assertThis(this.getValue(map));
    }

    public void testMapWithWildcard() throws Exception {
        AbstractMapMetaData map = this.getMap("MapWithWildcard.xml");
        MapTestCase.assertNull((Object)map.getType());
        MapTestCase.assertNull((Object)map.getKeyType());
        MapTestCase.assertNull((Object)map.getValueType());
        this.assertWildcard(this.getKey(map));
        this.assertWildcard(this.getValue(map));
    }

    public void testMapWithBean() throws Exception {
        AbstractMapMetaData map = this.getMap("MapWithBean.xml");
        MapTestCase.assertNull((Object)map.getType());
        MapTestCase.assertNull((Object)map.getKeyType());
        MapTestCase.assertNull((Object)map.getValueType());
        this.assertBean(this.getKey(map));
        this.assertBean(this.getValue(map));
    }

    protected ValueMetaData getKey(AbstractMapMetaData map) {
        MapTestCase.assertEquals((int)1, (int)map.size());
        return (ValueMetaData)map.keySet().iterator().next();
    }

    protected ValueMetaData getValue(AbstractMapMetaData map) {
        MapTestCase.assertEquals((int)1, (int)map.size());
        return (ValueMetaData)map.values().iterator().next();
    }

    public static Test suite() {
        return MapTestCase.suite(MapTestCase.class);
    }

    public MapTestCase(String name) {
        super(name);
    }
}

