/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.jboss.annotation.factory.AnnotationCreator;
import org.jboss.annotation.factory.ast.TokenMgrError;
import org.jboss.beans.metadata.spi.AnnotationMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.StringPropertyReplacer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlType(name="annotationType", propOrder={"annotation"})
public class AbstractAnnotationMetaData
extends JBossObject
implements AnnotationMetaData,
Serializable {
    private static final long serialVersionUID = 2L;
    public String annotation;
    protected Annotation ann;
    protected boolean replace = true;

    public String getAnnotation() {
        return this.annotation;
    }

    @XmlValue
    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public boolean isReplace() {
        return this.replace;
    }

    @XmlAttribute(name="replace")
    public void setReplace(boolean replace) {
        this.replace = replace;
    }

    @Override
    @XmlTransient
    public Annotation getAnnotationInstance() {
        return this.getAnnotationInstance(null);
    }

    @Override
    public Annotation getAnnotationInstance(ClassLoader cl) {
        try {
            String annString = this.annotation;
            if (this.replace) {
                annString = StringPropertyReplacer.replaceProperties((String)annString);
            }
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            this.ann = (Annotation)AnnotationCreator.createAnnotation((String)annString, (ClassLoader)cl);
        }
        catch (TokenMgrError e) {
            throw new RuntimeException("Error creating annotation for " + this.annotation, e);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error creating annotation for " + this.annotation, e);
        }
        return this.ann;
    }

    @Override
    public void initialVisit(MetaDataVisitor visitor) {
        String ann = this.getAnnotation().trim();
        if (ann == null || ann.length() == 0) {
            throw new IllegalArgumentException("Empty annotation content");
        }
        if (!ann.startsWith("@")) {
            throw new IllegalArgumentException("Annotation content must be a fully qualified annotation type name prefixed with '@'");
        }
        visitor.initialVisit(this);
    }

    @Override
    public void describeVisit(MetaDataVisitor vistor) {
        vistor.describeVisit(this);
    }

    @Override
    public Iterator<? extends MetaDataVisitorNode> getChildren() {
        return null;
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append("expr=").append((Object)this.ann);
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append((Object)this.ann);
    }

    protected int getHashCode() {
        return this.annotation.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AbstractAnnotationMetaData)) {
            return false;
        }
        AbstractAnnotationMetaData amd = (AbstractAnnotationMetaData)object;
        return this.replace == amd.replace && this.annotation.equals(amd.annotation);
    }
}

