/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.plugins.builder.MutableParameterizedMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dispatch.InvokeDispatchHelper;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlType(name="valueFactoryType")
public class AbstractValueFactoryMetaData
extends AbstractValueMetaData
implements MutableParameterizedMetaData {
    private static final long serialVersionUID = 2L;
    protected transient KernelControllerContext context;
    protected String method;
    protected String parameter;
    protected String defaultValue;
    protected ControllerState whenRequiredState;
    protected ControllerState dependentState;
    protected List<ParameterMetaData> parameters;

    public AbstractValueFactoryMetaData() {
    }

    public AbstractValueFactoryMetaData(Object value) {
        super(value);
    }

    public AbstractValueFactoryMetaData(Object value, String method) {
        this(value, method, null);
    }

    public AbstractValueFactoryMetaData(Object value, String method, String defaultValue) {
        super(value);
        this.method = method;
        this.defaultValue = defaultValue;
    }

    @XmlAttribute(name="bean", required=true)
    public void setBean(String bean) {
        this.setValue(bean);
    }

    public String getMethod() {
        return this.method;
    }

    @XmlAttribute(required=true)
    public void setMethod(String method) {
        this.method = method;
    }

    public String getParameter() {
        return this.parameter;
    }

    @XmlAttribute
    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    @XmlAttribute(name="whenRequired")
    public void setWhenRequiredState(ControllerState whenRequiredState) {
        this.whenRequiredState = whenRequiredState;
        this.flushJBossObjectCache();
    }

    public ControllerState getWhenRequiredState() {
        return this.whenRequiredState;
    }

    @XmlAttribute(name="state")
    public void setDependentState(ControllerState dependentState) {
        this.dependentState = dependentState;
        this.flushJBossObjectCache();
    }

    public ControllerState getDependentState() {
        return this.dependentState;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    @XmlAttribute(name="default")
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public List<ParameterMetaData> getParameters() {
        return this.parameters;
    }

    @Override
    @XmlElement(name="parameter", type=AbstractParameterMetaData.class)
    public void setParameters(List<ParameterMetaData> parameters) {
        this.parameters = parameters;
    }

    @Override
    public void initialVisit(MetaDataVisitor visitor) {
        ControllerState state;
        if (this.getUnderlyingValue() == null || this.getMethod() == null) {
            throw new IllegalArgumentException("Bean or method cannot null: " + this);
        }
        if (this.getParameter() != null && this.getParameters() != null) {
            throw new IllegalArgumentException("Both parameter and parameters cannot be set: " + this);
        }
        if (this.getParameter() != null) {
            ArrayList<ParameterMetaData> parameters = new ArrayList<ParameterMetaData>();
            parameters.add(new AbstractParameterMetaData(String.class.getName(), this.getParameter()));
            this.setParameters(parameters);
            this.setParameter(null);
        }
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                this.parameters.get(i).setIndex(i);
            }
        }
        this.context = visitor.getControllerContext();
        Object name = this.context.getName();
        Object iDependOn = this.getUnderlyingValue();
        ControllerState whenRequired = this.whenRequiredState;
        if (whenRequired == null) {
            whenRequired = visitor.getContextState();
        }
        if ((state = this.dependentState) == null) {
            state = ControllerState.INSTALLED;
        }
        AbstractDependencyItem item = new AbstractDependencyItem(name, iDependOn, whenRequired, state);
        visitor.addDependency((DependencyItem)item);
        super.initialVisit(visitor);
    }

    @Override
    @XmlTransient
    public Iterator<? extends MetaDataVisitorNode> getChildren() {
        if (this.getParameters() != null) {
            return this.getParameters().iterator();
        }
        return null;
    }

    @Override
    public Object getValue(TypeInfo info, ClassLoader cl) throws Throwable {
        KernelController controller;
        ControllerContext lookup;
        ControllerState state = this.dependentState;
        if (state == null) {
            state = ControllerState.INSTALLED;
        }
        if ((lookup = (controller = (KernelController)this.context.getController()).getContext(this.getUnderlyingValue(), state)) == null) {
            throw new Error("Should not be here - dependency failed - " + this);
        }
        if (!(lookup instanceof InvokeDispatchContext)) {
            throw new IllegalArgumentException("Underlying context is not InvokeDispatchContext: " + this.context);
        }
        Kernel kernel = controller.getKernel();
        KernelConfigurator configurator = kernel.getConfigurator();
        Object result = InvokeDispatchHelper.invoke(configurator, lookup.getTarget(), (InvokeDispatchContext)lookup, this.getMethod(), this.getParameters());
        if (result == null) {
            result = this.defaultValue;
        }
        return info != null ? info.convertValue(result) : result;
    }

    @Override
    public void toString(JBossStringBuilder buffer) {
        super.toString(buffer);
        if (this.method != null) {
            buffer.append(" method=").append(this.method);
        }
        if (this.whenRequiredState != null) {
            buffer.append(" whenRequiredState=").append(this.whenRequiredState.getStateString());
        }
        if (this.dependentState != null) {
            buffer.append(" dependentState=").append(this.dependentState.getStateString());
        }
        if (this.defaultValue != null) {
            buffer.append(" default=").append(this.defaultValue);
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            buffer.append(" parameters=").append(this.parameters);
        }
    }
}

