/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.jboss.beans.metadata.plugins.AbstractTypeMetaData;
import org.jboss.beans.metadata.plugins.SecurityActions;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.logging.Logger;
import org.jboss.reflect.spi.TypeInfo;

@XmlType(name="plainValueType")
public class StringValueMetaData
extends AbstractTypeMetaData {
    private static final long serialVersionUID = 2L;
    private static final Logger log = Logger.getLogger(StringValueMetaData.class);
    private boolean replace = true;
    private boolean trim = true;

    public StringValueMetaData() {
    }

    public StringValueMetaData(String value) {
        super(value);
    }

    public String getValue() {
        return (String)super.getValue();
    }

    @XmlValue
    public void setValue(String value) {
        super.setValue(value);
    }

    public void setValue(Object value) {
        if (value != null && !(value instanceof String)) {
            throw new ClassCastException("value is not a String: " + value);
        }
        super.setValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(TypeInfo info, ClassLoader cl) throws Throwable {
        TypeInfo typeInfo;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("getValue value=" + this.getUnderlyingValue() + " type=" + this.type + " info=" + info));
        }
        if ((typeInfo = this.getTypeInfo(cl)) == null) {
            typeInfo = info;
        }
        if (typeInfo == null) {
            throw new IllegalArgumentException("Unable to determine type for value: " + this.getUnderlyingValue());
        }
        ClassLoader oldCl = SecurityActions.setContextClassLoader(cl);
        try {
            if (typeInfo != info && info != null) {
                Object typeValue = typeInfo.convertValue(this.getUnderlyingValue());
                Object object = info.convertValue(typeValue, this.replace, this.trim);
                return object;
            }
            Object object = typeInfo.convertValue(this.getUnderlyingValue(), this.replace, this.trim);
            return object;
        }
        finally {
            SecurityActions.resetContextClassLoader(oldCl);
        }
    }

    protected Object getDefaultInstance() {
        return null;
    }

    public TypeInfo getType(MetaDataVisitor visitor, MetaDataVisitorNode previous) throws Throwable {
        if (this.getType() != null) {
            return this.getClass(visitor, this.getType());
        }
        return super.getType(visitor, previous);
    }

    public boolean isReplace() {
        return this.replace;
    }

    @XmlAttribute(name="replace")
    public void setReplace(boolean replace) {
        this.replace = replace;
    }

    public boolean isTrim() {
        return this.trim;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }
}

