/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins.factory;

import java.util.List;
import java.util.Map;
import org.jboss.beans.info.spi.BeanAccessMode;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.LifecycleMetaData;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.factory.BeanFactory;
import org.jboss.joinpoint.spi.Joinpoint;
import org.jboss.joinpoint.spi.JoinpointException;
import org.jboss.joinpoint.spi.MethodJoinpoint;
import org.jboss.joinpoint.spi.TargettedJoinpoint;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContextAware;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericBeanFactory
implements BeanFactory,
KernelControllerContextAware {
    private static final Logger log = Logger.getLogger(GenericBeanFactory.class);
    protected KernelConfigurator configurator;
    protected KernelControllerContext context;
    protected String bean;
    protected BeanAccessMode accessMode;
    protected ClassLoaderMetaData classLoader;
    protected ConstructorMetaData constructor;
    protected Map<String, ValueMetaData> properties;
    protected LifecycleMetaData create;
    protected LifecycleMetaData start;

    public GenericBeanFactory(KernelConfigurator configurator) {
        this.configurator = configurator;
    }

    @Override
    public Object createBean() throws Throwable {
        ClassLoader cl = null;
        if (this.classLoader == null && this.context != null) {
            try {
                cl = this.context.getClassLoader();
            }
            catch (Throwable t) {
                log.trace((Object)("Unable to retrieve classloader from " + this.context));
            }
        }
        if (cl == null) {
            cl = Configurator.getClassLoader(this.classLoader);
        }
        BeanInfo info = null;
        if (this.bean != null) {
            info = this.configurator.getBeanInfo(this.bean, cl, this.accessMode);
        }
        Joinpoint joinpoint = this.configurator.getConstructorJoinPoint(info, this.constructor, null);
        Object result = joinpoint.dispatch();
        if (info == null && result != null) {
            info = this.configurator.getBeanInfo(result.getClass(), this.accessMode);
        }
        if (this.properties != null && this.properties.size() > 0) {
            for (Map.Entry<String, ValueMetaData> entry : this.properties.entrySet()) {
                String property = entry.getKey();
                ValueMetaData vmd = entry.getValue();
                TargettedJoinpoint jp = this.configurator.getPropertySetterJoinPoint(info, property, cl, vmd);
                jp.setTarget(result);
                jp.dispatch();
            }
        }
        this.invokeLifecycle("create", this.create, info, cl, result);
        this.invokeLifecycle("start", this.start, info, cl, result);
        return result;
    }

    @Override
    public void setKernelControllerContext(KernelControllerContext context) throws Exception {
        this.context = context;
    }

    @Override
    public void unsetKernelControllerContext(KernelControllerContext context) throws Exception {
        this.context = null;
    }

    public String getBean() {
        return this.bean;
    }

    public void setBean(String bean) {
        this.bean = bean;
    }

    public BeanAccessMode getAccessMode() {
        return this.accessMode;
    }

    public void setAccessMode(BeanAccessMode accessMode) {
        this.accessMode = accessMode;
    }

    public ClassLoaderMetaData getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoaderMetaData classLoader) {
        this.classLoader = classLoader;
    }

    public ConstructorMetaData getConstructor() {
        return this.constructor;
    }

    public void setConstructor(ConstructorMetaData constructor) {
        this.constructor = constructor;
    }

    public Map<String, ValueMetaData> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, ValueMetaData> properties) {
        this.properties = properties;
    }

    public LifecycleMetaData getCreate() {
        return this.create;
    }

    public void setCreate(LifecycleMetaData create) {
        this.create = create;
    }

    public LifecycleMetaData getStart() {
        return this.start;
    }

    public void setStart(LifecycleMetaData start) {
        this.start = start;
    }

    protected void invokeLifecycle(String methodName, LifecycleMetaData lifecycle, BeanInfo info, ClassLoader cl, Object target) throws Throwable {
        if (lifecycle == null || !lifecycle.isIgnored()) {
            MethodJoinpoint joinpoint;
            String method = methodName;
            if (lifecycle != null && lifecycle.getMethodName() != null) {
                method = lifecycle.getMethodName();
            }
            List<ParameterMetaData> parameters = null;
            if (lifecycle != null) {
                parameters = lifecycle.getParameters();
            }
            try {
                joinpoint = this.configurator.getMethodJoinPoint(info, cl, method, parameters, false, true);
            }
            catch (JoinpointException ignored) {
                return;
            }
            joinpoint.setTarget(target);
            joinpoint.dispatch();
        }
    }
}

