/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.deployment;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.jboss.beans.metadata.plugins.AbstractClassLoaderMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.logging.Logger;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractKernelDeployer {
    private static final Logger log = Logger.getLogger(AbstractKernelDeployer.class);
    protected Kernel kernel;
    protected KernelController controller;
    protected ControllerState requiredState;
    protected ControllerMode mode;

    public AbstractKernelDeployer(Kernel kernel) {
        this(kernel, null, null);
    }

    public AbstractKernelDeployer(Kernel kernel, ControllerMode mode) {
        this(kernel, null, mode);
    }

    public AbstractKernelDeployer(final Kernel kernel, ControllerState requiredState, ControllerMode mode) {
        if (kernel == null) {
            throw new IllegalArgumentException("Null kernel");
        }
        this.kernel = kernel;
        PrivilegedAction<Object> action = new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                AbstractKernelDeployer.this.controller = kernel.getController();
                return null;
            }
        };
        AccessController.doPrivileged(action);
        this.requiredState = requiredState;
        this.mode = mode;
    }

    public void deploy(KernelDeployment deployment) throws Throwable {
        if (deployment.isInstalled()) {
            throw new IllegalArgumentException("Already installed " + deployment.getName());
        }
        try {
            this.deployBeans(this.controller, deployment);
            deployment.setInstalled(true);
        }
        catch (Throwable t) {
            this.undeploy(deployment);
            throw t;
        }
    }

    public void change(KernelDeployment deployment, ControllerState state) throws Throwable {
        if (!deployment.isInstalled()) {
            throw new IllegalStateException("Not installed " + deployment.getName());
        }
        this.changeBeans(this.controller, deployment, state);
    }

    public void undeploy(KernelDeployment deployment) {
        this.undeployBeans(this.controller, deployment);
        deployment.setInstalled(false);
    }

    public void validate() throws Throwable {
        Set notInstalled = this.controller.getNotInstalled();
        this.internalValidate(notInstalled);
    }

    public void validate(KernelDeployment deployment) throws Throwable {
        HashSet<ControllerContext> notInstalled = new HashSet<ControllerContext>(deployment.getInstalledContexts());
        this.internalValidate(notInstalled);
    }

    protected void internalValidate(Set<ControllerContext> notInstalled) throws Throwable {
        List states = this.controller.getStates();
        if (!notInstalled.isEmpty()) {
            Iterator<ControllerContext> i = notInstalled.iterator();
            while (i.hasNext()) {
                ControllerContext context = i.next();
                if (!context.getState().equals((Object)context.getRequiredState())) continue;
                i.remove();
            }
            if (!notInstalled.isEmpty()) {
                HashSet<ControllerContext> errors = new HashSet<ControllerContext>();
                HashSet<ControllerContext> incomplete = new HashSet<ControllerContext>();
                for (ControllerContext ctx : notInstalled) {
                    if (ctx.getState().equals((Object)ControllerState.ERROR)) {
                        errors.add(ctx);
                        continue;
                    }
                    incomplete.add(ctx);
                }
                JBossStringBuilder buffer = new JBossStringBuilder();
                buffer.append("Incompletely deployed:\n");
                if (errors.size() != 0) {
                    buffer.append("\n*** DEPLOYMENTS IN ERROR: Name -> Error\n");
                    for (ControllerContext ctx : errors) {
                        buffer.append(ctx.getName()).append(" -> ").append(ctx.getError().toString()).append('\n');
                    }
                }
                if (incomplete.size() != 0) {
                    buffer.append("\n*** DEPLOYMENTS MISSING DEPENDENCIES: Name -> Dependency{Required State:Actual State}\n");
                    for (ControllerContext ctx : incomplete) {
                        Object name = ctx.getName();
                        buffer.append(name).append(" -> ");
                        DependencyInfo dependsInfo = ctx.getDependencyInfo();
                        Set depends = dependsInfo.getIDependOn(null);
                        boolean first = true;
                        for (DependencyItem item : depends) {
                            ControllerState dependentState = item.getDependentState();
                            ControllerState otherState = null;
                            ControllerContext other = null;
                            Object iDependOn = item.getIDependOn();
                            if (iDependOn != null && (other = this.controller.getContext(iDependOn, null)) != null) {
                                otherState = other.getState();
                            }
                            boolean print = true;
                            if (name.equals(iDependOn)) {
                                print = false;
                            }
                            if (otherState != null && !otherState.equals((Object)ControllerState.ERROR)) {
                                int index1 = states.indexOf(dependentState);
                                int index2 = states.indexOf(otherState);
                                if (index2 >= index1) {
                                    print = false;
                                }
                            }
                            if (!print) continue;
                            if (first) {
                                first = false;
                            } else {
                                buffer.append(", ");
                            }
                            buffer.append(iDependOn).append('{').append(dependentState.getStateString());
                            buffer.append(':');
                            if (iDependOn == null) {
                                buffer.append("** UNRESOLVED " + item.toHumanReadableString() + " **");
                            } else if (other == null) {
                                buffer.append("** NOT FOUND **");
                            } else {
                                buffer.append(otherState.getStateString());
                            }
                            buffer.append('}');
                        }
                        buffer.append('\n');
                    }
                }
                throw new IllegalStateException(buffer.toString());
            }
        }
    }

    protected void deployBeans(KernelController controller, KernelDeployment deployment) throws Throwable {
        List<BeanMetaData> beans = deployment.getBeans();
        if (beans != null) {
            for (BeanMetaData metaData : beans) {
                KernelControllerContext context = this.deployBean(controller, deployment, metaData);
                deployment.addInstalledContext(context);
            }
        }
    }

    protected KernelControllerContext deployBean(KernelController controller, KernelDeployment deployment, BeanMetaData bean) throws Throwable {
        ClassLoaderMetaData deploymentClassLoader;
        ClassLoaderMetaData beanClassLoader;
        AbstractKernelControllerContext context = new AbstractKernelControllerContext(null, bean, null);
        if (this.requiredState != null) {
            context.setRequiredState(this.requiredState);
        }
        if (this.mode != null) {
            context.setMode(this.mode);
        }
        if ((beanClassLoader = bean.getClassLoader()) == null && deployment != null && (deploymentClassLoader = deployment.getClassLoader()) != null) {
            ValueMetaData classLoader = deploymentClassLoader.getClassLoader();
            if (classLoader instanceof BeanMetaData) {
                classLoader = new AbstractDependencyValueMetaData(((BeanMetaData)classLoader).getName());
                beanClassLoader = new AbstractClassLoaderMetaData(classLoader);
            } else {
                beanClassLoader = deploymentClassLoader;
            }
            bean.setClassLoader(beanClassLoader);
        }
        controller.install(context);
        return context;
    }

    protected void changeBeans(KernelController controller, KernelDeployment deployment, ControllerState state) throws Throwable {
        List<KernelControllerContext> contexts = deployment.getInstalledContexts();
        if (contexts != null) {
            for (KernelControllerContext context : contexts) {
                this.changeBean(controller, context, state);
            }
        }
    }

    protected void changeBean(KernelController controller, KernelControllerContext context, ControllerState state) throws Throwable {
        if (ControllerMode.MANUAL.equals((Object)context.getMode()) && !ControllerState.ERROR.equals((Object)context.getState())) {
            controller.change(context, state);
        }
    }

    protected void undeployBeans(KernelController controller, KernelDeployment deployment) {
        List<KernelControllerContext> contexts = deployment.getInstalledContexts();
        if (!contexts.isEmpty()) {
            ListIterator<KernelControllerContext> i = contexts.listIterator(contexts.size());
            while (i.hasPrevious()) {
                KernelControllerContext context = i.previous();
                try {
                    this.undeployBean(controller, context);
                    deployment.removeInstalledContext(context);
                }
                catch (Throwable ignored) {
                    log.warn((Object)("Ignored error during uninstall of " + context), ignored);
                }
            }
        }
    }

    protected void undeployBean(KernelController controller, KernelControllerContext context) throws Throwable {
        if (!controller.isShutdown()) {
            controller.uninstall(context.getName());
        } else {
            log.debug((Object)("Not undeploying " + context.getName() + " the controller is shutdown!"));
        }
    }
}

