/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.lazy;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.plugins.lazy.AbstractLazyInitializer;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.registry.KernelBus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistLazyInitializer
extends AbstractLazyInitializer {
    private static final MethodFilter FINALIZE_FILTER = new MethodFilter(){

        public boolean isHandled(Method m) {
            return !"finalize".equals(m.getName()) || m.getParameterTypes().length != 0;
        }
    };

    @Override
    public Object initializeProxy(Kernel kernel, String bean, boolean exposeClass, Set<String> interfaces) throws Throwable {
        KernelControllerContext context = this.getKernelControllerContext(kernel, bean);
        BeanInfo beanInfo = context.getBeanInfo();
        if (beanInfo == null) {
            throw new IllegalArgumentException("Cannot proxy factory beans.");
        }
        ProxyFactory factory = new ProxyFactory();
        factory.setFilter(FINALIZE_FILTER);
        if (exposeClass) {
            factory.setSuperclass(beanInfo.getClassInfo().getType());
        }
        if (interfaces != null && interfaces.size() > 0) {
            ClassLoader cl = Configurator.getClassLoader(context.getBeanMetaData());
            factory.setInterfaces((Class[])JavassistLazyInitializer.getClasses(kernel.getConfigurator(), interfaces, cl));
        }
        Class<?> proxyClass = this.getProxyClass(factory);
        ProxyObject proxy = (ProxyObject)proxyClass.newInstance();
        proxy.setHandler((MethodHandler)new LazyHandler(bean, kernel.getBus(), beanInfo.getClassInfo().getType()));
        return proxy;
    }

    protected Class<?> getProxyClass(ProxyFactory factory) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return factory.createClass();
        }
        return (Class)AccessController.doPrivileged(new ClassCreator(factory));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ClassCreator
    implements PrivilegedAction<Class<?>> {
        private ProxyFactory factory;

        public ClassCreator(ProxyFactory factory) {
            this.factory = factory;
        }

        @Override
        public Class<?> run() {
            return this.factory.createClass();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LazyHandler
    extends AbstractLazyInitializer.AbstractInvokeHandler
    implements MethodHandler {
        public LazyHandler(String bean, KernelBus bus, Class<?> proxyClass) {
            super(JavassistLazyInitializer.this, bean, bus, proxyClass);
        }

        public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
            return this.executeInvoke(self, thisMethod, args);
        }
    }
}

