/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.HashSet;
import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.annotations.AnnotationPlugin;
import org.jboss.kernel.plugins.annotations.BeanAnnotationAdapter;
import org.jboss.kernel.plugins.annotations.PropertyAware;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
import org.jboss.logging.Logger;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.signature.ConstructorSignature;
import org.jboss.metadata.spi.signature.FieldSignature;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.MethodInfo;

public abstract class AbstractBeanAnnotationAdapter
implements BeanAnnotationAdapter {
    protected Logger log = Logger.getLogger(AbstractBeanAnnotationAdapter.class);
    protected Set<AnnotationPlugin> classAnnotationPlugins = new HashSet<AnnotationPlugin>();
    protected Set<AnnotationPlugin> constructorAnnotationPlugins = new HashSet<AnnotationPlugin>();
    protected Set<AnnotationPlugin> propertyAnnotationPlugins = new HashSet<AnnotationPlugin>();
    protected Set<AnnotationPlugin> methodAnnotationPlugins = new HashSet<AnnotationPlugin>();
    protected Set<AnnotationPlugin> fieldAnnotationPlugins = new HashSet<AnnotationPlugin>();

    public void addAnnotationPlugin(AnnotationPlugin plugin) {
        Set<ElementType> supported;
        if (plugin == null) {
            throw new IllegalArgumentException("Null plugin.");
        }
        Class annotation = plugin.getAnnotation();
        if (annotation == null) {
            throw new IllegalArgumentException("Null annotation class: " + plugin);
        }
        if (annotation.getAnnotation(Target.class) == null) {
            this.log.warn((Object)("Annotation " + annotation + " missing @Target annotation!"));
        }
        if (annotation.getAnnotation(Retention.class) == null) {
            this.log.warn((Object)("Annotation " + annotation + " missing @Retention annotation!"));
        }
        if ((supported = plugin.getSupportedTypes()) == null || supported.isEmpty()) {
            throw new IllegalArgumentException("Null or empty support types: " + plugin);
        }
        if (supported.contains((Object)ElementType.TYPE)) {
            this.classAnnotationPlugins.add(plugin);
        }
        if (supported.contains((Object)ElementType.CONSTRUCTOR)) {
            this.constructorAnnotationPlugins.add(plugin);
        }
        if (supported.contains((Object)ElementType.METHOD)) {
            if (plugin instanceof PropertyAware) {
                this.propertyAnnotationPlugins.add(plugin);
            } else {
                this.methodAnnotationPlugins.add(plugin);
            }
        }
        if (supported.contains((Object)ElementType.FIELD)) {
            this.fieldAnnotationPlugins.add(plugin);
        }
    }

    public void removeAnnotationPlugin(AnnotationPlugin plugin) {
        if (plugin == null) {
            return;
        }
        Set<ElementType> supported = plugin.getSupportedTypes();
        if (supported == null || supported.isEmpty()) {
            throw new IllegalArgumentException("Null or empty support types: " + plugin);
        }
        if (supported.contains((Object)ElementType.TYPE)) {
            this.classAnnotationPlugins.remove(plugin);
        }
        if (supported.contains((Object)ElementType.CONSTRUCTOR)) {
            this.constructorAnnotationPlugins.remove(plugin);
        }
        if (supported.contains((Object)ElementType.METHOD)) {
            if (plugin instanceof PropertyAware) {
                this.propertyAnnotationPlugins.remove(plugin);
            } else {
                this.methodAnnotationPlugins.remove(plugin);
            }
        }
        if (supported.contains((Object)ElementType.FIELD)) {
            this.fieldAnnotationPlugins.remove(plugin);
        }
    }

    public void applyAnnotations(MetaDataVisitor visitor) throws Throwable {
        this.handleAnnotations(visitor, true);
    }

    public void cleanAnnotations(MetaDataVisitor visitor) throws Throwable {
        this.handleAnnotations(visitor, false);
    }

    protected void handleAnnotations(MetaDataVisitor visitor, boolean isApplyPhase) throws Throwable {
        MethodInfo[] staticMethods;
        Set methods;
        if (visitor == null) {
            throw new IllegalArgumentException("Null meta data visitor.");
        }
        KernelControllerContext context = visitor.getControllerContext();
        Kernel kernel = context.getKernel();
        KernelMetaDataRepository repository = kernel.getMetaDataRepository();
        MetaData retrieval = repository.getMetaData(context);
        boolean trace = this.log.isTraceEnabled();
        BeanInfo info = context.getBeanInfo();
        Object name = context.getName();
        if (trace) {
            this.log.trace((Object)(name + " apply annotations"));
        }
        ClassInfo classInfo = info.getClassInfo();
        for (AnnotationPlugin plugin : this.classAnnotationPlugins) {
            if (isApplyPhase) {
                plugin.applyAnnotation(classInfo, retrieval, visitor);
                continue;
            }
            plugin.cleanAnnotation(classInfo, retrieval, visitor);
        }
        Set constructors = info.getConstructors();
        if (constructors != null && !constructors.isEmpty()) {
            for (ConstructorInfo ci : constructors) {
                ConstructorSignature cis = new ConstructorSignature(Configurator.getParameterTypes(trace, ci.getParameterTypes()));
                MetaData cmdr = retrieval.getComponentMetaData((Signature)cis);
                if (cmdr != null) {
                    for (AnnotationPlugin plugin : this.constructorAnnotationPlugins) {
                        if (isApplyPhase) {
                            plugin.applyAnnotation(ci, cmdr, visitor);
                            continue;
                        }
                        plugin.cleanAnnotation(ci, cmdr, visitor);
                    }
                    continue;
                }
                if (!trace) continue;
                this.log.trace((Object)("No annotations for " + ci));
            }
        } else if (trace) {
            this.log.trace((Object)"No constructors");
        }
        HashSet<MethodInfo> visitedMethods = new HashSet<MethodInfo>();
        Set properties = info.getProperties();
        if (properties != null && !properties.isEmpty()) {
            for (PropertyInfo pi : properties) {
                MetaData cmdr;
                FieldSignature sis;
                MethodInfo setter = pi.getSetter();
                FieldInfo field = pi.getFieldInfo();
                if (setter != null) {
                    visitedMethods.add(setter);
                    sis = new MethodSignature(setter);
                    cmdr = retrieval.getComponentMetaData((Signature)sis);
                    if (cmdr != null) {
                        for (AnnotationPlugin plugin : this.propertyAnnotationPlugins) {
                            if (isApplyPhase) {
                                plugin.applyAnnotation(pi, cmdr, visitor);
                                continue;
                            }
                            plugin.cleanAnnotation(pi, cmdr, visitor);
                        }
                        continue;
                    }
                    if (!trace) continue;
                    this.log.trace((Object)("No annotations for property " + pi.getName()));
                    continue;
                }
                if (field == null) continue;
                sis = new FieldSignature(field);
                cmdr = retrieval.getComponentMetaData((Signature)sis);
                if (cmdr != null) {
                    for (AnnotationPlugin plugin : this.fieldAnnotationPlugins) {
                        if (isApplyPhase) {
                            plugin.applyAnnotation(field, cmdr, visitor);
                            continue;
                        }
                        plugin.cleanAnnotation(field, cmdr, visitor);
                    }
                    continue;
                }
                if (!trace) continue;
                this.log.trace((Object)("No annotations for field " + field.getName()));
            }
        } else if (trace) {
            this.log.trace((Object)"No properties");
        }
        if ((methods = info.getMethods()) != null && !methods.isEmpty()) {
            for (MethodInfo mi : methods) {
                if (visitedMethods.contains(mi)) continue;
                MethodSignature mis = new MethodSignature(mi);
                MetaData cmdr = retrieval.getComponentMetaData((Signature)mis);
                if (cmdr != null) {
                    for (AnnotationPlugin plugin : this.methodAnnotationPlugins) {
                        if (isApplyPhase) {
                            plugin.applyAnnotation(mi, cmdr, visitor);
                            continue;
                        }
                        plugin.cleanAnnotation(mi, cmdr, visitor);
                    }
                    continue;
                }
                if (!trace) continue;
                this.log.trace((Object)("No annotations for " + mi));
            }
        } else if (trace) {
            this.log.trace((Object)"No methods");
        }
        if ((staticMethods = classInfo.getDeclaredMethods()) != null && staticMethods.length != 0) {
            for (MethodInfo smi : staticMethods) {
                if (!smi.isStatic() || !smi.isPublic()) continue;
                MethodSignature mis = new MethodSignature(smi);
                MetaData cmdr = retrieval.getComponentMetaData((Signature)mis);
                if (cmdr != null) {
                    for (AnnotationPlugin plugin : this.methodAnnotationPlugins) {
                        if (isApplyPhase) {
                            plugin.applyAnnotation(smi, cmdr, visitor);
                            continue;
                        }
                        plugin.cleanAnnotation(smi, cmdr, visitor);
                    }
                    continue;
                }
                if (!trace) continue;
                this.log.trace((Object)("No annotations for " + smi));
            }
        } else if (trace) {
            this.log.trace((Object)"No static methods");
        }
    }
}

