/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.annotations;

import java.util.ArrayList;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.api.annotations.JavaBeanValue;
import org.jboss.beans.metadata.api.annotations.NullValue;
import org.jboss.beans.metadata.api.annotations.Parameter;
import org.jboss.beans.metadata.api.annotations.StringValue;
import org.jboss.beans.metadata.api.annotations.ThisValue;
import org.jboss.beans.metadata.api.annotations.Value;
import org.jboss.beans.metadata.api.annotations.ValueFactory;
import org.jboss.beans.metadata.api.model.FromContext;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueFactoryMetaData;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.plugins.annotations.InjectAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.JavaBeanValueAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.NullValueAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.StringValueAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.ThisValueAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.ValueFactoryAnnotationPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ValueUtil {
    ValueUtil() {
    }

    private static void checkValueMetaData(ValueMetaData value) {
        if (value != null) {
            throw new IllegalArgumentException("@Value/@Parameter annotation has too many values set!");
        }
    }

    static boolean isAttributePresent(String value) {
        return value != null && value.length() > 0;
    }

    static boolean isAttributePresent(Class<?> value) {
        return value != null && !Void.TYPE.equals(value);
    }

    static ValueMetaData createValueMetaData(Value value) {
        JavaBeanValue javabean;
        NullValue nullValue;
        ThisValue thisValue;
        ValueFactory vf;
        Inject inject;
        ValueMetaData vmd = null;
        StringValue string = value.string();
        if (ValueUtil.isAttributePresent(string.value())) {
            vmd = StringValueAnnotationPlugin.INSTANCE.createValueMetaData(string);
        }
        if ((inject = value.inject()).valid()) {
            ValueUtil.checkValueMetaData(vmd);
            vmd = InjectAnnotationPlugin.INSTANCE.createValueMetaData(inject);
        }
        if (ValueUtil.isAttributePresent((vf = value.valueFactory()).bean())) {
            ValueUtil.checkValueMetaData(vmd);
            vmd = ValueFactoryAnnotationPlugin.INSTANCE.createValueMetaData(vf);
        }
        if ((thisValue = value.thisValue()).valid()) {
            ValueUtil.checkValueMetaData(vmd);
            vmd = ThisValueAnnotationPlugin.INSTANCE.createValueMetaData(thisValue);
        }
        if ((nullValue = value.nullValue()).valid()) {
            ValueUtil.checkValueMetaData(vmd);
            vmd = NullValueAnnotationPlugin.INSTANCE.createValueMetaData(nullValue);
        }
        if (ValueUtil.isAttributePresent((javabean = value.javabean()).value())) {
            ValueUtil.checkValueMetaData(vmd);
            vmd = JavaBeanValueAnnotationPlugin.INSTANCE.createValueMetaData(javabean);
        }
        if (vmd == null) {
            throw new IllegalArgumentException("No value set on @Value annotation!");
        }
        return vmd;
    }

    static ValueMetaData createValueMetaData(Parameter parameter) {
        JavaBeanValue javabean;
        NullValue nullValue;
        ThisValue thisValue;
        Inject inject;
        ValueMetaData vmd = null;
        StringValue string = parameter.string();
        if (ValueUtil.isAttributePresent(string.value())) {
            vmd = StringValueAnnotationPlugin.INSTANCE.createValueMetaData(string);
        }
        if ((inject = parameter.inject()).valid()) {
            ValueUtil.checkValueMetaData(vmd);
            vmd = InjectAnnotationPlugin.INSTANCE.createValueMetaData(inject);
        }
        if ((thisValue = parameter.thisValue()).valid()) {
            ValueUtil.checkValueMetaData(vmd);
            vmd = ThisValueAnnotationPlugin.INSTANCE.createValueMetaData(thisValue);
        }
        if ((nullValue = parameter.nullValue()).valid()) {
            ValueUtil.checkValueMetaData(vmd);
            vmd = NullValueAnnotationPlugin.INSTANCE.createValueMetaData(nullValue);
        }
        if (ValueUtil.isAttributePresent((javabean = parameter.javabean()).value())) {
            ValueUtil.checkValueMetaData(vmd);
            vmd = JavaBeanValueAnnotationPlugin.INSTANCE.createValueMetaData(javabean);
        }
        if (vmd == null) {
            throw new IllegalArgumentException("No value set on @Value annotation!");
        }
        return vmd;
    }

    static ValueMetaData createValueMetaData(Inject annotation) {
        AbstractInjectionValueMetaData injection = new AbstractInjectionValueMetaData();
        if (ValueUtil.isAttributePresent(annotation.bean())) {
            injection.setValue(annotation.bean());
        }
        if (ValueUtil.isAttributePresent(annotation.property())) {
            injection.setProperty(annotation.property());
        }
        injection.setDependentState(new ControllerState(annotation.dependentState()));
        if (ValueUtil.isAttributePresent(annotation.whenRequired())) {
            injection.setWhenRequiredState(new ControllerState(annotation.whenRequired()));
        }
        injection.setInjectionOption(annotation.option());
        injection.setInjectionType(annotation.type());
        if (!FromContext.NOOP.equals((Object)annotation.fromContext())) {
            injection.setFromContext(annotation.fromContext());
        }
        return injection;
    }

    static ValueMetaData createValueMetaData(ValueFactory annotation) {
        AbstractValueFactoryMetaData factory = new AbstractValueFactoryMetaData(annotation.bean(), annotation.method());
        if (ValueUtil.isAttributePresent(annotation.defaultValue())) {
            factory.setDefaultValue(annotation.defaultValue());
        }
        ArrayList<ParameterMetaData> parameters = new ArrayList<ParameterMetaData>();
        if (ValueUtil.isAttributePresent(annotation.parameter())) {
            parameters.add(new AbstractParameterMetaData(String.class.getName(), annotation.parameter()));
        }
        if (annotation.parameters().length > 0) {
            if (parameters.size() > 0) {
                throw new IllegalArgumentException("Cannot set both parameter and parameters!");
            }
            for (Parameter parameter : annotation.parameters()) {
                AbstractParameterMetaData apmd = new AbstractParameterMetaData(ValueUtil.createValueMetaData(parameter));
                if (ValueUtil.isAttributePresent(parameter.type())) {
                    apmd.setType(parameter.type().getName());
                }
                parameters.add(apmd);
            }
        }
        factory.setParameters(parameters);
        factory.setDependentState(new ControllerState(annotation.dependantState()));
        factory.setWhenRequiredState(new ControllerState(annotation.whenRequiredState()));
        return factory;
    }
}

