/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.annotations.wb;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.plugins.annotations.wb.CacheKey;
import org.jboss.kernel.plugins.annotations.wb.WBInjectionValueMetaData;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;
import org.jboss.metadata.spi.MetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WBInjectionResolver {
    private static final Logger log = Logger.getLogger(WBInjectionResolver.class);
    private static final Map<CacheKey, Map<KernelControllerContext, Boolean>> cache = new WeakHashMap<CacheKey, Map<KernelControllerContext, Boolean>>();
    private static final Set<Class<? extends Annotation>> excludedAnnotations = new HashSet<Class<? extends Annotation>>();

    static ValueMetaData createValueMetaData(Class<?> type, Annotation[] underlyingAnnotations) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (Annotation annotation : underlyingAnnotations) {
            if (excludedAnnotations.contains(annotation.annotationType())) continue;
            annotations.add(annotation);
        }
        return new WBInjectionValueMetaData(type, annotations.toArray(new Annotation[annotations.size()]));
    }

    public static void addExcludedAnnotation(Class<? extends Annotation> annotationClass) {
        excludedAnnotations.add(annotationClass);
    }

    public static KernelControllerContext resolve(KernelController controller, Class<?> type, Annotation[] annotations) {
        Set contexts;
        if (controller == null) {
            throw new IllegalArgumentException("Null controller");
        }
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        if (annotations == null) {
            annotations = new Annotation[]{};
        }
        if ((contexts = controller.getContexts(type, ControllerState.INSTALLED)) != null && !contexts.isEmpty()) {
            CacheKey key = new CacheKey(type, annotations);
            Map<KernelControllerContext, Boolean> cachedResults = cache.get(key);
            if (cachedResults == null) {
                cachedResults = new WeakHashMap<KernelControllerContext, Boolean>();
                cache.put(key, cachedResults);
            }
            HashSet<KernelControllerContext> matchingContexts = new HashSet<KernelControllerContext>();
            for (KernelControllerContext context : contexts) {
                Boolean match = cachedResults.get(context);
                if (match == null) {
                    match = true;
                    MetaData metaData = context.getScopeInfo().getMetaData();
                    for (Annotation annotation : annotations) {
                        Annotation mdAnnotation = metaData.getAnnotation(annotation.annotationType());
                        if (mdAnnotation != null && ((Object)annotation).equals(mdAnnotation)) continue;
                        match = false;
                        break;
                    }
                }
                if (match.booleanValue()) {
                    matchingContexts.add(context);
                }
                cachedResults.put(context, match);
            }
            int size = matchingContexts.size();
            if (size == 0) {
                return null;
            }
            if (size > 1) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Too many matching contexts: " + matchingContexts));
                }
                return null;
            }
            return (KernelControllerContext)matchingContexts.iterator().next();
        }
        return null;
    }

    static {
        WBInjectionResolver.addExcludedAnnotation(Inject.class);
        WBInjectionResolver.addExcludedAnnotation(SuppressWarnings.class);
        WBInjectionResolver.addExcludedAnnotation(Deprecated.class);
        WBInjectionResolver.addExcludedAnnotation(Override.class);
    }
}

