/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.InstallsAwareAction;
import org.jboss.kernel.spi.dependency.InstallKernelControllerContextAware;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContextAware;
import org.jboss.kernel.spi.registry.KernelRegistry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallAction
extends InstallsAwareAction {
    @Override
    protected void installActionInternal(KernelControllerContext context) throws Throwable {
        KernelController controller = (KernelController)context.getController();
        Kernel kernel = controller.getKernel();
        KernelRegistry registry = kernel.getRegistry();
        BeanMetaData metaData = context.getBeanMetaData();
        String name = metaData.getName();
        registry.registerEntry((Object)name, (KernelRegistryEntry)context);
        try {
            controller.addSupplies(context);
        }
        catch (Throwable t) {
            try {
                registry.unregisterEntry((Object)name);
            }
            catch (Throwable x) {
                this.log.warn((Object)("Ignoring error reversing install, throwing original error " + name), x);
            }
            throw t;
        }
    }

    @Override
    protected Class<? extends KernelControllerContextAware> getActionAwareInterface() {
        return InstallKernelControllerContextAware.class;
    }

    @Override
    protected void uninstallActionInternal(KernelControllerContext context) {
        KernelController controller = (KernelController)context.getController();
        Kernel kernel = controller.getKernel();
        KernelRegistry registry = kernel.getRegistry();
        Object name = context.getName();
        try {
            controller.removeSupplies(context);
        }
        catch (Throwable t) {
            this.log.warn((Object)("Ignoring removing supplies at uninstall " + name), t);
        }
        try {
            registry.unregisterEntry(name);
        }
        catch (Throwable t) {
            this.log.warn((Object)("Ignoring unregistered entry at uninstall " + name), t);
        }
    }

    @Override
    protected ControllerState getState() {
        return ControllerState.INSTALLED;
    }
}

