/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.ScopeInfo;
import org.jboss.joinpoint.spi.Joinpoint;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.AnnotationsAction;
import org.jboss.kernel.plugins.dependency.BeanValidatorBridge;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.InstantiateKernelControllerContextAware;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContextAware;
import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.ScopeKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstantiateAction
extends AnnotationsAction {
    @Override
    protected void installActionInternal(KernelControllerContext context) throws Throwable {
        Object object;
        KernelController controller = (KernelController)context.getController();
        Kernel kernel = controller.getKernel();
        KernelConfigurator configurator = kernel.getConfigurator();
        BeanMetaData metaData = context.getBeanMetaData();
        BeanInfo info = context.getBeanInfo();
        Joinpoint joinPoint = configurator.getConstructorJoinPoint(info, metaData.getConstructor(), metaData);
        BeanValidatorBridge bridge = InstantiateAction.getBeanValidatorBridge(context);
        if (bridge != null) {
            bridge.validateConstructorValues(context, joinPoint);
        }
        if ((object = InstantiateAction.dispatchJoinPoint(context, joinPoint)) == null) {
            throw new IllegalStateException("Instantiate joinpoint returned a null object: " + joinPoint);
        }
        if (bridge != null) {
            bridge.validateInstance(context, object);
        }
        context.setTarget(object);
        try {
            DependencyInfo dependencyInfo;
            if (info == null) {
                info = configurator.getBeanInfo(object.getClass(), metaData.getAccessMode());
                context.setBeanInfo(info);
                KernelMetaDataRepository repository = kernel.getMetaDataRepository();
                repository.removeMetaData((ControllerContext)context);
                ScopeInfo scopeInfo = context.getScopeInfo();
                ScopeKey scopeKey = new ScopeKey(scopeInfo.getScope().getScopes());
                scopeKey.addScope(CommonLevels.CLASS, (Object)info.getClassInfo().getType());
                scopeInfo.setScope(scopeKey);
                repository.addMetaData((ControllerContext)context);
                this.applyAnnotations(context);
            }
            if ((dependencyInfo = context.getDependencyInfo()) != null && dependencyInfo.isAutowireCandidate()) {
                controller.addInstantiatedContext(context);
            }
        }
        catch (Throwable t) {
            this.uninstall((ControllerContext)context);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void uninstallActionInternal(KernelControllerContext context) {
        try {
            KernelController controller = (KernelController)context.getController();
            DependencyInfo dependencyInfo = context.getDependencyInfo();
            if (dependencyInfo != null && dependencyInfo.isAutowireCandidate()) {
                controller.removeInstantiatedContext(context);
            }
        }
        catch (Throwable ignored) {
            this.log.debug((Object)"Ignored error unsetting context ", ignored);
        }
        finally {
            context.setTarget(null);
        }
    }

    @Override
    protected ControllerState getState() {
        return ControllerState.INSTANTIATED;
    }

    @Override
    protected Class<? extends KernelControllerContextAware> getActionAwareInterface() {
        return InstantiateKernelControllerContextAware.class;
    }
}

