/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.plugins.AbstractController;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.InstallsAwareAction;
import org.jboss.kernel.plugins.dependency.ScopedKernelController;
import org.jboss.kernel.plugins.dependency.SecurityActions;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.MutableMetaData;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.retrieval.MetaDataItem;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeFactory;
import org.jboss.metadata.spi.scope.ScopeFactoryLookup;
import org.jboss.metadata.spi.scope.ScopeKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreInstallAction
extends InstallsAwareAction {
    private Map<Class<? extends ScopeFactory<? extends Annotation>>, WeakReference<ScopeFactory<? extends Annotation>>> factories = new WeakHashMap<Class<? extends ScopeFactory<? extends Annotation>>, WeakReference<ScopeFactory<? extends Annotation>>>();

    protected ScopeFactory<? extends Annotation> getScopeFactory(Class<? extends ScopeFactory<? extends Annotation>> clazz) throws Throwable {
        ScopeFactory<? extends Annotation> factory = null;
        WeakReference<ScopeFactory<? extends Annotation>> weak = this.factories.get(clazz);
        if (weak != null && (factory = (ScopeFactory<? extends Annotation>)weak.get()) != null) {
            return factory;
        }
        if (factory == null) {
            factory = clazz.newInstance();
            this.factories.put(clazz, new WeakReference<ScopeFactory<? extends Annotation>>(factory));
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void installActionInternal(KernelControllerContext context) throws Throwable {
        KernelController controller = (KernelController)context.getController();
        Kernel kernel = controller.getKernel();
        KernelConfigurator configurator = kernel.getConfigurator();
        BeanMetaData metaData = context.getBeanMetaData();
        if (metaData.getBean() != null) {
            BeanInfo info = configurator.getBeanInfo(metaData);
            context.setBeanInfo(info);
            KernelMetaDataRepository repository = controller.getKernel().getMetaDataRepository();
            ClassLoader oldCL = SecurityActions.setContextClassLoader(context);
            try {
                repository.addMetaData((ControllerContext)context);
            }
            finally {
                SecurityActions.resetContextClassLoader(oldCL);
            }
            try {
                this.applyScoping(context);
            }
            catch (Throwable t) {
                this.removeMetaData(context);
                throw t;
            }
        }
    }

    protected ScopeKey getInstallScopeKey(KernelControllerContext context, KernelMetaDataRepository repository) throws Throwable {
        Annotation[] annotations;
        MetaData retrieval = repository.getMetaData((ControllerContext)context);
        if (retrieval != null && (annotations = retrieval.getAnnotations()) != null && annotations.length > 0) {
            HashSet<Scope> scopes = new HashSet<Scope>();
            for (Annotation annotation : annotations) {
                if (!annotation.annotationType().isAnnotationPresent(ScopeFactoryLookup.class)) continue;
                ScopeFactoryLookup sfl = annotation.annotationType().getAnnotation(ScopeFactoryLookup.class);
                ScopeFactory<? extends Annotation> scf = this.getScopeFactory(sfl.value());
                Scope scope = scf.create(annotation);
                scopes.add(scope);
            }
            if (scopes.size() > 0) {
                return new ScopeKey(scopes);
            }
        }
        return null;
    }

    protected void applyScoping(KernelControllerContext context) throws Throwable {
        KernelController controller = (KernelController)context.getController();
        KernelMetaDataRepository repository = controller.getKernel().getMetaDataRepository();
        ScopeKey scopeKey = this.getInstallScopeKey(context, repository);
        if (scopeKey != null) {
            ScopedKernelController scopedController;
            MetaDataItem controllerItem;
            scopeKey.freeze();
            context.getScopeInfo().setInstallScope(scopeKey);
            MutableMetaDataRepository mmdr = repository.getMetaDataRepository();
            MetaDataRetrieval mdr = mmdr.getMetaDataRetrieval(scopeKey);
            if (mdr == null) {
                mdr = new MemoryMetaDataLoader(scopeKey);
                mmdr.addMetaDataRetrieval(mdr);
            }
            if ((controllerItem = mdr.retrieveMetaData(ScopedKernelController.class)) != null) {
                scopedController = (ScopedKernelController)((Object)controllerItem.getValue());
            } else {
                AbstractController parentController = null;
                for (ScopeKey parentKey = scopeKey.getParent(); parentController == null && parentKey != null; parentKey = parentKey.getParent()) {
                    MetaDataItem pci;
                    MetaDataRetrieval pmdr = mmdr.getMetaDataRetrieval(parentKey);
                    if (pmdr == null || (pci = pmdr.retrieveMetaData(ScopedKernelController.class)) == null) continue;
                    parentController = (AbstractController)pci.getValue();
                }
                if (parentController == null) {
                    if (!(controller instanceof AbstractController)) {
                        throw new IllegalArgumentException("Underlying controller not AbstractController instance!");
                    }
                    parentController = (AbstractController)controller;
                }
                scopedController = new ScopedKernelController(controller.getKernel(), parentController);
                ((MutableMetaData)mdr).addMetaData((Object)scopedController, ScopedKernelController.class);
            }
            scopedController.addControllerContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeScoping(KernelControllerContext context) throws Throwable {
        KernelController controller = (KernelController)context.getController();
        KernelMetaDataRepository repository = controller.getKernel().getMetaDataRepository();
        ScopeKey scopeKey = context.getScopeInfo().getInstallScope();
        if (scopeKey != null) {
            MutableMetaDataRepository mmdr = repository.getMetaDataRepository();
            MetaDataRetrieval mdr = mmdr.getMetaDataRetrieval(scopeKey);
            if (mdr == null) {
                throw new IllegalArgumentException("Expecting MetaDataRetrieval instance in scope: " + scopeKey);
            }
            MetaDataItem controllerItem = mdr.retrieveMetaData(ScopedKernelController.class);
            if (controllerItem == null) {
                throw new IllegalArgumentException("Expecting ScopedKernelController instance in scope:" + scopeKey);
            }
            ScopedKernelController scopedController = (ScopedKernelController)((Object)controllerItem.getValue());
            scopedController.removeControllerContext(context);
            if (!scopedController.isActive()) {
                try {
                    ((MutableMetaData)mdr).removeMetaData(ScopedKernelController.class);
                }
                finally {
                    scopedController.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void uninstallActionInternal(KernelControllerContext context) {
        try {
            this.removeScoping(context);
        }
        catch (Throwable ignored) {
            this.log.warn((Object)"Unexpected error removing scoping: ", ignored);
        }
        finally {
            this.removeMetaData(context);
            context.setBeanInfo(null);
        }
    }

    private void removeMetaData(KernelControllerContext context) {
        try {
            KernelController controller = (KernelController)context.getController();
            KernelMetaDataRepository repository = controller.getKernel().getMetaDataRepository();
            repository.removeMetaData((ControllerContext)context);
        }
        catch (Throwable ignored) {
            this.log.warn((Object)"Unexpected error removing metadata: ", ignored);
        }
    }

    @Override
    protected ControllerState getState() {
        return ControllerState.PRE_INSTALL;
    }
}

