/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.registry;

import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.kernel.plugins.AbstractKernelObject;
import org.jboss.kernel.spi.registry.KernelRegistry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryEntryNotFoundException;
import org.jboss.kernel.spi.registry.KernelRegistryPlugin;

public abstract class AbstractKernelRegistry
extends AbstractKernelObject
implements KernelRegistry {
    protected List<KernelRegistryPlugin> factories = new CopyOnWriteArrayList<KernelRegistryPlugin>();

    public void addKernelRegistryFactory(KernelRegistryPlugin factory) {
        this.factories.add(factory);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Registry " + this + " added registry factory " + factory));
        }
    }

    public void removeKernelRegistryFactory(KernelRegistryPlugin factory) {
        this.factories.remove(factory);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Registry " + this + " removed registry factory " + factory));
        }
    }

    public KernelRegistryEntry getEntry(Object name) {
        ListIterator<KernelRegistryPlugin> i = this.factories.listIterator();
        while (i.hasNext()) {
            KernelRegistryPlugin factory = i.next();
            KernelRegistryEntry entry = factory.getEntry(name);
            if (entry == null) continue;
            return entry;
        }
        throw new KernelRegistryEntryNotFoundException("Entry not found with name: " + name);
    }

    public boolean containsEntry(Object name) {
        for (KernelRegistryPlugin factory : this.factories) {
            KernelRegistryEntry entry = factory.getEntry(name);
            if (entry == null) continue;
            return true;
        }
        return false;
    }
}

