/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.annotations.test.override;

import java.util.ArrayList;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractInstallMetaData;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.test.kernel.annotations.support.AnnotationTester;
import org.jboss.test.kernel.annotations.test.override.AbstractAnnotationOverrideTestCase;

public class InstallationAnnotationOverrideTestCase
extends AbstractAnnotationOverrideTestCase {
    private Controller controller;
    private ControllerContext context;

    public InstallationAnnotationOverrideTestCase(String name) throws Throwable {
        super(name);
    }

    public InstallationAnnotationOverrideTestCase(String name, boolean xmltest) {
        super(name, xmltest);
    }

    public static Test suite() {
        return InstallationAnnotationOverrideTestCase.suite(InstallationAnnotationOverrideTestCase.class);
    }

    protected String getType() {
        return "Installation";
    }

    protected void addMetaData(AbstractBeanMetaData beanMetaData) {
        ArrayList<AbstractInstallMetaData> installs = new ArrayList<AbstractInstallMetaData>();
        AbstractInstallMetaData in = new AbstractInstallMetaData();
        in.setMethodName("addMyDeployer");
        installs.add(in);
        ArrayList<AbstractInstallMetaData> uninstalls = new ArrayList<AbstractInstallMetaData>();
        AbstractInstallMetaData un = new AbstractInstallMetaData();
        un.setMethodName("removeMyDeployer");
        uninstalls.add(un);
        beanMetaData.setInstalls(installs);
        beanMetaData.setUninstalls(uninstalls);
    }

    public void testCallbackOverride() throws Throwable {
        AnnotationTester tester = this.getTester();
        Object val = tester.getValue();
        this.assertInstanceOf(val, Integer.class);
        Integer count = (Integer)val;
        InstallationAnnotationOverrideTestCase.assertNotNull((Object)count);
        InstallationAnnotationOverrideTestCase.assertEquals((int)1, (int)count);
        this.doUndeploy();
        val = tester.getValue();
        this.assertInstanceOf(val, Integer.class);
        count = (Integer)val;
        InstallationAnnotationOverrideTestCase.assertNotNull((Object)count);
        InstallationAnnotationOverrideTestCase.assertEquals((int)0, (int)count);
    }

    protected void afterInstall(KernelController controller, KernelControllerContext context) throws Throwable {
        this.controller = controller;
        this.context = context;
    }

    protected void doUndeploy() {
        this.controller.uninstall(this.context.getName());
        this.controller = null;
        this.context = null;
    }
}

