/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.config.test;

import java.util.HashSet;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractArrayMetaData;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.plugins.StringValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.test.kernel.config.support.MyObject;
import org.jboss.test.kernel.config.support.SimpleBean;
import org.jboss.test.kernel.config.test.AbstractKernelConfigTest;

public class ArrayTestCase
extends AbstractKernelConfigTest {
    MyObject object1 = new MyObject("object1");
    MyObject object2 = new MyObject("object2");
    String string1 = "string1";
    String string2 = "string2";

    public static Test suite() {
        return ArrayTestCase.suite(ArrayTestCase.class);
    }

    public ArrayTestCase(String name) {
        super(name);
    }

    public ArrayTestCase(String name, boolean xmltest) {
        super(name, xmltest);
    }

    public void testSimpleArrayFromObjects() throws Throwable {
        SimpleBean bean = this.simpleArrayFromObjects();
        ArrayTestCase.assertNotNull((Object)bean);
        Object[] result = bean.getArray();
        ArrayTestCase.assertNotNull((String)"Should be a array", (Object)result);
        Object[] expected = new Object[]{this.object1, this.object2, this.object2, this.object1};
        this.assertEquals(expected, result);
    }

    protected SimpleBean simpleArrayFromObjects() throws Throwable {
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        AbstractValueMetaData vmd1 = new AbstractValueMetaData((Object)this.object1);
        AbstractValueMetaData vmd2 = new AbstractValueMetaData((Object)this.object2);
        AbstractValueMetaData vmd3 = new AbstractValueMetaData((Object)this.object1);
        AbstractArrayMetaData smd = new AbstractArrayMetaData();
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("array", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure((BeanMetaData)bmd);
    }

    public void testSimpleArrayFromStrings() throws Throwable {
        SimpleBean bean = this.simpleArrayFromStrings();
        ArrayTestCase.assertNotNull((Object)bean);
        Object[] result = bean.getArray();
        ArrayTestCase.assertNotNull((String)"Should be a array", (Object)result);
        Object[] expected = new Object[]{this.string1, this.string2, this.string2, this.string1};
        this.assertEquals(expected, result);
    }

    protected SimpleBean simpleArrayFromStrings() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        AbstractArrayMetaData smd = new AbstractArrayMetaData();
        smd.setElementType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("array", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }

    public void testCustomArrayExplicit() throws Throwable {
        SimpleBean bean = this.customArrayExplicit();
        ArrayTestCase.assertNotNull((Object)bean);
        Object[] result = bean.getArray();
        ArrayTestCase.assertNotNull((String)"Should be a array", (Object)result);
        ArrayTestCase.assertTrue((String)("Not a String[]: " + result.getClass()), (boolean)(result instanceof String[]));
        Object[] expected = new Object[]{this.string1, this.string2, this.string2, this.string1};
        this.assertEquals(expected, result);
    }

    protected SimpleBean customArrayExplicit() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        AbstractArrayMetaData smd = new AbstractArrayMetaData();
        smd.setType(new String[0].getClass().getName());
        smd.setElementType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("array", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }

    public void testCustomArrayFromSignature() throws Throwable {
        SimpleBean bean = this.customArrayFromSignature();
        ArrayTestCase.assertNotNull((Object)bean);
        Object[] result = bean.getCustomArray();
        ArrayTestCase.assertNotNull((String)"Should be a array", (Object)result);
        Object[] expected = new Object[]{this.string1, this.string2, this.string2, this.string1};
        this.assertEquals(expected, result);
    }

    protected SimpleBean customArrayFromSignature() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        AbstractArrayMetaData smd = new AbstractArrayMetaData();
        smd.setElementType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("customArray", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }

    public void testArrayWithValueTypeOverride() throws Throwable {
        SimpleBean bean = this.arrayWithValueTypeOverride();
        ArrayTestCase.assertNotNull((Object)bean);
        Object[] result = bean.getArray();
        ArrayTestCase.assertNotNull((String)"Should be a array", (Object)result);
        Object[] expected = new Object[]{this.string1, this.string2, this.string2, this.string1, new Integer(1)};
        this.assertEquals(expected, result);
    }

    protected SimpleBean arrayWithValueTypeOverride() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd4 = new StringValueMetaData("1");
        vmd4.setConfigurator(configurator);
        vmd4.setType("java.lang.Integer");
        AbstractArrayMetaData smd = new AbstractArrayMetaData();
        smd.setElementType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        smd.add((MetaDataVisitorNode)vmd4);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("array", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }

    public void testArrayNotAArray() throws Throwable {
        try {
            this.arrayNotAArray();
            ArrayTestCase.fail((String)"Expected a failure trying to set a array on a non array attribute");
        }
        catch (Exception expected) {
            this.checkArrayNotAArrayException(expected);
        }
    }

    protected void checkArrayNotAArrayException(Exception exception) {
        ArrayTestCase.checkThrowable(ClassCastException.class, (Throwable)exception);
    }

    protected SimpleBean arrayNotAArray() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        AbstractArrayMetaData smd = new AbstractArrayMetaData();
        smd.setElementType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("AString", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }

    public void testArrayIsInterface() throws Throwable {
        SimpleBean bean = this.arrayIsInterface();
        ArrayTestCase.assertNotNull((Object)bean);
        Object[] result = bean.getArray();
        ArrayTestCase.assertNotNull((String)"Should be a array", (Object)result);
        ArrayTestCase.assertTrue((String)("Not a Comparable[]: " + result.getClass()), (boolean)(result instanceof Comparable[]));
        Object[] expected = new Object[]{this.string1, this.string2, this.string2, this.string1};
        this.assertEquals(expected, result);
    }

    protected SimpleBean arrayIsInterface() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        AbstractArrayMetaData smd = new AbstractArrayMetaData();
        smd.setType(new Comparable[0].getClass().getName());
        smd.setElementType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("array", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }
}

