/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.config.test;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashSet;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.test.kernel.config.support.SimpleBean;
import org.jboss.test.kernel.config.test.AbstractKernelConfigTest;

public class ConfigureFromObjectTestCase
extends AbstractKernelConfigTest {
    public static Test suite() {
        return ConfigureFromObjectTestCase.suite(ConfigureFromObjectTestCase.class);
    }

    public ConfigureFromObjectTestCase(String name) {
        super(name);
    }

    public ConfigureFromObjectTestCase(String name, boolean xmltest) {
        super(name, xmltest);
    }

    public void testConfigure() throws Throwable {
        String stringValue = "StringValue";
        Byte byteValue = new Byte("12");
        Boolean booleanValue = Boolean.TRUE;
        Character characterValue = Character.valueOf('a');
        Short shortValue = new Short("123");
        Integer integerValue = new Integer("1234");
        Long longValue = new Long("12345");
        Float floatValue = new Float("3.14");
        Double doubleValue = new Double("3.14e12");
        Date dateValue = this.createDate(2001, 1, 1);
        BigDecimal bigDecimalValue = new BigDecimal("12e4");
        BigInteger bigIntegerValue = new BigInteger("123456");
        SimpleBean.Alphabet enumValue = SimpleBean.Alphabet.Z;
        HashSet<AbstractPropertyMetaData> attributes = new HashSet<AbstractPropertyMetaData>();
        attributes.add(new AbstractPropertyMetaData("AString", stringValue));
        attributes.add(new AbstractPropertyMetaData("AByte", (Object)byteValue));
        attributes.add(new AbstractPropertyMetaData("ABoolean", (Object)booleanValue));
        attributes.add(new AbstractPropertyMetaData("ACharacter", (Object)characterValue));
        attributes.add(new AbstractPropertyMetaData("AShort", (Object)shortValue));
        attributes.add(new AbstractPropertyMetaData("anInt", (Object)integerValue));
        attributes.add(new AbstractPropertyMetaData("ALong", (Object)longValue));
        attributes.add(new AbstractPropertyMetaData("AFloat", (Object)floatValue));
        attributes.add(new AbstractPropertyMetaData("ADouble", (Object)doubleValue));
        attributes.add(new AbstractPropertyMetaData("ADate", (Object)dateValue));
        attributes.add(new AbstractPropertyMetaData("ABigDecimal", (Object)bigDecimalValue));
        attributes.add(new AbstractPropertyMetaData("ABigInteger", (Object)bigIntegerValue));
        attributes.add(new AbstractPropertyMetaData("abyte", (Object)byteValue));
        attributes.add(new AbstractPropertyMetaData("aboolean", (Object)booleanValue));
        attributes.add(new AbstractPropertyMetaData("achar", (Object)characterValue));
        attributes.add(new AbstractPropertyMetaData("ashort", (Object)shortValue));
        attributes.add(new AbstractPropertyMetaData("anint", (Object)integerValue));
        attributes.add(new AbstractPropertyMetaData("along", (Object)longValue));
        attributes.add(new AbstractPropertyMetaData("afloat", (Object)floatValue));
        attributes.add(new AbstractPropertyMetaData("adouble", (Object)doubleValue));
        attributes.add(new AbstractPropertyMetaData("ANumber", (Object)longValue));
        attributes.add(new AbstractPropertyMetaData("overloadedProperty", stringValue));
        attributes.add(new AbstractPropertyMetaData("enumProperty", (Object)enumValue));
        AbstractBeanMetaData metaData = new AbstractBeanMetaData(SimpleBean.class.getName());
        metaData.setProperties(attributes);
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        SimpleBean bean = (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)metaData);
        ConfigureFromObjectTestCase.assertEquals((String)stringValue, (String)bean.getAString());
        ConfigureFromObjectTestCase.assertEquals((Object)byteValue, (Object)bean.getAByte());
        ConfigureFromObjectTestCase.assertEquals((Object)booleanValue, (Object)bean.getABoolean());
        ConfigureFromObjectTestCase.assertEquals((Object)characterValue, (Object)bean.getACharacter());
        ConfigureFromObjectTestCase.assertEquals((Object)shortValue, (Object)bean.getAShort());
        ConfigureFromObjectTestCase.assertEquals((Object)integerValue, (Object)bean.getAnInt());
        ConfigureFromObjectTestCase.assertEquals((Object)longValue, (Object)bean.getALong());
        ConfigureFromObjectTestCase.assertEquals((Object)floatValue, (Object)bean.getAFloat());
        ConfigureFromObjectTestCase.assertEquals((Object)doubleValue, (Object)bean.getADouble());
        ConfigureFromObjectTestCase.assertEquals((Object)dateValue, (Object)bean.getADate());
        ConfigureFromObjectTestCase.assertEquals((Object)bigDecimalValue, (Object)bean.getABigDecimal());
        ConfigureFromObjectTestCase.assertEquals((Object)bigIntegerValue, (Object)bean.getABigInteger());
        ConfigureFromObjectTestCase.assertEquals((byte)byteValue, (byte)bean.getAbyte());
        ConfigureFromObjectTestCase.assertEquals((boolean)booleanValue, (boolean)bean.isAboolean());
        ConfigureFromObjectTestCase.assertEquals((char)characterValue.charValue(), (char)bean.getAchar());
        ConfigureFromObjectTestCase.assertEquals((short)shortValue, (short)bean.getAshort());
        ConfigureFromObjectTestCase.assertEquals((int)integerValue, (int)bean.getAnint());
        ConfigureFromObjectTestCase.assertEquals((long)longValue, (long)bean.getAlong());
        this.assertEquals(floatValue.floatValue(), bean.getAfloat());
        this.assertEquals(doubleValue, bean.getAdouble());
        Number number = bean.getANumber();
        ConfigureFromObjectTestCase.assertEquals(Long.class, number.getClass());
        ConfigureFromObjectTestCase.assertEquals((Object)longValue, (Object)number);
        ConfigureFromObjectTestCase.assertEquals((String)stringValue, (String)bean.getOverloadedProperty());
        SimpleBean.Alphabet anenum = bean.getEnumProperty();
        ConfigureFromObjectTestCase.assertEquals((Object)((Object)enumValue), (Object)((Object)anenum));
    }
}

