/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.config.test;

import java.util.ArrayList;
import java.util.Map;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractListMetaData;
import org.jboss.beans.metadata.plugins.AbstractMapMetaData;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueFactoryMetaData;
import org.jboss.beans.metadata.plugins.StringValueMetaData;
import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.test.kernel.config.support.LDAPFactory;
import org.jboss.test.kernel.config.support.PropHolder;
import org.jboss.test.kernel.config.support.Transformer;
import org.jboss.test.kernel.config.support.TrimTransformer;
import org.jboss.test.kernel.config.test.AbstractKernelConfigTest;

public class ValueFactoryTestCase
extends AbstractKernelConfigTest {
    public ValueFactoryTestCase(String name) {
        super(name);
    }

    public ValueFactoryTestCase(String name, boolean xmltest) {
        super(name, xmltest);
    }

    public static Test suite() {
        return ValueFactoryTestCase.suite(ValueFactoryTestCase.class);
    }

    public void testValueFactory() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelController controller = kernel.getController();
        PropHolder propHolder = this.instantiateHolder(controller);
        ValueFactoryTestCase.assertNotNull((Object)propHolder);
        ValueFactoryTestCase.assertEquals((String)"QWERT", (String)propHolder.getConstructor());
        ValueFactoryTestCase.assertEquals((String)"QWERT", (String)propHolder.getValue());
        ValueFactoryTestCase.assertNotNull(propHolder.getList());
        for (String prop : propHolder.getList()) {
            ValueFactoryTestCase.assertEquals((String)"QWERT", (String)prop);
        }
    }

    protected PropHolder instantiateHolder(KernelController controller) throws Throwable {
        BeanMetaDataBuilder ldap = BeanMetaDataBuilderFactory.createBuilder((String)"ldap", (String)LDAPFactory.class.getName());
        AbstractMapMetaData map = new AbstractMapMetaData();
        map.setKeyType(String.class.getName());
        map.setValueType(String.class.getName());
        map.put((MetaDataVisitorNode)new StringValueMetaData("foo.bar.key"), (MetaDataVisitorNode)new StringValueMetaData("QWERT"));
        map.put((MetaDataVisitorNode)new StringValueMetaData("xyz.key"), (MetaDataVisitorNode)new StringValueMetaData(" QWERT "));
        ldap.addConstructorParameter(Map.class.getName(), (ValueMetaData)map);
        LDAPFactory lf = (LDAPFactory)this.instantiate(controller, ldap.getBeanMetaData());
        ValueFactoryTestCase.assertNotNull((Object)lf);
        AbstractValueFactoryMetaData vfmd1 = new AbstractValueFactoryMetaData((Object)"ldap", "getValue");
        ArrayList<AbstractParameterMetaData> parameters1 = new ArrayList<AbstractParameterMetaData>();
        vfmd1.setParameters(parameters1);
        parameters1.add(new AbstractParameterMetaData(String.class.getName(), "foo.bar.key"));
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)"PropHolder", (String)PropHolder.class.getName());
        builder.addConstructorParameter(String.class.getName(), (ValueMetaData)vfmd1);
        builder.addPropertyMetaData("value", (ValueMetaData)vfmd1);
        AbstractListMetaData listMD = new AbstractListMetaData();
        listMD.add((MetaDataVisitorNode)vfmd1);
        AbstractValueFactoryMetaData vfmd2 = new AbstractValueFactoryMetaData((Object)"ldap", "getValue");
        ArrayList<AbstractParameterMetaData> parameters2 = new ArrayList<AbstractParameterMetaData>();
        vfmd2.setParameters(parameters2);
        parameters2.add(new AbstractParameterMetaData(String.class.getName(), "foo.bar.key"));
        parameters2.add(new AbstractParameterMetaData(String.class.getName(), "qaz"));
        listMD.add((MetaDataVisitorNode)vfmd2);
        AbstractValueFactoryMetaData vfmd3 = new AbstractValueFactoryMetaData((Object)"ldap", "getValue");
        ArrayList<AbstractParameterMetaData> parameters3 = new ArrayList<AbstractParameterMetaData>();
        vfmd3.setParameters(parameters3);
        parameters3.add(new AbstractParameterMetaData(String.class.getName(), "xyz.key"));
        parameters3.add(new AbstractParameterMetaData(String.class.getName(), "xyz"));
        BeanMetaDataBuilder tranformer = BeanMetaDataBuilderFactory.createBuilder((String)"t", (String)TrimTransformer.class.getName());
        ValueFactoryTestCase.assertNotNull((Object)this.instantiate(controller, tranformer.getBeanMetaData()));
        parameters3.add(new AbstractParameterMetaData(Transformer.class.getName(), (ValueMetaData)tranformer.getBeanMetaData()));
        listMD.add((MetaDataVisitorNode)vfmd3);
        AbstractValueFactoryMetaData vfmd4 = new AbstractValueFactoryMetaData((Object)"ldap", "getValue", "QWERT");
        ArrayList<AbstractParameterMetaData> parameters4 = new ArrayList<AbstractParameterMetaData>();
        vfmd4.setParameters(parameters4);
        parameters4.add(new AbstractParameterMetaData(String.class.getName(), "no.such.key"));
        listMD.add((MetaDataVisitorNode)vfmd4);
        builder.addPropertyMetaData("list", (ValueMetaData)listMD);
        return (PropHolder)this.instantiate(controller, builder.getBeanMetaData());
    }
}

