/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.dependency.test;

import java.util.ArrayList;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.plugins.factory.GenericBeanFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.factory.GenericBeanFactoryMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.dependency.support.SimpleBean;
import org.jboss.test.kernel.dependency.support.SimpleBeanImpl;
import org.jboss.test.kernel.dependency.support.SimpleBeanWithConstructorDependency;
import org.jboss.test.kernel.dependency.support.SimpleBeanWithConstructorDependencyImpl;
import org.jboss.test.kernel.dependency.test.OldAbstractKernelDependencyTest;

public class GenericBeanFactoryConstructorDependencyTestCase
extends OldAbstractKernelDependencyTest {
    public static Test suite() {
        return GenericBeanFactoryConstructorDependencyTestCase.suite(GenericBeanFactoryConstructorDependencyTestCase.class);
    }

    public GenericBeanFactoryConstructorDependencyTestCase(String name) throws Throwable {
        super(name);
    }

    public GenericBeanFactoryConstructorDependencyTestCase(String name, boolean xmltest) throws Throwable {
        super(name, xmltest);
    }

    public void testGenericBeanFactoryConstructorDependencyCorrectOrder() throws Throwable {
        this.constructorDependencyCorrectOrder();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        ControllerContext context2 = this.assertInstall(1, "Name2");
        GenericBeanFactory factory1 = (GenericBeanFactory)context1.getTarget();
        SimpleBean bean1 = (SimpleBean)factory1.createBean();
        GenericBeanFactoryConstructorDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryConstructorDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        GenericBeanFactory factory2 = (GenericBeanFactory)context2.getTarget();
        SimpleBeanWithConstructorDependency bean2 = (SimpleBeanWithConstructorDependency)factory2.createBean();
        GenericBeanFactoryConstructorDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryConstructorDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        GenericBeanFactoryConstructorDependencyTestCase.assertEquals((Object)factory1, (Object)bean2.getFactory());
    }

    public void constructorDependencyCorrectOrder() throws Throwable {
        this.buildMetaData();
    }

    public void testGenericBeanFactoryConstructorDependencyWrongOrder() throws Throwable {
        this.constructorDependencyWrongOrder();
        ControllerContext context2 = this.assertInstall(1, "Name2", ControllerState.INSTANTIATED);
        ControllerContext context1 = this.assertInstall(0, "Name1");
        GenericBeanFactoryConstructorDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context2.getState());
        GenericBeanFactory factory1 = (GenericBeanFactory)context1.getTarget();
        SimpleBean bean1 = (SimpleBean)factory1.createBean();
        GenericBeanFactoryConstructorDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryConstructorDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        GenericBeanFactory factory2 = (GenericBeanFactory)context2.getTarget();
        SimpleBeanWithConstructorDependency bean2 = (SimpleBeanWithConstructorDependency)factory2.createBean();
        GenericBeanFactoryConstructorDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryConstructorDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        GenericBeanFactoryConstructorDependencyTestCase.assertEquals((Object)factory1, (Object)bean2.getFactory());
    }

    public void constructorDependencyWrongOrder() throws Throwable {
        this.buildMetaData();
    }

    public void testGenericBeanFactoryConstructorDependencyReinstall() throws Throwable {
        this.constructorDependencyReinstall();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        ControllerContext context2 = this.assertInstall(1, "Name2");
        GenericBeanFactory factory1 = (GenericBeanFactory)context1.getTarget();
        SimpleBean bean1 = (SimpleBean)factory1.createBean();
        GenericBeanFactoryConstructorDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryConstructorDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        GenericBeanFactory factory2 = (GenericBeanFactory)context2.getTarget();
        SimpleBeanWithConstructorDependency bean2 = (SimpleBeanWithConstructorDependency)factory2.createBean();
        GenericBeanFactoryConstructorDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryConstructorDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        GenericBeanFactoryConstructorDependencyTestCase.assertEquals((Object)factory1, (Object)bean2.getFactory());
        this.assertUninstall("Name1");
        GenericBeanFactoryConstructorDependencyTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context1.getState());
        GenericBeanFactoryConstructorDependencyTestCase.assertEquals((Object)ControllerState.INSTANTIATED, (Object)context2.getState());
        this.assertNotInstalled("Name2");
        context2 = this.assertContext("Name2", ControllerState.INSTANTIATED);
        context1 = this.assertInstall(0, "Name1");
        GenericBeanFactoryConstructorDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context2.getState());
        factory1 = (GenericBeanFactory)context1.getTarget();
        bean1 = (SimpleBean)factory1.createBean();
        GenericBeanFactoryConstructorDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryConstructorDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        factory2 = (GenericBeanFactory)context2.getTarget();
        bean2 = (SimpleBeanWithConstructorDependency)factory2.createBean();
        GenericBeanFactoryConstructorDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryConstructorDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        GenericBeanFactoryConstructorDependencyTestCase.assertEquals((Object)factory1, (Object)bean2.getFactory());
        this.assertUninstall("Name2");
        GenericBeanFactoryConstructorDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context1.getState());
        GenericBeanFactoryConstructorDependencyTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context2.getState());
        factory1 = (GenericBeanFactory)context1.getTarget();
        bean1 = (SimpleBean)factory1.createBean();
        GenericBeanFactoryConstructorDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryConstructorDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        context2 = this.assertInstall(1, "Name2");
        factory1 = (GenericBeanFactory)context1.getTarget();
        bean1 = (SimpleBean)factory1.createBean();
        GenericBeanFactoryConstructorDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        factory2 = (GenericBeanFactory)context2.getTarget();
        bean2 = (SimpleBeanWithConstructorDependency)factory2.createBean();
        GenericBeanFactoryConstructorDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryConstructorDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        GenericBeanFactoryConstructorDependencyTestCase.assertEquals((Object)factory1, (Object)bean2.getFactory());
    }

    public void constructorDependencyReinstall() throws Throwable {
        this.buildMetaData();
    }

    protected void buildMetaData() {
        GenericBeanFactoryMetaData metaData1 = new GenericBeanFactoryMetaData("Name1", SimpleBeanImpl.class.getName());
        this.addBeanProperty(metaData1, (PropertyMetaData)new AbstractPropertyMetaData("string", "String1"));
        GenericBeanFactoryMetaData metaData2 = new GenericBeanFactoryMetaData("Name2", SimpleBeanWithConstructorDependencyImpl.class.getName());
        this.addBeanProperty(metaData2, (PropertyMetaData)new AbstractPropertyMetaData("string", "String2"));
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        ArrayList<AbstractParameterMetaData> constructor2 = new ArrayList<AbstractParameterMetaData>();
        constructor2.add(new AbstractParameterMetaData(GenericBeanFactory.class.getName(), (ValueMetaData)new AbstractDependencyValueMetaData((Object)"Name1")));
        cmd.setParameters(constructor2);
        metaData2.setConstructor((ConstructorMetaData)cmd);
        this.setBeanMetaDatas(new BeanMetaData[]{this.getBeanMetaData(metaData1), this.getBeanMetaData(metaData2)});
    }
}

