/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.dependency.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import org.jboss.beans.metadata.api.model.FromContext;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractInstallMetaData;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.plugins.ThisValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.InstallMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.dependency.support.SimpleBean;
import org.jboss.test.kernel.dependency.support.SimpleBeanImpl;
import org.jboss.test.kernel.dependency.support.SimpleBeanRepository;
import org.jboss.test.kernel.dependency.test.AbstractKernelDependencyTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallDependencyTestCase
extends AbstractKernelDependencyTest {
    public static Test suite() {
        return InstallDependencyTestCase.suite(InstallDependencyTestCase.class);
    }

    public InstallDependencyTestCase(String name) throws Throwable {
        super(name);
    }

    public InstallDependencyTestCase(String name, boolean xmltest) throws Throwable {
        super(name, xmltest);
    }

    public void testInstallDependencyCorrectOrder() throws Throwable {
        this.setupBeanMetaDatas();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        ControllerContext context2 = this.assertInstall(1, "Name2");
        SimpleBeanRepository bean1 = (SimpleBeanRepository)context1.getTarget();
        InstallDependencyTestCase.assertNotNull((Object)bean1);
        SimpleBean bean2 = (SimpleBean)context2.getTarget();
        InstallDependencyTestCase.assertNotNull((Object)bean2);
        ArrayList<SimpleBean> expected = new ArrayList<SimpleBean>();
        expected.add(bean2);
        InstallDependencyTestCase.assertEquals(expected, bean1.getBeans());
    }

    public void testInstallDependencyWrongOrder() throws Throwable {
        this.setupBeanMetaDatas();
        ControllerContext context2 = this.assertInstall(1, "Name2", ControllerState.START);
        ControllerContext context1 = this.assertInstall(0, "Name1");
        SimpleBeanRepository bean1 = (SimpleBeanRepository)context1.getTarget();
        InstallDependencyTestCase.assertNotNull((Object)bean1);
        SimpleBean bean2 = (SimpleBean)context2.getTarget();
        InstallDependencyTestCase.assertNotNull((Object)bean2);
        ArrayList<SimpleBean> expected = new ArrayList<SimpleBean>();
        expected.add(bean2);
        InstallDependencyTestCase.assertEquals(expected, bean1.getBeans());
    }

    public void testInstallDependencyReinstall() throws Throwable {
        this.setupBeanMetaDatas();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        ControllerContext context2 = this.assertInstall(1, "Name2");
        SimpleBeanRepository bean1 = (SimpleBeanRepository)context1.getTarget();
        InstallDependencyTestCase.assertNotNull((Object)bean1);
        SimpleBean bean2 = (SimpleBean)context2.getTarget();
        InstallDependencyTestCase.assertNotNull((Object)bean2);
        ArrayList<SimpleBean> expected = new ArrayList<SimpleBean>();
        expected.add(bean2);
        InstallDependencyTestCase.assertEquals(expected, bean1.getBeans());
        this.assertUninstall("Name1");
        this.assertContext("Name2", ControllerState.START);
        expected = new ArrayList();
        InstallDependencyTestCase.assertEquals(expected, bean1.getBeans());
        context1 = this.assertInstall(0, "Name1");
        this.assertContext("Name2", ControllerState.INSTALLED);
        bean1 = (SimpleBeanRepository)context1.getTarget();
        InstallDependencyTestCase.assertNotNull((Object)bean1);
        expected = new ArrayList();
        expected.add(bean2);
        InstallDependencyTestCase.assertEquals(expected, bean1.getBeans());
        this.assertUninstall("Name2");
        this.assertContext("Name1", ControllerState.INSTALLED);
        expected = new ArrayList();
        InstallDependencyTestCase.assertEquals(expected, bean1.getBeans());
        context2 = this.assertInstall(1, "Name2");
        this.assertContext("Name1", ControllerState.INSTALLED);
        bean2 = (SimpleBean)context2.getTarget();
        InstallDependencyTestCase.assertNotNull((Object)bean2);
        expected = new ArrayList();
        expected.add(bean2);
        InstallDependencyTestCase.assertEquals(expected, bean1.getBeans());
    }

    public void testWhenRequiredInstalls() throws Throwable {
        this.setupBeanMetaDatas();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        ControllerContext context2 = this.assertInstall(2, "Name3");
        SimpleBeanRepository bean1 = (SimpleBeanRepository)context1.getTarget();
        InstallDependencyTestCase.assertNotNull((Object)bean1);
        Set<ControllerState> states = bean1.getStates();
        InstallDependencyTestCase.assertNotNull(states);
        InstallDependencyTestCase.assertEquals((int)this.getExpectedInstallSize(), (int)states.size());
        this.assertUninstall(context2.getName().toString());
        int uninstallSize = this.getExpectedUninstallSize();
        InstallDependencyTestCase.assertEquals((int)uninstallSize, (int)states.size());
        if (uninstallSize > 0) {
            ControllerState state = states.iterator().next();
            InstallDependencyTestCase.assertEquals((Object)ControllerState.NOT_INSTALLED, (Object)state);
        }
    }

    protected int getExpectedInstallSize() {
        return 6;
    }

    protected int getExpectedUninstallSize() {
        return 1;
    }

    protected void setupBeanMetaDatas() throws Throwable {
        AbstractBeanMetaData metaData1 = new AbstractBeanMetaData("Name1", SimpleBeanRepository.class.getName());
        AbstractBeanMetaData metaData2 = new AbstractBeanMetaData("Name2", SimpleBeanImpl.class.getName());
        ArrayList<AbstractInstallMetaData> installs = new ArrayList<AbstractInstallMetaData>();
        AbstractInstallMetaData install = new AbstractInstallMetaData();
        install.setBean("Name1");
        install.setMethodName("addSimpleBean");
        ArrayList<AbstractParameterMetaData> parameters = new ArrayList<AbstractParameterMetaData>();
        parameters.add(new AbstractParameterMetaData(null, (ValueMetaData)new ThisValueMetaData()));
        install.setParameters(parameters);
        installs.add(install);
        metaData2.setInstalls(installs);
        ArrayList<AbstractInstallMetaData> uninstalls = new ArrayList<AbstractInstallMetaData>();
        AbstractInstallMetaData uninstall = new AbstractInstallMetaData();
        uninstall.setBean("Name1");
        uninstall.setMethodName("removeSimpleBean");
        parameters = new ArrayList();
        parameters.add(new AbstractParameterMetaData(null, (ValueMetaData)new ThisValueMetaData()));
        uninstall.setParameters(parameters);
        uninstalls.add(uninstall);
        metaData2.setUninstalls(uninstalls);
        AbstractBeanMetaData metaData3 = new AbstractBeanMetaData("Name3", SimpleBeanImpl.class.getName());
        ArrayList<InstallMetaData> stateInstalls = new ArrayList<InstallMetaData>();
        this.addInstallMetaData(ControllerState.PRE_INSTALL, stateInstalls);
        this.addInstallMetaData(ControllerState.DESCRIBED, stateInstalls);
        this.addInstallMetaData(ControllerState.INSTANTIATED, stateInstalls);
        this.addInstallMetaData(ControllerState.CONFIGURED, stateInstalls);
        this.addInstallMetaData(ControllerState.CREATE, stateInstalls);
        this.addInstallMetaData(ControllerState.START, stateInstalls);
        ArrayList<InstallMetaData> stateUninstalls = new ArrayList<InstallMetaData>();
        this.addUninstallMetaData(ControllerState.PRE_INSTALL, stateUninstalls);
        this.addUninstallMetaData(ControllerState.DESCRIBED, stateUninstalls);
        this.addUninstallMetaData(ControllerState.INSTANTIATED, stateUninstalls);
        this.addUninstallMetaData(ControllerState.CONFIGURED, stateUninstalls);
        this.addUninstallMetaData(ControllerState.CREATE, stateUninstalls);
        this.addUninstallMetaData(ControllerState.START, stateUninstalls);
        metaData3.setInstalls(stateInstalls);
        metaData3.setUninstalls(stateUninstalls);
        this.setBeanMetaDatas(new BeanMetaData[]{metaData1, metaData2, metaData3});
    }

    protected void addInstallMetaData(ControllerState state, List<InstallMetaData> states) {
        this.addInstallMetaData(state, states, "add");
    }

    protected void addUninstallMetaData(ControllerState state, List<InstallMetaData> states) {
        this.addInstallMetaData(state, states, "remove");
    }

    protected void addInstallMetaData(ControllerState state, List<InstallMetaData> states, String prefix) {
        AbstractInstallMetaData install = new AbstractInstallMetaData();
        install.setBean("Name1");
        install.setMethodName(prefix + "State");
        AbstractInjectionValueMetaData injection = new AbstractInjectionValueMetaData();
        injection.setFromContext(FromContext.STATE);
        AbstractParameterMetaData parameter = new AbstractParameterMetaData((ValueMetaData)injection);
        install.setParameters(Collections.singletonList(parameter));
        install.setState(state);
        states.add((InstallMetaData)install);
    }
}

