/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.dependency.test;

import java.util.HashSet;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.dependency.support.SimpleBean;
import org.jboss.test.kernel.dependency.support.SimpleBeanImpl;
import org.jboss.test.kernel.dependency.support.SimpleBeanWithDependency;
import org.jboss.test.kernel.dependency.support.SimpleBeanWithDependencyImpl;
import org.jboss.test.kernel.dependency.test.OldAbstractKernelDependencyTest;

public class PlainDependencyTestCase
extends OldAbstractKernelDependencyTest {
    public static Test suite() {
        return PlainDependencyTestCase.suite(PlainDependencyTestCase.class);
    }

    public PlainDependencyTestCase(String name) throws Throwable {
        super(name);
    }

    public PlainDependencyTestCase(String name, boolean xmltest) throws Throwable {
        super(name, xmltest);
    }

    public void testPlainDependencyCorrectOrder() throws Throwable {
        this.plainDependencyCorrectOrder();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        ControllerContext context2 = this.assertInstall(1, "Name2");
        SimpleBean bean1 = (SimpleBean)context1.getTarget();
        PlainDependencyTestCase.assertNotNull((Object)bean1);
        PlainDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        SimpleBeanWithDependency bean2 = (SimpleBeanWithDependency)context2.getTarget();
        PlainDependencyTestCase.assertNotNull((Object)bean2);
        PlainDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        PlainDependencyTestCase.assertEquals((Object)bean1, (Object)bean2.getSimpleBean());
    }

    public void plainDependencyCorrectOrder() throws Throwable {
        this.buildMetaData();
    }

    public void testPlainDependencyWrongOrder() throws Throwable {
        this.plainDependencyWrongOrder();
        ControllerContext context2 = this.assertInstall(1, "Name2", ControllerState.INSTANTIATED);
        ControllerContext context1 = this.assertInstall(0, "Name1");
        PlainDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context2.getState());
        SimpleBean bean1 = (SimpleBean)context1.getTarget();
        PlainDependencyTestCase.assertNotNull((Object)bean1);
        PlainDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        SimpleBeanWithDependency bean2 = (SimpleBeanWithDependency)context2.getTarget();
        PlainDependencyTestCase.assertNotNull((Object)bean2);
        PlainDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        PlainDependencyTestCase.assertEquals((Object)bean1, (Object)bean2.getSimpleBean());
    }

    public void plainDependencyWrongOrder() throws Throwable {
        this.buildMetaData();
    }

    public void testPlainDependencyReinstall() throws Throwable {
        this.plainDependencyReinstall();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        ControllerContext context2 = this.assertInstall(1, "Name2");
        SimpleBean bean1 = (SimpleBean)context1.getTarget();
        PlainDependencyTestCase.assertNotNull((Object)bean1);
        PlainDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        SimpleBeanWithDependency bean2 = (SimpleBeanWithDependency)context2.getTarget();
        PlainDependencyTestCase.assertNotNull((Object)bean2);
        PlainDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        PlainDependencyTestCase.assertEquals((Object)bean1, (Object)bean2.getSimpleBean());
        this.assertUninstall("Name1");
        PlainDependencyTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context1.getState());
        PlainDependencyTestCase.assertEquals((Object)ControllerState.INSTANTIATED, (Object)context2.getState());
        this.assertNotInstalled("Name2");
        context2 = this.assertContext("Name2", ControllerState.INSTANTIATED);
        context1 = this.assertInstall(0, "Name1");
        PlainDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context2.getState());
        bean1 = (SimpleBean)context1.getTarget();
        PlainDependencyTestCase.assertNotNull((Object)bean1);
        PlainDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        bean2 = (SimpleBeanWithDependency)context2.getTarget();
        PlainDependencyTestCase.assertNotNull((Object)bean2);
        PlainDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        PlainDependencyTestCase.assertEquals((Object)bean1, (Object)bean2.getSimpleBean());
        this.assertUninstall("Name2");
        context1 = this.assertContext("Name1");
        bean1 = (SimpleBean)context1.getTarget();
        PlainDependencyTestCase.assertNotNull((Object)bean1);
        PlainDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        context2 = this.assertInstall(1, "Name2");
        bean1 = (SimpleBean)context1.getTarget();
        PlainDependencyTestCase.assertNotNull((Object)bean1);
        PlainDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        bean2 = (SimpleBeanWithDependency)context2.getTarget();
        PlainDependencyTestCase.assertNotNull((Object)bean2);
        PlainDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        PlainDependencyTestCase.assertEquals((Object)bean1, (Object)bean2.getSimpleBean());
    }

    public void plainDependencyReinstall() throws Throwable {
        this.buildMetaData();
    }

    protected void buildMetaData() {
        AbstractBeanMetaData metaData1 = new AbstractBeanMetaData("Name1", SimpleBeanImpl.class.getName());
        HashSet<AbstractPropertyMetaData> attributes1 = new HashSet<AbstractPropertyMetaData>();
        attributes1.add(new AbstractPropertyMetaData("string", "String1"));
        metaData1.setProperties(attributes1);
        AbstractBeanMetaData metaData2 = new AbstractBeanMetaData("Name2", SimpleBeanWithDependencyImpl.class.getName());
        HashSet<AbstractPropertyMetaData> attributes2 = new HashSet<AbstractPropertyMetaData>();
        attributes2.add(new AbstractPropertyMetaData("string", "String2"));
        attributes2.add(new AbstractPropertyMetaData("simpleBean", (ValueMetaData)new AbstractDependencyValueMetaData((Object)"Name1")));
        metaData2.setProperties(attributes2);
        this.setBeanMetaDatas(new BeanMetaData[]{metaData1, metaData2});
    }
}

