/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueFactoryMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.factory.GenericBeanFactoryMetaData;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployment;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.test.kernel.deployment.support.container.BaseContext;
import org.jboss.test.kernel.deployment.support.container.Bean1Type;
import org.jboss.test.kernel.deployment.support.container.BeanContainer;
import org.jboss.test.kernel.deployment.support.container.BeanContextFactory;
import org.jboss.test.kernel.deployment.support.container.InstanceInterceptor;
import org.jboss.test.kernel.deployment.support.container.plugin.GenericComponentFactory;
import org.jboss.test.kernel.deployment.support.container.spi.ComponentFactory;
import org.jboss.test.kernel.deployment.support.container.spi.ComponentInstance;
import org.jboss.test.kernel.deployment.support.container.spi.ComponentVisitor;
import org.jboss.test.kernel.deployment.test.BeanContainerUsageTestCase;

public class BeanContainerUsageMDTestCase
extends BeanContainerUsageTestCase {
    public static Test suite() {
        return BeanContainerUsageMDTestCase.suite(BeanContainerUsageMDTestCase.class);
    }

    public BeanContainerUsageMDTestCase(String name) {
        super(name);
    }

    public void testComponentBeanFactory() throws Throwable {
        this.bootstrap();
        ComponentFactory factory = (ComponentFactory)this.getBean("ComponentBeanFactory");
        this.getLog().info((Object)("ComponentBeanFactory bean: " + factory));
        ComponentInstance contextInstance = factory.createComponents("ComponentBeanFactory");
        List<String> beanNames = contextInstance.getComponentNames();
        this.getLog().info((Object)("createComponents(ComponentBeanFactory): " + beanNames));
        HashSet<String> expectedBeanNames = new HashSet<String>();
        expectedBeanNames.add("ComponentBeanFactory@ContextFactory#1");
        expectedBeanNames.add("ComponentBeanFactory@BeanInstance#1");
        expectedBeanNames.add("ComponentBeanFactory@Interceptor:0#1");
        BeanContainerUsageMDTestCase.assertEquals(expectedBeanNames, new HashSet<String>(beanNames));
        long compID = contextInstance.getComponentID();
        BeanContainerUsageMDTestCase.assertEquals((long)1L, (long)compID);
        BaseContext context = (BaseContext)contextInstance.getContext();
        BeanContainerUsageMDTestCase.assertNotNull((Object)context);
        String contextName = contextInstance.getContextName();
        BeanContainerUsageMDTestCase.assertEquals((String)"ComponentBeanFactory@ContextFactory#1", (String)contextName);
        Object contextBean = this.getBean("ComponentBeanFactory@ContextFactory#1");
        BeanContainerUsageMDTestCase.assertTrue((contextBean == context ? 1 : 0) != 0);
        Bean1Type bean1 = (Bean1Type)this.getBean("ComponentBeanFactory@BeanInstance#1");
        BeanContainerUsageMDTestCase.assertTrue((bean1 == context.getInstance() ? 1 : 0) != 0);
        Object interceptor = this.getBean("ComponentBeanFactory@Interceptor:0#1");
        BeanContainerUsageMDTestCase.assertNotNull((Object)interceptor);
        ArrayList<Object> expectedInterceptors = new ArrayList<Object>();
        expectedInterceptors.add(interceptor);
        List<Object> interceptors = context.getInterceptors();
        BeanContainerUsageMDTestCase.assertEquals(interceptors, expectedInterceptors);
        factory.destroyComponents(contextInstance);
        expectedBeanNames.clear();
        expectedBeanNames.add("ComponentBeanFactory");
        this.assertBeansExist(expectedBeanNames);
        contextInstance = null;
        ComponentInstance contextInstance2 = factory.createComponents("ComponentBeanFactory");
        List<String> beanNames2 = contextInstance2.getComponentNames();
        this.getLog().info((Object)("createComponents(ComponentBeanFactory): " + beanNames2));
        expectedBeanNames = new HashSet();
        expectedBeanNames.add("ComponentBeanFactory@ContextFactory#2");
        expectedBeanNames.add("ComponentBeanFactory@BeanInstance#2");
        expectedBeanNames.add("ComponentBeanFactory@Interceptor:0#2");
        BeanContainerUsageMDTestCase.assertEquals(expectedBeanNames, new HashSet<String>(beanNames2));
        compID = contextInstance2.getComponentID();
        BeanContainerUsageMDTestCase.assertEquals((long)2L, (long)compID);
        BaseContext context2 = (BaseContext)contextInstance2.getContext();
        BeanContainerUsageMDTestCase.assertNotNull((Object)context2);
        String contextName2 = contextInstance2.getContextName();
        BeanContainerUsageMDTestCase.assertEquals((String)"ComponentBeanFactory@ContextFactory#2", (String)contextName2);
        Object contextBean2 = this.getBean("ComponentBeanFactory@ContextFactory#2");
        BeanContainerUsageMDTestCase.assertTrue((contextBean2 == context2 ? 1 : 0) != 0);
        Bean1Type bean2 = (Bean1Type)this.getBean("ComponentBeanFactory@BeanInstance#2");
        BeanContainerUsageMDTestCase.assertTrue((bean2 == context2.getInstance() ? 1 : 0) != 0);
        BeanContainerUsageMDTestCase.assertTrue((bean2 != bean1 ? 1 : 0) != 0);
        Object interceptor2 = this.getBean("ComponentBeanFactory@Interceptor:0#2");
        BeanContainerUsageMDTestCase.assertNotNull((Object)interceptor2);
        ArrayList<Object> expectedInterceptors2 = new ArrayList<Object>();
        expectedInterceptors2.add(interceptor2);
        List<Object> interceptors2 = context2.getInterceptors();
        BeanContainerUsageMDTestCase.assertEquals(interceptors2, expectedInterceptors2);
        factory.destroyComponents(contextInstance2);
        expectedBeanNames.clear();
        expectedBeanNames.add("ComponentBeanFactory");
        this.assertBeansExist(expectedBeanNames);
        this.shutdown();
    }

    protected KernelDeployment getDeploymentForDependencyInjectionOfBean() {
        AbstractKernelDeployment deployment = new AbstractKernelDeployment();
        deployment.setName("DependencyInjectionOfBean");
        ArrayList<Object> beanFactories = new ArrayList<Object>();
        GenericBeanFactoryMetaData Bean1TypeFactory = new GenericBeanFactoryMetaData("Bean1TypeFactory", "org.jboss.test.kernel.deployment.support.container.Bean1Type");
        beanFactories.add(Bean1TypeFactory);
        AbstractBeanMetaData Bean1TypePool = new AbstractBeanMetaData("Bean1TypePool", "org.jboss.test.kernel.deployment.support.container.BeanPool");
        HashSet<AbstractPropertyMetaData> Bean1TypePool_propertys = new HashSet<AbstractPropertyMetaData>();
        Bean1TypePool_propertys.add(new AbstractPropertyMetaData("factory", (ValueMetaData)new AbstractDependencyValueMetaData((Object)"Bean1TypeFactory")));
        Bean1TypePool.setProperties(Bean1TypePool_propertys);
        beanFactories.add(Bean1TypePool);
        AbstractBeanMetaData BeanContainer1Type = new AbstractBeanMetaData("BeanContainer1Type", "org.jboss.test.kernel.deployment.support.container.BeanContainer");
        HashSet<AbstractPropertyMetaData> BeanContainer1Type_propertys = new HashSet<AbstractPropertyMetaData>();
        BeanContainer1Type_propertys.add(new AbstractPropertyMetaData("pool", (ValueMetaData)new AbstractDependencyValueMetaData((Object)"Bean1TypePool")));
        BeanContainer1Type.setProperties(BeanContainer1Type_propertys);
        beanFactories.add(BeanContainer1Type);
        GenericBeanFactoryMetaData Bean2TypeFactory = new GenericBeanFactoryMetaData("Bean2TypeFactory", "org.jboss.test.kernel.deployment.support.container.Bean2Type");
        HashSet<AbstractPropertyMetaData> Bean2TypeFactory_propertys = new HashSet<AbstractPropertyMetaData>();
        AbstractValueFactoryMetaData bean1CreateMethod = new AbstractValueFactoryMetaData((Object)"Bean1TypePool", "createBean");
        Bean2TypeFactory_propertys.add(new AbstractPropertyMetaData("bean1", (ValueMetaData)bean1CreateMethod));
        Bean2TypeFactory.setProperties(Bean2TypeFactory_propertys);
        beanFactories.add(Bean2TypeFactory);
        AbstractBeanMetaData Bean2TypePool = new AbstractBeanMetaData("Bean2TypePool", "org.jboss.test.kernel.deployment.support.container.BeanPool");
        HashSet<AbstractPropertyMetaData> Bean2TypePool_propertys = new HashSet<AbstractPropertyMetaData>();
        Bean2TypePool_propertys.add(new AbstractPropertyMetaData("factory", (ValueMetaData)new AbstractDependencyValueMetaData((Object)"Bean2TypeFactory")));
        Bean2TypePool.setProperties(Bean2TypePool_propertys);
        beanFactories.add(Bean2TypePool);
        AbstractBeanMetaData BeanContainer2Type = new AbstractBeanMetaData("BeanContainer2Type", "org.jboss.test.kernel.deployment.support.container.BeanContainer");
        HashSet<AbstractPropertyMetaData> BeanContainer2Type_propertys = new HashSet<AbstractPropertyMetaData>();
        BeanContainer2Type_propertys.add(new AbstractPropertyMetaData("pool", (ValueMetaData)new AbstractDependencyValueMetaData((Object)"Bean2TypePool")));
        BeanContainer2Type.setProperties(BeanContainer2Type_propertys);
        beanFactories.add(BeanContainer2Type);
        deployment.setBeanFactories(beanFactories);
        return deployment;
    }

    protected KernelDeployment getDeploymentForDependencyInjectionOfBeanWithMismatchedPoolSizes() {
        KernelDeployment deployment = this.getDeploymentForDependencyInjectionOfBean();
        List beanFactories = deployment.getBeanFactories();
        for (BeanMetaDataFactory bmdf : beanFactories) {
            ArrayList<AbstractParameterMetaData> params;
            AbstractConstructorMetaData ctor;
            if (!(bmdf instanceof AbstractBeanMetaData)) continue;
            AbstractBeanMetaData abmd = (AbstractBeanMetaData)bmdf;
            if (abmd.getName().equals("Bean1TypePool")) {
                ctor = new AbstractConstructorMetaData();
                params = new ArrayList<AbstractParameterMetaData>();
                params.add(new AbstractParameterMetaData(Integer.TYPE.getName(), "3"));
                ctor.setParameters(params);
                abmd.setConstructor((ConstructorMetaData)ctor);
                continue;
            }
            if (!abmd.getName().equals("Bean2TypePool")) continue;
            ctor = new AbstractConstructorMetaData();
            params = new ArrayList();
            params.add(new AbstractParameterMetaData(Integer.TYPE.getName(), "4"));
            ctor.setParameters(params);
            abmd.setConstructor((ConstructorMetaData)ctor);
        }
        return deployment;
    }

    protected KernelDeployment getDeploymentForComponentBeanFactory() {
        AbstractKernelDeployment deployment = new AbstractKernelDeployment();
        deployment.setName("ComponentBeanFactory");
        ArrayList<BeanMetaDataFactory> beanFactories = new ArrayList<BeanMetaDataFactory>();
        BeanContainer container = new BeanContainer();
        BeanContextFactory contextFactory = new BeanContextFactory();
        contextFactory.setBeanClass(Bean1Type.class.getName());
        contextFactory.setContainer(container);
        String[] interceptorNames = new String[]{InstanceInterceptor.class.getName()};
        contextFactory.setInterceptorNames(Arrays.asList(interceptorNames));
        ComponentVisitor visitor = null;
        GenericComponentFactory componentFactory = new GenericComponentFactory(contextFactory, visitor);
        BeanMetaDataFactory componentFactoryMD = this.installBeanInstance("ComponentBeanFactory", componentFactory);
        beanFactories.add(componentFactoryMD);
        deployment.setBeanFactories(beanFactories);
        return deployment;
    }

    protected BeanMetaDataFactory installBeanInstance(String name, Object bean) {
        AbstractBeanMetaData beanMD = new AbstractBeanMetaData(name, bean.getClass().getName());
        beanMD.setConstructor((ConstructorMetaData)new AlreadyInstantiated(bean));
        return beanMD;
    }

    public static class AlreadyInstantiated
    extends AbstractConstructorMetaData {
        private static final long serialVersionUID = 1L;
        private Object bean;

        public AlreadyInstantiated(Object bean) {
            this.bean = bean;
            this.setFactory((ValueMetaData)new AbstractValueMetaData((Object)new Factory()));
            this.setFactoryClass(Factory.class.getName());
            this.setFactoryMethod("create");
        }

        public class Factory {
            public Object create() {
                return AlreadyInstantiated.this.bean;
            }
        }
    }
}

