/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.lang.annotation.Annotation;
import java.util.Set;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractAnnotationMetaData;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.test.kernel.deployment.xml.support.Annotation1;
import org.jboss.test.kernel.deployment.xml.support.AnnotationWithAttribute;
import org.jboss.test.kernel.deployment.xml.support.AnnotationWithAttributes;
import org.jboss.test.kernel.deployment.xml.test.AbstractXMLTest;

public class AnnotationTestCase
extends AbstractXMLTest {
    protected AbstractAnnotationMetaData getAnnotation(String name) throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean(name);
        ConstructorMetaData constructor = bean.getConstructor();
        AnnotationTestCase.assertNotNull((Object)constructor);
        Set annotations = constructor.getAnnotations();
        AnnotationTestCase.assertEquals((int)1, (int)annotations.size());
        AbstractAnnotationMetaData annotation = (AbstractAnnotationMetaData)annotations.iterator().next();
        AnnotationTestCase.assertNotNull((Object)annotation);
        return annotation;
    }

    public void testSimpleAnnotation() throws Exception {
        AbstractAnnotationMetaData annotation = this.getAnnotation("AnnotationSimple.xml");
        Annotation ann = annotation.getAnnotationInstance();
        AnnotationTestCase.assertEquals((String)Annotation1.class.getName(), (String)ann.annotationType().getName());
        AnnotationTestCase.assertTrue((boolean)(ann instanceof Annotation1));
    }

    public void testAnnotationWithAttribute() throws Exception {
        AbstractAnnotationMetaData annotation = this.getAnnotation("AnnotationWithAttribute.xml");
        Annotation ann = annotation.getAnnotationInstance();
        AnnotationTestCase.assertEquals((String)AnnotationWithAttribute.class.getName(), (String)ann.annotationType().getName());
        AnnotationTestCase.assertTrue((boolean)(ann instanceof AnnotationWithAttribute));
        AnnotationWithAttribute ann1 = (AnnotationWithAttribute)ann;
        AnnotationTestCase.assertNotNull(ann1.attribute());
        AnnotationTestCase.assertEquals(Long.class, ann1.attribute());
    }

    public void testAnnotationWithAttributes() throws Exception {
        AbstractAnnotationMetaData annotation = this.getAnnotation("AnnotationWithAttributes.xml");
        Annotation ann = annotation.getAnnotationInstance();
        AnnotationTestCase.assertEquals((String)AnnotationWithAttributes.class.getName(), (String)ann.annotationType().getName());
        AnnotationTestCase.assertTrue((boolean)(ann instanceof AnnotationWithAttributes));
        AnnotationWithAttributes ann1 = (AnnotationWithAttributes)ann;
        AnnotationTestCase.assertNotNull(ann1.clazz());
        AnnotationTestCase.assertEquals(Integer.class, ann1.clazz());
        AnnotationTestCase.assertNotNull((Object)ann1.integer());
        AnnotationTestCase.assertEquals((int)100, (int)ann1.integer());
        AnnotationTestCase.assertNotNull((Object)ann1.str());
        AnnotationTestCase.assertEquals((String)"Annotations are nice", (String)ann1.str());
    }

    public static Test suite() {
        return AnnotationTestCase.suite(AnnotationTestCase.class);
    }

    public AnnotationTestCase(String name) {
        super(name);
    }

    protected AnnotationTestCase(String name, boolean useClone) {
        super(name, useClone);
    }
}

