/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.util.HashSet;
import java.util.List;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.test.kernel.deployment.xml.support.Annotation1;
import org.jboss.test.kernel.deployment.xml.support.Annotation2;
import org.jboss.test.kernel.deployment.xml.support.Annotation3;
import org.jboss.test.kernel.deployment.xml.test.AbstractMCTest;

public class ParameterJaxbTestCase
extends AbstractMCTest {
    protected ParameterMetaData getParameter() throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean();
        ConstructorMetaData constructor = bean.getConstructor();
        ParameterJaxbTestCase.assertNotNull((Object)constructor);
        List parameters = constructor.getParameters();
        ParameterJaxbTestCase.assertNotNull((Object)parameters);
        ParameterJaxbTestCase.assertEquals((int)1, (int)parameters.size());
        ParameterMetaData parameter = (ParameterMetaData)parameters.get(0);
        ParameterJaxbTestCase.assertNotNull((Object)parameter);
        return parameter;
    }

    public void testParameter() throws Exception {
        ParameterMetaData parameter = this.getParameter();
        ParameterJaxbTestCase.assertNull((Object)parameter.getType());
        ParameterJaxbTestCase.assertNull((Object)parameter.getAnnotations());
        ParameterJaxbTestCase.assertNull((Object)parameter.getValue());
    }

    public void testParameterWithBean() throws Exception {
        ParameterMetaData parameter = this.getParameter();
        ParameterJaxbTestCase.assertNull((Object)parameter.getAnnotations());
        this.assertBean(parameter.getValue());
    }

    public void testParameterWithClass() throws Exception {
        ParameterMetaData parameter = this.getParameter();
        ParameterJaxbTestCase.assertEquals((String)"ParameterClass", (String)parameter.getType());
        ParameterJaxbTestCase.assertNull((Object)parameter.getAnnotations());
        ParameterJaxbTestCase.assertNull((Object)parameter.getValue());
    }

    public void testParameterWithAnnotation() throws Exception {
        ParameterMetaData parameter = this.getParameter();
        ParameterJaxbTestCase.assertNull((Object)parameter.getType());
        HashSet<String> expected = new HashSet<String>();
        expected.add(Annotation1.class.getName());
        this.assertAnnotations(expected, parameter.getAnnotations());
        ParameterJaxbTestCase.assertNull((Object)parameter.getValue());
    }

    public void testParameterWithAnnotations() throws Exception {
        ParameterMetaData parameter = this.getParameter();
        ParameterJaxbTestCase.assertNull((Object)parameter.getType());
        HashSet<String> expected = new HashSet<String>();
        expected.add(Annotation1.class.getName());
        expected.add(Annotation2.class.getName());
        expected.add(Annotation3.class.getName());
        this.assertAnnotations(expected, parameter.getAnnotations());
        ParameterJaxbTestCase.assertNull((Object)parameter.getValue());
    }

    public void testParameterWithPlainValue() throws Exception {
        ParameterMetaData parameter = this.getParameter();
        ParameterJaxbTestCase.assertNull((Object)parameter.getType());
        ParameterJaxbTestCase.assertNull((Object)parameter.getAnnotations());
        this.assertPlainValue("PlainValue", parameter.getValue());
    }

    public void testParameterWithValue() throws Exception {
        ParameterMetaData parameter = this.getParameter();
        ParameterJaxbTestCase.assertNull((Object)parameter.getType());
        ParameterJaxbTestCase.assertNull((Object)parameter.getAnnotations());
        this.assertValue("Value", parameter.getValue());
    }

    public void testParameterWithInjection() throws Exception {
        ParameterMetaData parameter = this.getParameter();
        ParameterJaxbTestCase.assertNull((Object)parameter.getType());
        ParameterJaxbTestCase.assertNull((Object)parameter.getAnnotations());
        this.assertInjection(parameter.getValue());
    }

    public void testParameterWithCollection() throws Exception {
        ParameterMetaData parameter = this.getParameter();
        ParameterJaxbTestCase.assertNull((Object)parameter.getType());
        ParameterJaxbTestCase.assertNull((Object)parameter.getAnnotations());
        this.assertCollection(parameter.getValue());
    }

    public void testParameterWithList() throws Exception {
        ParameterMetaData parameter = this.getParameter();
        ParameterJaxbTestCase.assertNull((Object)parameter.getType());
        ParameterJaxbTestCase.assertNull((Object)parameter.getAnnotations());
        this.assertList(parameter.getValue());
    }

    public void testParameterWithSet() throws Exception {
        ParameterMetaData parameter = this.getParameter();
        ParameterJaxbTestCase.assertNull((Object)parameter.getType());
        ParameterJaxbTestCase.assertNull((Object)parameter.getAnnotations());
        this.assertSet(parameter.getValue());
    }

    public void testParameterWithArray() throws Exception {
        ParameterMetaData parameter = this.getParameter();
        ParameterJaxbTestCase.assertNull((Object)parameter.getType());
        ParameterJaxbTestCase.assertNull((Object)parameter.getAnnotations());
        this.assertArray(parameter.getValue());
    }

    public void testParameterWithMap() throws Exception {
        ParameterMetaData parameter = this.getParameter();
        ParameterJaxbTestCase.assertNull((Object)parameter.getType());
        ParameterJaxbTestCase.assertNull((Object)parameter.getAnnotations());
        this.assertMap(parameter.getValue());
    }

    public void testParameterWithThis() throws Exception {
        ParameterMetaData parameter = this.getParameter();
        ParameterJaxbTestCase.assertNull((Object)parameter.getType());
        ParameterJaxbTestCase.assertNull((Object)parameter.getAnnotations());
        this.assertThis(parameter.getValue());
    }

    public void testParameterWithWildcard() throws Exception {
        ParameterMetaData parameter = this.getParameter();
        ParameterJaxbTestCase.assertNull((Object)parameter.getType());
        ParameterJaxbTestCase.assertNull((Object)parameter.getAnnotations());
        this.assertWildcard(parameter.getValue());
    }

    public static Test suite() {
        return ParameterJaxbTestCase.suite(ParameterJaxbTestCase.class);
    }

    public ParameterJaxbTestCase(String name) {
        super(name);
    }
}

