/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.util.List;
import java.util.Set;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueFactoryMetaData;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.deployment.xml.test.AbstractMCTest;
import org.jboss.test.kernel.deployment.xml.test.ValueFactoryTestCase;

public class ValueFactoryJaxbTestCase
extends AbstractMCTest {
    protected AbstractValueFactoryMetaData getValueFactory(String name) throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean();
        Set properties = bean.getProperties();
        ValueFactoryJaxbTestCase.assertNotNull((Object)properties);
        ValueFactoryJaxbTestCase.assertEquals((int)1, (int)properties.size());
        PropertyMetaData property = (PropertyMetaData)properties.iterator().next();
        ValueFactoryJaxbTestCase.assertNotNull((Object)property);
        ValueMetaData value = property.getValue();
        ValueFactoryJaxbTestCase.assertNotNull((Object)value);
        ValueFactoryJaxbTestCase.assertTrue((boolean)(value instanceof AbstractValueFactoryMetaData));
        return (AbstractValueFactoryMetaData)value;
    }

    public void testValueFactoryWithBean() throws Exception {
        AbstractValueFactoryMetaData dependency = this.getValueFactory("ValueFactoryWithBean.xml");
        ValueFactoryJaxbTestCase.assertEquals((Object)"Dummy", (Object)dependency.getValue());
        ValueFactoryJaxbTestCase.assertEquals((String)"getValue", (String)dependency.getMethod());
        ValueFactoryJaxbTestCase.assertNull((Object)dependency.getDependentState());
    }

    public void testValueFactoryWithParameter() throws Exception {
        AbstractValueFactoryMetaData dependency = this.getValueFactory("ValueFactoryWithParameter.xml");
        ValueFactoryJaxbTestCase.assertEquals((Object)"Dummy", (Object)dependency.getValue());
        ValueFactoryJaxbTestCase.assertEquals((String)"getValue", (String)dependency.getMethod());
        List parameters = dependency.getParameters();
        ValueFactoryJaxbTestCase.assertNotNull((Object)parameters);
        ValueFactoryJaxbTestCase.assertFalse((boolean)parameters.isEmpty());
        ValueFactoryJaxbTestCase.assertTrue((parameters.size() == 1 ? 1 : 0) != 0);
        ParameterMetaData pmd = (ParameterMetaData)parameters.get(0);
        ValueFactoryJaxbTestCase.assertNotNull((Object)pmd);
        ValueMetaData value = pmd.getValue();
        ValueFactoryJaxbTestCase.assertNotNull((Object)value);
        ValueFactoryJaxbTestCase.assertEquals((Object)"foo.bar.key", (Object)value.getUnderlyingValue());
        ValueFactoryJaxbTestCase.assertNull((Object)dependency.getDependentState());
    }

    public void testValueFactoryWithParameters() throws Exception {
        AbstractValueFactoryMetaData dependency = this.getValueFactory("ValueFactoryWithParameters.xml");
        ValueFactoryJaxbTestCase.assertEquals((Object)"Dummy", (Object)dependency.getValue());
        ValueFactoryJaxbTestCase.assertEquals((String)"getValue", (String)dependency.getMethod());
        List parameters = dependency.getParameters();
        ValueFactoryJaxbTestCase.assertNotNull((Object)parameters);
        ValueFactoryJaxbTestCase.assertFalse((boolean)parameters.isEmpty());
        ValueFactoryJaxbTestCase.assertTrue((parameters.size() == 2 ? 1 : 0) != 0);
        ParameterMetaData pmd1 = (ParameterMetaData)parameters.get(0);
        ValueFactoryJaxbTestCase.assertNotNull((Object)pmd1);
        ValueMetaData value1 = pmd1.getValue();
        ValueFactoryJaxbTestCase.assertNotNull((Object)value1);
        ValueFactoryJaxbTestCase.assertEquals((Object)"foo.bar.key", (Object)value1.getUnderlyingValue());
        ParameterMetaData pmd2 = (ParameterMetaData)parameters.get(1);
        ValueFactoryJaxbTestCase.assertNotNull((Object)pmd2);
        ValueMetaData value2 = pmd2.getValue();
        ValueFactoryJaxbTestCase.assertNotNull((Object)value2);
        ValueFactoryJaxbTestCase.assertEquals((Object)"mydefault", (Object)value2.getUnderlyingValue());
        ValueFactoryJaxbTestCase.assertNull((Object)dependency.getDependentState());
    }

    public void testValueFactoryWithDefault() throws Exception {
        AbstractValueFactoryMetaData dependency = this.getValueFactory("ValueFactoryWithDefault.xml");
        ValueFactoryJaxbTestCase.assertEquals((Object)"Dummy", (Object)dependency.getValue());
        ValueFactoryJaxbTestCase.assertEquals((String)"getValue", (String)dependency.getMethod());
        ValueFactoryJaxbTestCase.assertEquals((String)"mydefault", (String)dependency.getDefaultValue());
        ValueFactoryJaxbTestCase.assertNull((Object)dependency.getDependentState());
    }

    public void testValueFactoryWithState() throws Exception {
        AbstractValueFactoryMetaData dependency = this.getValueFactory("ValueFactoryWithState.xml");
        ValueFactoryJaxbTestCase.assertEquals((Object)"Dummy", (Object)dependency.getValue());
        ValueFactoryJaxbTestCase.assertEquals((String)"getValue", (String)dependency.getMethod());
        ValueFactoryJaxbTestCase.assertEquals((Object)ControllerState.CONFIGURED, (Object)dependency.getDependentState());
    }

    public void testValueFactoryWithWhenRequired() throws Exception {
        AbstractValueFactoryMetaData dependency = this.getValueFactory("ValueFactoryWithWhenRequired.xml");
        ValueFactoryJaxbTestCase.assertEquals((Object)"Dummy", (Object)dependency.getValue());
        ValueFactoryJaxbTestCase.assertEquals((String)"getValue", (String)dependency.getMethod());
        ValueFactoryJaxbTestCase.assertEquals((Object)ControllerState.CREATE, (Object)dependency.getWhenRequiredState());
    }

    public void testValueFactoryBadNoBean() throws Exception {
        try {
            AbstractValueFactoryMetaData dependency = this.getValueFactory("ValueFactoryBadNoBean.xml");
            ValueFactoryJaxbTestCase.assertNull((Object)dependency.getValue());
        }
        catch (Exception expected) {
            this.checkJBossXBException(IllegalArgumentException.class, expected);
        }
    }

    public void testValueFactoryBadNoMethod() throws Exception {
        try {
            AbstractValueFactoryMetaData dependency = this.getValueFactory("ValueFactoryBadNoMethod.xml");
            ValueFactoryJaxbTestCase.assertNull((Object)dependency.getValue());
        }
        catch (Exception expected) {
            this.checkJBossXBException(IllegalArgumentException.class, expected);
        }
    }

    public static Test suite() {
        return ValueFactoryJaxbTestCase.suite(ValueFactoryTestCase.class);
    }

    public ValueFactoryJaxbTestCase(String name) {
        super(name);
    }
}

