/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.registry.test;

import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.registry.KernelBus;
import org.jboss.kernel.spi.registry.KernelRegistry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.test.kernel.AbstractKernelTest;
import org.jboss.test.kernel.registry.support.BusBean;

public class BusTestCase
extends AbstractKernelTest {
    public static Test suite() {
        return BusTestCase.suite(BusTestCase.class);
    }

    public BusTestCase(String name) {
        super(name);
    }

    public void testSetAndGet() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelRegistry registry = kernel.getRegistry();
        KernelConfigurator configurator = kernel.getConfigurator();
        registry.registerEntry((Object)"Bus", BusTestCase.makeContext(configurator, "Name1", new BusBean()));
        KernelBus bus = kernel.getBus();
        Object result1 = bus.get((Object)"Bus", "value");
        BusTestCase.assertNull((String)"Result 1", (Object)result1);
        bus.set((Object)"Bus", "value", (Object)"BusBus");
        Object result2 = bus.get((Object)"Bus", "value");
        BusTestCase.assertEquals((Object)"BusBus", (Object)result2);
    }

    public void testInvoke() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelRegistry registry = kernel.getRegistry();
        KernelConfigurator configurator = kernel.getConfigurator();
        registry.registerEntry((Object)"Name1", BusTestCase.makeContext(configurator, "Name1", "A string"));
        registry.registerEntry((Object)"Name2", BusTestCase.makeContext(configurator, "Name2", "B string"));
        KernelBus bus = kernel.getBus();
        Object result1 = bus.invoke((Object)"Name1", "toString", new Object[0], new String[0]);
        Object result2 = bus.invoke((Object)"Name2", "toString", new Object[0], new String[0]);
        BusTestCase.assertEquals((Object)"A string", (Object)result1);
        BusTestCase.assertEquals((Object)"B string", (Object)result2);
    }

    protected static KernelRegistryEntry makeContext(KernelConfigurator configurator, String name, Object target) throws Throwable {
        return new AbstractKernelControllerContext(configurator.getBeanInfo(target.getClass()), (BeanMetaData)new AbstractBeanMetaData(name, target.getClass().getName()), target);
    }
}

