/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.io.Serializable;
import java.util.Set;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.beans.metadata.plugins.AbstractArrayMetaData;
import org.jboss.beans.metadata.plugins.AbstractCollectionMetaData;
import org.jboss.beans.metadata.plugins.AbstractFeatureMetaData;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractListMetaData;
import org.jboss.beans.metadata.plugins.AbstractMapMetaData;
import org.jboss.beans.metadata.plugins.AbstractSetMetaData;
import org.jboss.beans.metadata.plugins.AbstractTypeMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueFactoryMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.plugins.CloneUtil;
import org.jboss.beans.metadata.plugins.StringValueMetaData;
import org.jboss.beans.metadata.plugins.ThisValueMetaData;
import org.jboss.beans.metadata.plugins.TypeProvider;
import org.jboss.beans.metadata.plugins.ValueMetaDataAware;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlType(name="propertyType", propOrder={"annotations", "value"})
public class AbstractPropertyMetaData
extends AbstractFeatureMetaData
implements PropertyMetaData,
ValueMetaDataAware,
TypeProvider,
Serializable {
    private static final long serialVersionUID = 3L;
    protected String name;
    protected boolean preInstantiate = true;
    protected ValueMetaData value;
    protected String type;
    private Boolean replace;
    private Boolean trim;

    public AbstractPropertyMetaData() {
    }

    public AbstractPropertyMetaData(String name, Object value) {
        this.name = name;
        this.value = new AbstractValueMetaData(value);
    }

    public AbstractPropertyMetaData(String name, String value) {
        this.name = name;
        this.value = new StringValueMetaData(value);
    }

    public AbstractPropertyMetaData(String name, ValueMetaData value) {
        this.name = name;
        this.value = value;
    }

    public AbstractPropertyMetaData(String name, String value, String type) {
        this.name = name;
        StringValueMetaData svmd = new StringValueMetaData(value);
        svmd.setType(type);
        this.value = svmd;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @XmlAttribute
    public void setName(String name) {
        this.name = name;
        this.flushJBossObjectCache();
    }

    @Override
    public String getType() {
        if (this.value instanceof AbstractTypeMetaData) {
            return ((AbstractTypeMetaData)this.value).getType();
        }
        return null;
    }

    @Override
    public boolean isPreInstantiate() {
        return this.preInstantiate;
    }

    @XmlAttribute(name="preinstantiate")
    public void setPreInstantiate(boolean preInstantiate) {
        this.preInstantiate = preInstantiate;
    }

    @Override
    public ValueMetaData getValue() {
        return this.value;
    }

    @Override
    @XmlElements(value={@XmlElement(name="array", type=AbstractArrayMetaData.class), @XmlElement(name="collection", type=AbstractCollectionMetaData.class), @XmlElement(name="inject", type=AbstractInjectionValueMetaData.class), @XmlElement(name="list", type=AbstractListMetaData.class), @XmlElement(name="map", type=AbstractMapMetaData.class), @XmlElement(name="set", type=AbstractSetMetaData.class), @XmlElement(name="null", type=AbstractValueMetaData.class), @XmlElement(name="this", type=ThisValueMetaData.class), @XmlElement(name="value", type=StringValueMetaData.class), @XmlElement(name="value-factory", type=AbstractValueFactoryMetaData.class)})
    public void setValue(ValueMetaData value) {
        this.value = value;
        this.flushJBossObjectCache();
    }

    @XmlAnyElement
    @ManagementProperty(ignored=true)
    public void setValueObject(Object value) {
        if (value == null) {
            this.setValue(null);
        } else if (value instanceof ValueMetaData) {
            this.setValue((ValueMetaData)value);
        } else {
            this.setValue(new AbstractValueMetaData(value));
        }
    }

    @XmlValue
    @ManagementProperty(ignored=true)
    public void setValueString(String value) {
        if (value == null) {
            this.setValue(null);
        } else {
            ValueMetaData valueMetaData = this.getValue();
            if (valueMetaData instanceof StringValueMetaData) {
                ((StringValueMetaData)valueMetaData).setValue(value);
            } else {
                StringValueMetaData stringValue = new StringValueMetaData(value);
                stringValue.setType(this.getType());
                this.setValue(stringValue);
            }
        }
    }

    public String getPropertyType() {
        return this.type;
    }

    @XmlAttribute(name="class")
    @ManagementProperty(ignored=true)
    public void setPropertyType(String type) {
        this.type = type;
    }

    @XmlAttribute(name="replace")
    @ManagementProperty(ignored=true)
    public void setPropertyReplace(boolean replace) {
        this.replace = replace;
    }

    @XmlAttribute(name="trim")
    @ManagementProperty(ignored=true)
    public void setPropertyTrim(boolean trim) {
        this.trim = trim;
    }

    @Override
    public void initialVisit(MetaDataVisitor visitor) {
        String name = this.getName();
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("Null or empty property name.");
        }
        ValueMetaData vmd = this.getValue();
        if (vmd != null && vmd instanceof AbstractInjectionValueMetaData) {
            ((AbstractInjectionValueMetaData)vmd).setPropertyMetaData(this);
        }
        if (vmd != null && vmd instanceof StringValueMetaData) {
            StringValueMetaData svmd = (StringValueMetaData)vmd;
            if (this.type != null) {
                svmd.setType(this.type);
            }
            if (this.replace != null) {
                svmd.setReplace(this.replace);
            }
            if (this.trim != null) {
                svmd.setTrim(this.trim);
            }
        }
        visitor.setContextState(ControllerState.CONFIGURED);
        super.initialVisit(visitor);
    }

    @Override
    public void addChildren(Set<MetaDataVisitorNode> children) {
        if (this.value != null) {
            children.add(this.value);
        }
    }

    @Override
    public TypeInfo getType(MetaDataVisitor visitor, MetaDataVisitorNode previous) throws Throwable {
        String type = this.getType();
        if (type != null) {
            KernelControllerContext context = visitor.getControllerContext();
            ClassLoader cl = Configurator.getClassLoader(context.getBeanMetaData());
            KernelConfigurator configurator = context.getKernel().getConfigurator();
            return configurator.getClassInfo(type, cl);
        }
        KernelControllerContext context = visitor.getControllerContext();
        BeanInfo beanInfo = context.getBeanInfo();
        PropertyInfo pi = beanInfo.getProperty(this.getName());
        return this.applyCollectionOrMapCheck(pi.getType());
    }

    @Override
    public void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
        if (this.value != null) {
            buffer.append(" value=").append((Object)this.value);
        }
        super.toString(buffer);
    }

    @Override
    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.name);
    }

    @Override
    public AbstractPropertyMetaData clone() {
        AbstractPropertyMetaData clone = (AbstractPropertyMetaData)super.clone();
        this.doClone(clone);
        clone.setValue(CloneUtil.cloneObject(this.value, ValueMetaData.class));
        return clone;
    }
}

