/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.config;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.joinpoint.plugins.Config;
import org.jboss.joinpoint.spi.ConstructorJoinpoint;
import org.jboss.joinpoint.spi.Joinpoint;
import org.jboss.joinpoint.spi.JoinpointException;
import org.jboss.joinpoint.spi.JoinpointFactory;
import org.jboss.joinpoint.spi.MethodJoinpoint;
import org.jboss.kernel.spi.config.KernelConfig;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configurator
extends Config {
    public static Object instantiateAndConfigure(KernelConfig config, BeanInfo info, BeanMetaData metaData) throws Throwable {
        Object result = Configurator.instantiate(config, info, metaData);
        if (metaData != null) {
            Configurator.configure(result, info, metaData);
        }
        return result;
    }

    public static Object instantiate(KernelConfig config, BeanInfo info, BeanMetaData metaData) throws Throwable {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Instantiating info=" + info + " metaData=" + metaData));
        }
        ConstructorMetaData constructor = null;
        if (metaData != null) {
            constructor = metaData.getConstructor();
        }
        Joinpoint joinPoint = Configurator.getConstructorJoinPoint(config, info, constructor, metaData);
        return joinPoint.dispatch();
    }

    public static Joinpoint getConstructorJoinPoint(KernelConfig config, BeanInfo info, ConstructorMetaData metaData, BeanMetaData beanMetaData) throws Throwable {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Get constructor joinpoint info=" + info + " constructor=" + metaData));
        }
        if (config == null) {
            throw new IllegalArgumentException("Null config");
        }
        if (metaData != null) {
            ClassLoader cl = Configurator.getClassLoader(beanMetaData);
            ValueMetaData vmd = metaData.getValue();
            if (vmd != null) {
                ClassInfo typeInfo = null;
                if (info != null) {
                    typeInfo = info.getClassInfo();
                }
                return new ValueJoinpoint(vmd, (TypeInfo)typeInfo, cl);
            }
            vmd = metaData.getFactory();
            if (vmd != null) {
                Object factory = vmd.getValue(null, cl);
                List<ParameterMetaData> parameters = metaData.getParameters();
                BeanInfo factoryInfo = config.getBeanInfo(factory.getClass());
                MethodJoinpoint joinPoint = Configurator.findMethod(trace, factoryInfo, cl, metaData.getFactoryMethod(), parameters, false, true);
                joinPoint.setTarget(factory);
                MethodInfo minfo = joinPoint.getMethodInfo();
                if (minfo != null) {
                    TypeInfo[] pinfos = minfo.getParameterTypes();
                    Object[] params = Configurator.getParameters(trace, cl, pinfos, parameters);
                    joinPoint.setArguments(params);
                }
                return joinPoint;
            }
            String factoryClassName = metaData.getFactoryClass();
            if (factoryClassName != null) {
                List<ParameterMetaData> parameters = metaData.getParameters();
                BeanInfo factoryInfo = config.getBeanInfo(factoryClassName, cl);
                MethodJoinpoint joinPoint = Configurator.findMethod(trace, factoryInfo, cl, metaData.getFactoryMethod(), parameters, true, true);
                MethodInfo minfo = joinPoint.getMethodInfo();
                if (minfo != null) {
                    TypeInfo[] pinfos = minfo.getParameterTypes();
                    Object[] params = Configurator.getParameters(trace, cl, pinfos, parameters);
                    joinPoint.setArguments(params);
                }
                return joinPoint;
            }
            ConstructorJoinpoint joinPoint = Configurator.findConstructor(trace, info, metaData);
            ConstructorInfo cinfo = joinPoint.getConstructorInfo();
            if (cinfo != null) {
                TypeInfo[] pinfos = cinfo.getParameterTypes();
                Object[] params = Configurator.getParameters(trace, cl, pinfos, metaData.getParameters());
                joinPoint.setArguments(params);
            }
            return joinPoint;
        }
        return Configurator.findConstructor(trace, info, metaData);
    }

    public static ConstructorJoinpoint findConstructor(boolean trace, BeanInfo info, BeanMetaData metaData) throws Exception {
        return Configurator.findConstructor(trace, info, metaData.getConstructor());
    }

    public static ConstructorJoinpoint findConstructor(boolean trace, BeanInfo info, ConstructorMetaData metaData) throws Exception {
        ConstructorInfo cinfo = Configurator.resolveConstructor(trace, info, metaData);
        JoinpointFactory jpf = info.getJoinpointFactory();
        return jpf.getConstructorJoinpoint(cinfo);
    }

    public static ConstructorInfo resolveConstructor(boolean trace, BeanInfo info, ConstructorMetaData metaData) {
        if (info == null) {
            throw new IllegalArgumentException("Null bean info");
        }
        List<Object> params = Collections.emptyList();
        if (metaData != null && metaData.getParameters() != null) {
            params = metaData.getParameters();
        }
        String[] paramTypes = new String[params.size()];
        if (!params.isEmpty()) {
            int x = 0;
            for (ParameterMetaData parameterMetaData : params) {
                paramTypes[x++] = parameterMetaData.getType();
            }
        }
        return Configurator.findConstructorInfo((ClassInfo)info.getClassInfo(), (String[])paramTypes);
    }

    public static void configure(Object object, BeanInfo info, BeanMetaData metaData) throws Throwable {
        boolean trace = log.isTraceEnabled();
        if (object == null) {
            throw new IllegalArgumentException("Null object");
        }
        if (info == null) {
            throw new IllegalArgumentException("Null bean info");
        }
        if (metaData == null) {
            throw new IllegalArgumentException("Null bean metadata");
        }
        Set<PropertyMetaData> properties = metaData.getProperties();
        if (properties != null && !properties.isEmpty()) {
            ClassLoader cl = Configurator.getClassLoader(metaData);
            for (PropertyMetaData property : metaData.getProperties()) {
                Configurator.configure(trace, object, info, cl, property);
            }
        }
    }

    public static void configure(Object object, BeanInfo info, ClassLoader cl, PropertyMetaData metaData) throws Throwable {
        boolean trace = log.isTraceEnabled();
        Configurator.configure(trace, object, info, cl, metaData);
    }

    public static void configure(boolean trace, Object object, BeanInfo info, ClassLoader cl, PropertyMetaData metaData) throws Throwable {
        PropertyInfo ainfo = Configurator.resolveProperty(trace, info, cl, metaData.getName(), metaData.getType());
        Configurator.configure(trace, object, ainfo, cl, metaData);
    }

    public static void configure(Object object, PropertyInfo info, ClassLoader cl, PropertyMetaData metaData) throws Throwable {
        boolean trace = log.isTraceEnabled();
        Configurator.configure(trace, object, info, cl, metaData);
    }

    public static void configure(boolean trace, Object object, PropertyInfo info, ClassLoader cl, PropertyMetaData metaData) throws Throwable {
        if (trace) {
            log.trace((Object)("Configuring info=" + info + " metaData=" + metaData));
        }
        if (trace) {
            log.trace((Object)("Setting property " + info));
        }
        info.set(object, metaData.getValue().getValue(info.getType(), cl));
    }

    public static void unconfigure(Object object, BeanInfo info, BeanMetaData metaData) throws Throwable {
        if (object == null) {
            throw new IllegalArgumentException("Null object");
        }
        if (info == null) {
            throw new IllegalArgumentException("Null bean info");
        }
        if (metaData == null) {
            throw new IllegalArgumentException("Null bean metadata");
        }
        ClassLoader cl = Configurator.getClassLoader(metaData);
        Set<PropertyMetaData> propertys = metaData.getProperties();
        if (propertys != null && !propertys.isEmpty()) {
            for (PropertyMetaData property : metaData.getProperties()) {
                Configurator.unconfigure(object, cl, info, property);
            }
        }
    }

    public static void unconfigure(Object object, ClassLoader cl, BeanInfo info, PropertyMetaData metaData) throws Throwable {
        boolean trace = log.isTraceEnabled();
        PropertyInfo ainfo = Configurator.resolveProperty(trace, info, cl, metaData.getName(), metaData.getType());
        Configurator.unconfigure(trace, object, ainfo, metaData);
    }

    public static void unconfigure(boolean trace, Object object, PropertyInfo info, PropertyMetaData metaData) throws Throwable {
        if (trace) {
            log.trace((Object)("Unconfiguring info=" + info + " metaData=" + metaData));
        }
        if (trace) {
            log.trace((Object)("Unsetting property " + info));
        }
        info.set(object, null);
    }

    public static PropertyInfo resolveProperty(boolean trace, BeanInfo info, String name) throws Throwable {
        return Configurator.resolveProperty(trace, info, null, name, null);
    }

    public static PropertyInfo resolveProperty(boolean trace, BeanInfo info, ClassLoader cl, String name, String type) throws Throwable {
        if (info == null) {
            throw new IllegalArgumentException("Null bean info");
        }
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (trace) {
            log.trace((Object)("Resolving property on bean info=" + info + " name=" + name));
        }
        if (cl == null) {
            cl = info.getClassInfo().getType().getClassLoader();
        }
        PropertyInfo ainfo = info.getProperty(name);
        ClassInfo classInfo = info.getClassInfo();
        TypeInfoFactory tif = classInfo.getTypeInfoFactory();
        if (tif == null) {
            throw new IllegalArgumentException("TypeInfoFactory is null: " + classInfo);
        }
        String[] typeNames = new String[]{type};
        TypeInfo[] typeInfos = new TypeInfo[]{ainfo.getType()};
        if (Configurator.equals((String[])typeNames, (TypeInfo[])typeInfos) || Configurator.isAssignable(tif, cl, typeNames, typeInfos)) {
            return ainfo;
        }
        throw new JoinpointException("Property " + name + " not found for " + info);
    }

    public static MethodJoinpoint findMethod(BeanInfo info, ClassLoader cl, String name, List<ParameterMetaData> parameters, boolean isStatic, boolean isPublic) throws Throwable {
        boolean trace = log.isTraceEnabled();
        return Configurator.findMethod(trace, info, cl, name, parameters, isStatic, isPublic);
    }

    public static MethodJoinpoint findMethod(boolean trace, BeanInfo info, ClassLoader cl, String name, List<ParameterMetaData> parameters, boolean isStatic, boolean isPublic) throws Throwable {
        if (info == null) {
            throw new IllegalArgumentException("Null bean info");
        }
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        String[] paramTypes = Configurator.getParameterTypes(trace, parameters);
        MethodInfo minfo = Configurator.findMethodInfo((ClassInfo)info.getClassInfo(), (String)name, (String[])paramTypes, (boolean)isStatic, (boolean)isPublic);
        JoinpointFactory jpf = info.getJoinpointFactory();
        MethodJoinpoint joinPoint = jpf.getMethodJoinpoint(minfo);
        if (minfo != null) {
            TypeInfo[] pinfos = minfo.getParameterTypes();
            Object[] params = Configurator.getParameters(trace, cl, pinfos, parameters);
            joinPoint.setArguments(params);
        }
        return joinPoint;
    }

    public static String[] getParameterTypes(boolean trace, List<ParameterMetaData> parameters) throws Throwable {
        if (parameters == null) {
            return null;
        }
        String[] paramTypes = new String[parameters.size()];
        int x = 0;
        for (ParameterMetaData pmd : parameters) {
            paramTypes[x++] = pmd.getType();
        }
        return paramTypes;
    }

    public static String[] getParameterTypes(boolean trace, TypeInfo[] parameters) throws Throwable {
        if (parameters == null) {
            return null;
        }
        String[] paramTypes = new String[parameters.length];
        int x = 0;
        for (int i = 0; i < parameters.length; ++i) {
            paramTypes[x++] = parameters[i].getName();
        }
        return paramTypes;
    }

    public static Object[] getParameters(boolean trace, ClassLoader cl, TypeInfo[] pinfos, List<ParameterMetaData> parameters) throws Throwable {
        if (parameters == null) {
            return null;
        }
        Object[] params = new Object[parameters.size()];
        int x = 0;
        for (ParameterMetaData pdata : parameters) {
            ValueMetaData vmd = pdata.getValue();
            params[x] = vmd.getValue(pinfos[x], cl);
            ++x;
        }
        return params;
    }

    public static ClassLoader getClassLoader(BeanMetaData metaData) throws Throwable {
        ClassLoaderMetaData clmd = null;
        if (metaData != null) {
            clmd = metaData.getClassLoader();
        }
        return Configurator.getClassLoader(clmd);
    }

    public static ClassLoader getClassLoader(ClassLoaderMetaData metaData) throws Throwable {
        ValueMetaData clVMD;
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        ClassLoader cl = null;
        if (metaData != null && (clVMD = metaData.getClassLoader()) != null) {
            Object object = clVMD.getValue(null, tcl);
            if (object != null && !(object instanceof ClassLoader)) {
                throw new IllegalArgumentException("Configured object is not a classloader " + metaData);
            }
            cl = (ClassLoader)object;
        }
        if (cl == null) {
            cl = tcl;
        }
        return cl;
    }

    public static boolean isAssignable(TypeInfoFactory tif, ClassLoader cl, String[] typeNames, TypeInfo[] typeInfos) throws Throwable {
        if (cl == null) {
            return false;
        }
        if (!Configurator.simpleCheck((String[])typeNames, (TypeInfo[])typeInfos)) {
            return false;
        }
        for (int i = 0; i < typeNames.length; ++i) {
            if (typeNames[i] == null || typeInfos[i].isAssignableFrom(tif.getTypeInfo(typeNames[i], cl))) continue;
            return false;
        }
        return true;
    }

    private static class ValueJoinpoint
    implements Joinpoint {
        private ValueMetaData vmd;
        private TypeInfo info;
        private ClassLoader cl;

        public ValueJoinpoint(ValueMetaData vmd, TypeInfo info, ClassLoader cl) {
            this.vmd = vmd;
            this.info = info;
            this.cl = cl;
        }

        public Object dispatch() throws Throwable {
            return this.vmd.getValue(this.info, this.cl);
        }

        public String toHumanReadableString() {
            return this.vmd.toShortString();
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Error(e);
            }
        }
    }
}

