/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractCallbackMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.CallbackMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.dependency.spi.CallbackItem;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.kernel.plugins.annotations.AbstractAnnotationPlugin;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.reflect.spi.AnnotatedInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CallbackAnnotationPlugin<T extends AnnotatedInfo, C extends Annotation>
extends AbstractAnnotationPlugin<T, C> {
    protected CallbackAnnotationPlugin(Class<C> annotation) {
        super(annotation);
    }

    @Override
    protected boolean isElementTypeSupported(ElementType type) {
        return ElementType.METHOD == type;
    }

    @Override
    protected boolean isMetaDataAlreadyPresent(T info, C annotation, KernelControllerContext context) {
        DependencyInfo dependency = context.getDependencyInfo();
        Set<CallbackItem<?>> callbacks = this.getCallbacks(dependency);
        if (callbacks != null && !callbacks.isEmpty()) {
            for (CallbackItem<?> ci : callbacks) {
                if (!this.isEqual(info, ci)) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract boolean isEqual(T var1, CallbackItem<?> var2);

    protected abstract Set<CallbackItem<?>> getCallbacks(DependencyInfo var1);

    @Override
    protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(T info, C annotation, BeanMetaData bmd) {
        AbstractBeanMetaData beanMetaData = this.checkIfNotAbstractBeanMetaDataSpecific(bmd);
        List<CallbackMetaData> callbacks = this.getCallbacks(beanMetaData);
        AbstractCallbackMetaData callback = this.createCallback(info, annotation);
        callbacks.add((CallbackMetaData)callback);
        return Collections.singletonList(callback);
    }

    protected abstract AbstractCallbackMetaData createCallback(T var1, C var2);

    protected abstract void applyInfo(AbstractCallbackMetaData var1, T var2);

    protected abstract List<CallbackMetaData> getCallbacks(AbstractBeanMetaData var1);
}

