/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.plugins.dependency.AbstractScopeAction;
import org.jboss.kernel.plugins.dependency.ScopedKernelController;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.retrieval.MetaDataItem;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.scope.ScopeKey;

public class InstallExistingScopeAction
extends AbstractScopeAction {
    public static final InstallExistingScopeAction INSTANCE = new InstallExistingScopeAction();

    protected void installAction(ControllerContext context) throws Throwable {
        ScopeKey scopeKey = this.getScopeKey(context);
        if (scopeKey != null) {
            Controller controller = context.getController();
            if (!(controller instanceof KernelController)) {
                throw new IllegalArgumentException("Can only handle kernel controller: " + controller);
            }
            KernelController kernelController = (KernelController)controller;
            KernelMetaDataRepository repository = kernelController.getKernel().getMetaDataRepository();
            MutableMetaDataRepository mmdr = repository.getMetaDataRepository();
            MetaDataRetrieval mdr = mmdr.getMetaDataRetrieval(scopeKey);
            if (mdr == null) {
                throw new IllegalArgumentException("No metadata retrieval for scope: " + scopeKey);
            }
            MetaDataItem controllerItem = mdr.retrieveMetaData(ScopedKernelController.class);
            if (controllerItem == null) {
                throw new IllegalArgumentException("Scoped controller should exist: " + scopeKey);
            }
            ScopedKernelController scopedController = (ScopedKernelController)((Object)controllerItem.getValue());
            scopedController.addScopedControllerContext(context);
        }
    }

    protected void uninstallAction(ControllerContext context) {
        if (this.getScopeKey(context) != null) {
            Controller controller = context.getController();
            if (!(controller instanceof ScopedKernelController)) {
                throw new IllegalArgumentException("Current controller should be scoped: " + controller);
            }
            ScopedKernelController scopedController = (ScopedKernelController)controller;
            scopedController.removeScopedControllerContext(context);
        }
    }
}

