/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import org.jboss.dependency.plugins.AbstractController;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.plugins.dependency.AbstractKernelController;
import org.jboss.kernel.plugins.dependency.ScopedKernelController;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.spi.MutableMetaData;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.retrieval.MetaDataItem;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.scope.ScopeKey;

public final class ScopeHierarchyBuilder {
    public static AbstractController buildControllerHierarchy(AbstractKernelController top, MutableMetaDataRepository mmdr, ScopeKey scopeKey) throws Throwable {
        if (scopeKey == null) {
            return top;
        }
        MetaDataRetrieval mdr = mmdr.getMetaDataRetrieval(scopeKey);
        if (mdr != null) {
            MetaDataItem mdi = mdr.retrieveMetaData(ScopedKernelController.class);
            if (mdi != null) {
                return (AbstractController)mdi.getValue();
            }
        } else {
            mdr = new MemoryMetaDataLoader(scopeKey);
            mmdr.addMetaDataRetrieval(mdr);
        }
        AbstractController parentController = ScopeHierarchyBuilder.buildControllerHierarchy(top, mmdr, scopeKey.getParent());
        ScopedKernelController scopedKernelController = new ScopedKernelController(top.getKernel(), parentController, scopeKey);
        ((MutableMetaData)mdr).addMetaData((Object)scopedKernelController, ScopedKernelController.class);
        return scopedKernelController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanControllerHierarchy(MutableMetaDataRepository mmdr, ScopeKey scopeKey, ControllerContext context) {
        if (scopeKey == null) {
            return;
        }
        MetaDataRetrieval mdr = mmdr.getMetaDataRetrieval(scopeKey);
        if (mdr == null) {
            throw new IllegalArgumentException("Expecting MetaDataRetrieval instance in scope: " + scopeKey);
        }
        MetaDataItem controllerItem = mdr.retrieveMetaData(ScopedKernelController.class);
        if (controllerItem == null) {
            throw new IllegalArgumentException("Expecting ScopedKernelController instance in scope:" + scopeKey);
        }
        ScopedKernelController scopedController = (ScopedKernelController)((Object)controllerItem.getValue());
        if (context != null) {
            scopedController.removeScopedControllerContext(context);
        }
        if (!scopedController.isActive()) {
            try {
                ((MutableMetaData)mdr).removeMetaData(ScopedKernelController.class);
                if (mdr.isEmpty()) {
                    mmdr.removeMetaDataRetrieval(scopeKey);
                }
            }
            finally {
                scopedController.release();
            }
        }
        ScopeHierarchyBuilder.cleanControllerHierarchy(mmdr, scopeKey.getParent(), null);
    }
}

