/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.dependency.plugins.AbstractController;
import org.jboss.dependency.plugins.action.ControllerContextAction;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.KernelFactory;
import org.jboss.kernel.plugins.bootstrap.basic.BasicKernelInitializer;
import org.jboss.kernel.plugins.config.property.PropertyKernelConfig;
import org.jboss.kernel.plugins.dependency.AbstractKernelController;
import org.jboss.kernel.plugins.dependency.InstallExistingScopeAction;
import org.jboss.kernel.spi.bootstrap.KernelInitializer;
import org.jboss.kernel.spi.config.KernelConfig;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.event.KernelEvent;
import org.jboss.kernel.spi.event.KernelEventFilter;
import org.jboss.kernel.spi.event.KernelEventListener;
import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryPlugin;
import org.jboss.metadata.spi.scope.ScopeKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopedKernelController
extends AbstractKernelController {
    protected Kernel parentKernel;

    public ScopedKernelController(Kernel parentKernel, AbstractController parentController, ScopeKey scopeKey) throws Exception {
        this.parentKernel = parentKernel;
        this.setScopeKey(scopeKey);
        if (!(parentKernel.getController() instanceof AbstractController)) {
            throw new IllegalArgumentException("Underlying controller not AbstractController instance!");
        }
        this.setUnderlyingController((AbstractController)parentKernel.getController());
        this.setParentController(parentController);
        ScopedKernelConfig config = new ScopedKernelConfig(System.getProperties());
        this.kernel = KernelFactory.newInstance((KernelConfig)config);
        this.getParentController().addController((AbstractController)this);
    }

    private boolean isParentKernelController() {
        return this.getParentController() instanceof KernelController;
    }

    private KernelController getParentKernelController() {
        if (!this.isParentKernelController()) {
            throw new IllegalArgumentException("Illegal call to parent Controller, not of KernelController instance!");
        }
        return (KernelController)this.getParentController();
    }

    void addScopedControllerContext(ControllerContext context) {
        super.addControllerContext(context);
    }

    void removeScopedControllerContext(ControllerContext context) {
        super.removeControllerContext(context);
    }

    void release() {
        this.getParentController().removeController((AbstractController)this);
        this.setUnderlyingController(null);
        this.setParentController(null);
        this.parentKernel = null;
    }

    @Override
    protected Map<ControllerState, ControllerContextAction> createAliasActions() {
        HashMap<ControllerState, ControllerContextAction> map = new HashMap<ControllerState, ControllerContextAction>(super.createAliasActions());
        map.put(ControllerState.PRE_INSTALL, (ControllerContextAction)InstallExistingScopeAction.INSTANCE);
        return map;
    }

    public ControllerContext getContextLocally(Object name, ControllerState state) {
        return super.getContext(name, state);
    }

    @Override
    public ControllerContext getContext(Object name, ControllerState state) {
        ControllerContext context = super.getContext(name, state);
        if (context != null) {
            return context;
        }
        return this.getParentController().getContext(name, state);
    }

    public Set<ControllerContext> getNotInstalled() {
        HashSet<ControllerContext> uninstalled = new HashSet<ControllerContext>(this.getParentController().getNotInstalled());
        uninstalled.addAll(super.getNotInstalled());
        return uninstalled;
    }

    protected void install(ControllerContext context, boolean trace) throws Throwable {
        this.getParentController().install(context);
    }

    @Override
    public void fireKernelEvent(KernelEvent event) {
        if (this.isParentKernelController()) {
            this.getParentKernelController().fireKernelEvent(event);
        } else {
            super.fireKernelEvent(event);
        }
    }

    @Override
    public void registerListener(KernelEventListener listener, KernelEventFilter filter, Object handback) throws Throwable {
        if (this.isParentKernelController()) {
            this.getParentKernelController().registerListener(listener, filter, handback);
        } else {
            super.registerListener(listener, filter, handback);
        }
    }

    @Override
    public void unregisterListener(KernelEventListener listener, KernelEventFilter filter, Object handback) throws Throwable {
        if (this.isParentKernelController()) {
            this.getParentKernelController().unregisterListener(listener, filter, handback);
        } else {
            super.unregisterListener(listener, filter, handback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<KernelControllerContext> getInstantiatedContexts(Class<?> clazz) {
        this.lockRead();
        try {
            Set parentContexts;
            HashSet<KernelControllerContext> contexts = new HashSet<KernelControllerContext>();
            Set<KernelControllerContext> currentContexts = super.getInstantiatedContexts(clazz);
            if (currentContexts != null && currentContexts.size() > 0) {
                contexts.addAll(currentContexts);
            }
            if (this.isParentKernelController() && (parentContexts = this.getParentKernelController().getInstantiatedContexts(clazz)) != null && parentContexts.size() > 0) {
                contexts.addAll(parentContexts);
            }
            HashSet<KernelControllerContext> hashSet = contexts.size() > 0 ? contexts : null;
            return hashSet;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<KernelControllerContext> getContexts(Class<?> clazz, ControllerState state) {
        this.lockRead();
        try {
            Set parentContexts;
            HashSet<KernelControllerContext> contexts = new HashSet<KernelControllerContext>();
            Set<KernelControllerContext> currentContexts = super.getContexts(clazz, state);
            if (currentContexts != null && currentContexts.size() > 0) {
                contexts.addAll(currentContexts);
            }
            if (this.isParentKernelController() && (parentContexts = this.getParentKernelController().getContexts(clazz, state)) != null && parentContexts.size() > 0) {
                contexts.addAll(parentContexts);
            }
            HashSet<KernelControllerContext> hashSet = contexts.size() > 0 ? contexts : null;
            return hashSet;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public KernelRegistryEntry getEntry(Object name) {
        KernelRegistryEntry entry = super.getEntry(name);
        if (entry != null) {
            return entry;
        }
        if (this.getParentController() instanceof KernelRegistryPlugin) {
            return ((KernelRegistryPlugin)this.getParentController()).getEntry(name);
        }
        return null;
    }

    private class ScopedKernelInitializer
    extends BasicKernelInitializer {
        protected KernelConfigurator createKernelConfigurator(Kernel kernel) throws Throwable {
            return ScopedKernelController.this.parentKernel.getConfigurator();
        }

        protected KernelController createKernelController(Kernel kernel) throws Throwable {
            return ScopedKernelController.this;
        }

        protected KernelMetaDataRepository createKernelMetaDataRepository(Kernel kernel) throws Throwable {
            return ScopedKernelController.this.parentKernel.getMetaDataRepository();
        }
    }

    private class ScopedKernelConfig
    extends PropertyKernelConfig {
        public ScopedKernelConfig(Properties properties) {
            super(properties);
        }

        public KernelInitializer createKernelInitializer() throws Throwable {
            return new ScopedKernelInitializer();
        }
    }
}

