/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.annotations.test.search;

import java.util.ArrayList;
import java.util.ListIterator;
import junit.framework.Test;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.test.kernel.annotations.support.SearchInjection;
import org.jboss.test.kernel.annotations.test.search.AbstractSearchAnnotationSupportTest;

public class BasicSearchAnnotationSupportTestCase
extends AbstractSearchAnnotationSupportTest {
    public BasicSearchAnnotationSupportTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return BasicSearchAnnotationSupportTestCase.suite(BasicSearchAnnotationSupportTestCase.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSearchTypes() throws Throwable {
        ArrayList<ControllerContext> contexts = new ArrayList<ControllerContext>();
        try {
            contexts.add(this.install("top", null, null, -1));
            contexts.add(this.install("parent", "main", null, -1));
            contexts.add(this.install("local", "main", "core", -1));
            contexts.add(this.install("child", "main", "core", 1));
            this.runAnnotationsOnClass(SearchInjection.class);
        }
        finally {
            ListIterator iter = contexts.listIterator(contexts.size());
            while (iter.hasPrevious()) {
                this.getController().uninstall(((ControllerContext)iter.previous()).getName());
            }
        }
    }

    protected void doTestAfterInstall(Object target) {
        SearchInjection si = (SearchInjection)target;
        this.assertScopeTester(si.getTop(), "top");
        this.assertScopeTester(si.getParent(), "parent");
        this.assertScopeTester(si.getLocal(), "local");
        this.assertScopeTester(si.getNormal(), "local");
        this.assertScopeTester(si.getWithChildren(), "local");
        this.assertScopeTester(si.getChildrenOnly(), "child");
        this.assertScopeTester(si.getLeaves(), "child");
    }
}

