/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.dependency.test;

import java.util.ArrayList;
import java.util.HashSet;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.dependency.support.SimpleBean;
import org.jboss.test.kernel.dependency.support.SimpleBeanImpl;
import org.jboss.test.kernel.dependency.support.SimpleBeanWithConstructorDependency;
import org.jboss.test.kernel.dependency.support.SimpleBeanWithConstructorDependencyImpl;
import org.jboss.test.kernel.dependency.test.OldAbstractKernelDependencyTest;

public class ConstructorDependencyTestCase
extends OldAbstractKernelDependencyTest {
    public static Test suite() {
        return ConstructorDependencyTestCase.suite(ConstructorDependencyTestCase.class);
    }

    public ConstructorDependencyTestCase(String name) throws Throwable {
        super(name);
    }

    public ConstructorDependencyTestCase(String name, boolean xmltest) throws Throwable {
        super(name, xmltest);
    }

    public void testConstructorDependencyCorrectOrder() throws Throwable {
        this.constructorDependencyCorrectOrder();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        ControllerContext context2 = this.assertInstall(1, "Name2");
        SimpleBean bean1 = (SimpleBean)context1.getTarget();
        ConstructorDependencyTestCase.assertNotNull((Object)bean1);
        ConstructorDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        SimpleBeanWithConstructorDependency bean2 = (SimpleBeanWithConstructorDependency)context2.getTarget();
        ConstructorDependencyTestCase.assertNotNull((Object)bean2);
        ConstructorDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        ConstructorDependencyTestCase.assertEquals((Object)bean1, (Object)bean2.getSimpleBean());
    }

    public void constructorDependencyCorrectOrder() throws Throwable {
        this.buildMetaData();
    }

    public void testConstructorDependencyWrongOrder() throws Throwable {
        this.constructorDependencyWrongOrder();
        ControllerContext context2 = this.assertInstall(1, "Name2", ControllerState.DESCRIBED);
        ControllerContext context1 = this.assertInstall(0, "Name1");
        ConstructorDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context2.getState());
        SimpleBean bean1 = (SimpleBean)context1.getTarget();
        ConstructorDependencyTestCase.assertNotNull((Object)bean1);
        ConstructorDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        SimpleBeanWithConstructorDependency bean2 = (SimpleBeanWithConstructorDependency)context2.getTarget();
        ConstructorDependencyTestCase.assertNotNull((Object)bean2);
        ConstructorDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        ConstructorDependencyTestCase.assertEquals((Object)bean1, (Object)bean2.getSimpleBean());
    }

    public void constructorDependencyWrongOrder() throws Throwable {
        this.buildMetaData();
    }

    public void testConstructorDependencyReinstall() throws Throwable {
        this.constructorDependencyReinstall();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        ControllerContext context2 = this.assertInstall(1, "Name2");
        SimpleBean bean1 = (SimpleBean)context1.getTarget();
        ConstructorDependencyTestCase.assertNotNull((Object)bean1);
        ConstructorDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        SimpleBeanWithConstructorDependency bean2 = (SimpleBeanWithConstructorDependency)context2.getTarget();
        ConstructorDependencyTestCase.assertNotNull((Object)bean2);
        ConstructorDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        ConstructorDependencyTestCase.assertEquals((Object)bean1, (Object)bean2.getSimpleBean());
        this.assertUninstall("Name1");
        ConstructorDependencyTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context1.getState());
        ConstructorDependencyTestCase.assertEquals((Object)ControllerState.DESCRIBED, (Object)context2.getState());
        this.assertNotInstalled("Name2");
        context2 = this.assertContext("Name2", ControllerState.DESCRIBED);
        context1 = this.assertInstall(0, "Name1");
        ConstructorDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context2.getState());
        bean1 = (SimpleBean)context1.getTarget();
        ConstructorDependencyTestCase.assertNotNull((Object)bean1);
        ConstructorDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        bean2 = (SimpleBeanWithConstructorDependency)context2.getTarget();
        ConstructorDependencyTestCase.assertNotNull((Object)bean2);
        ConstructorDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        ConstructorDependencyTestCase.assertEquals((Object)bean1, (Object)bean2.getSimpleBean());
        this.assertUninstall("Name2");
        ConstructorDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context1.getState());
        ConstructorDependencyTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context2.getState());
        bean1 = (SimpleBean)context1.getTarget();
        ConstructorDependencyTestCase.assertNotNull((Object)bean1);
        ConstructorDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        context2 = this.assertInstall(1, "Name2");
        bean1 = (SimpleBean)context1.getTarget();
        ConstructorDependencyTestCase.assertNotNull((Object)bean1);
        ConstructorDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        bean2 = (SimpleBeanWithConstructorDependency)context2.getTarget();
        ConstructorDependencyTestCase.assertNotNull((Object)bean2);
        ConstructorDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        ConstructorDependencyTestCase.assertEquals((Object)bean1, (Object)bean2.getSimpleBean());
    }

    public void constructorDependencyReinstall() throws Throwable {
        this.buildMetaData();
    }

    protected void buildMetaData() {
        AbstractBeanMetaData metaData1 = new AbstractBeanMetaData("Name1", SimpleBeanImpl.class.getName());
        HashSet<AbstractPropertyMetaData> attributes1 = new HashSet<AbstractPropertyMetaData>();
        attributes1.add(new AbstractPropertyMetaData("string", "String1"));
        metaData1.setProperties(attributes1);
        AbstractBeanMetaData metaData2 = new AbstractBeanMetaData("Name2", SimpleBeanWithConstructorDependencyImpl.class.getName());
        HashSet<AbstractPropertyMetaData> attributes2 = new HashSet<AbstractPropertyMetaData>();
        attributes2.add(new AbstractPropertyMetaData("string", "String2"));
        metaData2.setProperties(attributes2);
        ArrayList<AbstractParameterMetaData> constructor2 = new ArrayList<AbstractParameterMetaData>();
        constructor2.add(new AbstractParameterMetaData(SimpleBean.class.getName(), (ValueMetaData)new AbstractDependencyValueMetaData((Object)"Name1")));
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        metaData2.setConstructor((ConstructorMetaData)cmd);
        cmd.setParameters(constructor2);
        this.setBeanMetaDatas(new BeanMetaData[]{metaData1, metaData2});
    }
}

