/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.util.Set;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractCollectionMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.test.kernel.deployment.xml.test.AbstractMCTest;

public class CollectionJaxbTestCase
extends AbstractMCTest {
    protected AbstractCollectionMetaData getCollection() throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean();
        Set properties = bean.getProperties();
        CollectionJaxbTestCase.assertNotNull((Object)properties);
        CollectionJaxbTestCase.assertEquals((int)1, (int)properties.size());
        PropertyMetaData property = (PropertyMetaData)properties.iterator().next();
        CollectionJaxbTestCase.assertNotNull((Object)property);
        ValueMetaData value = property.getValue();
        CollectionJaxbTestCase.assertNotNull((Object)property);
        CollectionJaxbTestCase.assertTrue((boolean)(value instanceof AbstractCollectionMetaData));
        return (AbstractCollectionMetaData)value;
    }

    public void testCollection() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection();
        CollectionJaxbTestCase.assertNull((Object)collection.getType());
        CollectionJaxbTestCase.assertNull((Object)collection.getElementType());
    }

    public void testCollectionWithClass() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection();
        CollectionJaxbTestCase.assertEquals((String)"CollectionClass", (String)collection.getType());
        CollectionJaxbTestCase.assertNull((Object)collection.getElementType());
    }

    public void testCollectionWithElementClass() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection();
        CollectionJaxbTestCase.assertNull((Object)collection.getType());
        CollectionJaxbTestCase.assertEquals((String)"ElementClass", (String)collection.getElementType());
    }

    public void testCollectionWithValue() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection();
        CollectionJaxbTestCase.assertNull((Object)collection.getType());
        CollectionJaxbTestCase.assertNull((Object)collection.getElementType());
        this.assertValue("Value", this.getValue(collection));
    }

    public void testCollectionWithInjection() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection();
        CollectionJaxbTestCase.assertNull((Object)collection.getType());
        CollectionJaxbTestCase.assertNull((Object)collection.getElementType());
        this.assertInjection(this.getValue(collection));
    }

    public void testCollectionWithCollection() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection();
        CollectionJaxbTestCase.assertNull((Object)collection.getType());
        CollectionJaxbTestCase.assertNull((Object)collection.getElementType());
        this.assertCollection(this.getValue(collection));
    }

    public void testCollectionWithList() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection();
        CollectionJaxbTestCase.assertNull((Object)collection.getType());
        CollectionJaxbTestCase.assertNull((Object)collection.getElementType());
        this.assertList(this.getValue(collection));
    }

    public void testCollectionWithSet() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection();
        CollectionJaxbTestCase.assertNull((Object)collection.getType());
        CollectionJaxbTestCase.assertNull((Object)collection.getElementType());
        this.assertSet(this.getValue(collection));
    }

    public void testCollectionWithArray() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection();
        CollectionJaxbTestCase.assertNull((Object)collection.getType());
        CollectionJaxbTestCase.assertNull((Object)collection.getElementType());
        this.assertArray(this.getValue(collection));
    }

    public void testCollectionWithMap() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection();
        CollectionJaxbTestCase.assertNull((Object)collection.getType());
        CollectionJaxbTestCase.assertNull((Object)collection.getElementType());
        this.assertMap(this.getValue(collection));
    }

    public void testCollectionWithNull() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection();
        CollectionJaxbTestCase.assertNull((Object)collection.getType());
        CollectionJaxbTestCase.assertNull((Object)collection.getElementType());
        this.assertNullValue(this.getValue(collection));
    }

    public void testCollectionWithThis() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection();
        CollectionJaxbTestCase.assertNull((Object)collection.getType());
        CollectionJaxbTestCase.assertNull((Object)collection.getElementType());
        this.assertThis(this.getValue(collection));
    }

    public void testCollectionWithWildcard() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection();
        CollectionJaxbTestCase.assertNull((Object)collection.getType());
        CollectionJaxbTestCase.assertNull((Object)collection.getElementType());
        this.assertWildcard(this.getValue(collection));
    }

    public void testCollectionWithBean() throws Exception {
        AbstractCollectionMetaData collection = this.getCollection();
        CollectionJaxbTestCase.assertNull((Object)collection.getType());
        CollectionJaxbTestCase.assertNull((Object)collection.getElementType());
        this.assertBean(this.getValue(collection));
    }

    protected ValueMetaData getValue(AbstractCollectionMetaData collection) {
        CollectionJaxbTestCase.assertEquals((int)1, (int)collection.size());
        return (ValueMetaData)collection.iterator().next();
    }

    public static Test suite() {
        return CollectionJaxbTestCase.suite(CollectionJaxbTestCase.class);
    }

    public CollectionJaxbTestCase(String name) {
        super(name);
    }
}

