/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.plugins.AbstractControllerContext;
import org.jboss.dependency.plugins.AbstractDependencyInfo;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContextActions;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.dependency.spi.ScopeInfo;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.plugins.dependency.CallbackDependencyItem;
import org.jboss.kernel.plugins.dependency.ClassContextDependencyItem;
import org.jboss.kernel.plugins.dependency.ClassDependencyItem;
import org.jboss.kernel.plugins.dependency.DescribedMetaDataVisitor;
import org.jboss.kernel.plugins.dependency.KernelControllerContextActions;
import org.jboss.kernel.plugins.dependency.KernelScopeInfo;
import org.jboss.kernel.plugins.dependency.PreprocessMetaDataVisitor;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.util.JBossStringBuilder;

public class AbstractKernelControllerContext
extends AbstractControllerContext
implements KernelControllerContext {
    private static final KernelControllerContextActions actions = KernelControllerContextActions.getInstance();
    private static final KernelControllerContextActions noInstantiate = KernelControllerContextActions.getNoInstantiate();
    protected BeanInfo info;
    protected BeanMetaData metaData;
    protected AccessControlContext accessContext;
    protected boolean isInitialProcessed;
    protected boolean isDescribeProcessed;

    public AbstractKernelControllerContext(BeanInfo info, BeanMetaData metaData, Object target) {
        super((Object)metaData.getName(), metaData.getAliases(), (ControllerContextActions)(target == null ? actions : noInstantiate), (DependencyInfo)new AbstractDependencyInfo(), target);
        this.info = info;
        this.metaData = metaData;
        ControllerMode mode = metaData.getMode();
        if (mode != null) {
            this.setMode(mode);
        }
        boolean autowireCandidate = metaData.isAutowireCandidate();
        this.getDependencyInfo().setAutowireCandidate(autowireCandidate);
        if (System.getSecurityManager() != null) {
            this.accessContext = AccessController.getContext();
        }
        this.initKernelScopeInfo();
    }

    public Kernel getKernel() {
        KernelController controller = (KernelController)this.getController();
        if (controller == null) {
            throw new IllegalStateException("Context is not installed in controller");
        }
        return controller.getKernel();
    }

    public BeanInfo getBeanInfo() {
        return this.info;
    }

    public void setBeanInfo(BeanInfo info) {
        this.info = info;
        this.infoprocessMetaData();
        this.flushJBossObjectCache();
    }

    public BeanMetaData getBeanMetaData() {
        return this.metaData;
    }

    public void toString(JBossStringBuilder buffer) {
        if (this.metaData != null) {
            buffer.append(" metadata=").append((Object)this.metaData);
        }
        super.toString(buffer);
    }

    public void setController(Controller controller) {
        super.setController(controller);
        this.preprocessMetaData();
    }

    protected void initScopeInfo() {
    }

    protected void initKernelScopeInfo() {
        String bean;
        BeanMetaData bmd;
        String className = null;
        Object target = this.getTarget();
        if (target != null) {
            className = target.getClass().getName();
        }
        if ((bmd = this.getBeanMetaData()) != null && (bean = bmd.getBean()) != null) {
            className = bean;
        }
        this.setScopeInfo((ScopeInfo)new KernelScopeInfo(this.getName(), className));
    }

    protected void preprocessMetaData() {
        if (this.metaData == null) {
            return;
        }
        if (this.isInitialProcessed) {
            return;
        }
        PreprocessMetaDataVisitor visitor = new PreprocessMetaDataVisitor(this.metaData, this);
        AccessController.doPrivileged(visitor);
        this.isInitialProcessed = true;
    }

    protected void infoprocessMetaData() {
        if (this.info == null) {
            this.removeClassContextReference();
            return;
        }
        if (this.isDescribeProcessed) {
            return;
        }
        DescribedMetaDataVisitor visitor = new DescribedMetaDataVisitor(this.metaData, this);
        AccessController.doPrivileged(visitor);
        this.isDescribeProcessed = true;
    }

    protected AccessControlContext getAccessControlContext() {
        return this.accessContext;
    }

    private void removeClassContextReference() {
        DependencyInfo dependencyInfo = this.getDependencyInfo();
        if (dependencyInfo != null) {
            Set dependencys = dependencyInfo.getIDependOn(ClassContextDependencyItem.class);
            dependencys.addAll(dependencyInfo.getIDependOn(CallbackDependencyItem.class));
            for (DependencyItem di : dependencys) {
                ClassDependencyItem cdi = (ClassDependencyItem)di;
                cdi.clear(this.getController());
            }
        }
    }

    public Object get(String name) throws Throwable {
        if (this.info == null) {
            throw new IllegalArgumentException("Null BeanInfo");
        }
        return this.info.getProperty(this.getTarget(), name);
    }

    public void set(String name, Object value) throws Throwable {
        if (this.info == null) {
            throw new IllegalArgumentException("Null BeanInfo");
        }
        this.info.setProperty(this.getTarget(), name, value);
    }

    public Object invoke(String name, Object[] parameters, String[] signature) throws Throwable {
        if (this.info == null) {
            throw new IllegalArgumentException("Null BeanInfo");
        }
        return this.info.invoke(this.getTarget(), name, signature, parameters);
    }

    public ClassLoader getClassLoader() throws Throwable {
        return Configurator.getClassLoader(this.getBeanMetaData());
    }
}

