/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.util.ArrayList;
import java.util.Collection;
import org.jboss.beans.metadata.plugins.AbstractListMetaData;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractArrayMetaData
extends AbstractListMetaData {
    private static final long serialVersionUID = 1L;

    @Override
    public Object getValue(TypeInfo info, ClassLoader cl) throws Throwable {
        Collection result = (Collection)super.getValue(info, cl);
        ClassInfo typeInfo = this.getClassInfo(cl);
        if (typeInfo != null && !(typeInfo instanceof ClassInfo)) {
            throw new IllegalArgumentException(typeInfo.getName() + " is not a class");
        }
        if (typeInfo == null) {
            if (info == null) {
                info = this.getElementClassInfo(cl, null);
                if (info == null) {
                    return null;
                }
                info = info.getArrayType();
            }
            if (!(info instanceof ClassInfo)) {
                return null;
            }
            if (((ClassInfo)info).isInterface()) {
                return null;
            }
            if (Object.class.getName().equals(info.getName())) {
                return null;
            }
            typeInfo = info;
        }
        Object[] array = typeInfo.newArrayInstance(result.size());
        return result.toArray(array);
    }

    @Override
    protected <T> T getTypeInstance(TypeInfo info, ClassLoader cl, Class<T> expected) throws Throwable {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] preinstantiatedObject = this.preinstantiatedLookup(cl, Object[].class);
        if (preinstantiatedObject != null) {
            Object[] preinstantiatedArray;
            for (Object previous : preinstantiatedArray = preinstantiatedObject) {
                result.add(previous);
            }
        }
        return expected.cast(result);
    }

    @Override
    protected <T> T checkResult(Object result, Class<T> expected) {
        if (result != null && !result.getClass().isArray()) {
            throw new ClassCastException("Preinstantiated property is not an array: " + this.propertyName);
        }
        return expected.cast(result);
    }
}

