/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import org.jboss.beans.metadata.plugins.AbstractTypeMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.logging.Logger;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.TypeInfo;

public class StringValueMetaData
extends AbstractTypeMetaData {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(StringValueMetaData.class);
    private boolean replace = true;

    public StringValueMetaData() {
    }

    public StringValueMetaData(String value) {
        super(value);
    }

    public void setValue(String value) {
        super.setValue(value);
    }

    public void setValue(Object value) {
        if (value != null && !(value instanceof String)) {
            throw new ClassCastException("value is not a String: " + value);
        }
        super.setValue(value);
    }

    public Object getValue(TypeInfo info, ClassLoader cl) throws Throwable {
        ClassInfo typeInfo;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("getValue value=" + this.getUnderlyingValue() + " type=" + this.type + " info=" + info));
        }
        if ((typeInfo = this.getClassInfo(cl)) == null) {
            typeInfo = info;
        }
        if (typeInfo == null) {
            throw new IllegalArgumentException("Unable to determine type for value: " + this.getUnderlyingValue());
        }
        if (typeInfo != info && info != null) {
            Object typeValue = typeInfo.convertValue(this.getUnderlyingValue());
            return info.convertValue(typeValue, this.replace);
        }
        return typeInfo.convertValue(this.getUnderlyingValue(), this.replace);
    }

    protected Object getDefaultInstance() {
        return null;
    }

    public TypeInfo getType(MetaDataVisitor visitor, MetaDataVisitorNode previous) throws Throwable {
        if (this.getType() != null) {
            return this.getClass(visitor, this.getType());
        }
        return super.getType(visitor, previous);
    }

    public boolean isReplace() {
        return this.replace;
    }

    public void setReplace(boolean replace) {
        this.replace = replace;
    }
}

